/*
 * Decompiled with CFR 0.152.
 */
package com.Portality.ccomunityboxes.painter;

import com.Portality.ccomunityboxes.Ccomunityboxes;
import com.Portality.ccomunityboxes.painter.BoxBlockEntity;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class PainterBE
extends SmartBlockEntity {
    private boolean finishedCraft = false;
    public int craftProgress = 0;
    public int prevCraftProgress = 0;
    private int maxCraftProgress = 30;
    public ItemStack heldStack = ItemStack.EMPTY;
    public boolean splashed = false;
    public boolean rareSplashed = false;
    private FilteringBehaviour filtering;

    public PainterBE(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new PainterValueBox(this));
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BoxBlockEntity.PAINTER.get(), (be, side) -> new ItemHandlerImpl((PainterBE)((Object)be)));
    }

    public ItemStack getRenderedBox() {
        return this.heldStack;
    }

    public void tick() {
        super.tick();
        this.prevCraftProgress = this.craftProgress;
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.above());
        if (!(blockEntity instanceof SpoutBlockEntity)) {
            return;
        }
        SpoutBlockEntity spoutBlockEntity = (SpoutBlockEntity)blockEntity;
        if (!this.level.isClientSide && PackageItem.isPackage((ItemStack)this.heldStack)) {
            if (this.craftProgress < this.maxCraftProgress) {
                if (this.craftProgress == 5) {
                    if (this.splashed) {
                        ++this.craftProgress;
                        this.splashed = false;
                    }
                } else {
                    ++this.craftProgress;
                }
                if (this.craftProgress == 15) {
                    this.switchBox();
                }
                this.setChanged();
                this.notifyUpdate();
            } else if (!this.finishedCraft) {
                this.finishedCraft = true;
                this.setChanged();
                this.notifyUpdate();
            }
        }
    }

    private void switchBox() {
        ItemContainerContents tag = (ItemContainerContents)this.heldStack.get(AllDataComponents.PACKAGE_CONTENTS);
        ItemStack newStack = PackageItem.isPackage((ItemStack)this.filtering.getFilter()) ? this.filtering.getFilter() : Ccomunityboxes.getRandomBox(this.level.random);
        if (!this.rareSplashed) {
            Item item = this.filtering.getFilter().getItem();
            if (item instanceof PackageItem) {
                PackageItem packageItem = (PackageItem)item;
                if (packageItem.style.rare()) {
                    newStack = Ccomunityboxes.getRandomBox(this.level.random);
                }
            }
        } else if (!PackageItem.isPackage((ItemStack)this.filtering.getFilter())) {
            newStack = Ccomunityboxes.getRandomRareBox(this.level.random);
        }
        this.rareSplashed = false;
        newStack.set(AllDataComponents.PACKAGE_CONTENTS, (Object)tag);
        this.heldStack = newStack;
    }

    public float getInOutProgress(float partialTicks) {
        if (this.craftProgress <= 5) {
            return this.getInterpolated(partialTicks, this.craftProgress, this.prevCraftProgress) - 0.5f;
        }
        if (this.craftProgress >= this.maxCraftProgress - 5) {
            return this.getInterpolated(partialTicks, this.craftProgress - (this.maxCraftProgress - 5), this.prevCraftProgress - (this.maxCraftProgress - 5));
        }
        return 0.0f;
    }

    private float getInterpolated(float pt, int craftProgress, int prevCraftProgress) {
        return Mth.lerp((float)pt, (float)prevCraftProgress, (float)craftProgress) * 0.1f;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.finishedCraft = compound.getBoolean("finishedCraft");
        this.craftProgress = compound.getInt("craftProgress");
        if (!compound.getCompound("heldStack").isEmpty()) {
            this.heldStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("heldStack"));
            if (this.heldStack.getItem() == Blocks.BARRIER.asItem()) {
                this.heldStack = ItemStack.EMPTY;
            }
        }
        this.splashed = compound.getBoolean("splashed");
        this.rareSplashed = compound.getBoolean("rareSplashed");
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        CompoundTag nbt = new CompoundTag();
        compound.putBoolean("finishedCraft", this.finishedCraft);
        compound.putInt("craftProgress", this.craftProgress);
        if (!this.heldStack.isEmpty()) {
            compound.put("heldStack", this.heldStack.save(registries));
        }
        compound.putBoolean("splashed", this.splashed);
        compound.putBoolean("rareSplashed", this.rareSplashed);
        super.write(compound, registries, clientPacket);
    }

    class PainterValueBox
    extends ValueBoxTransform.Sided {
        PainterValueBox(PainterBE this$0) {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)4.0, (double)16.05);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.getAxis().isHorizontal();
        }
    }

    public static class ItemHandlerImpl
    implements IItemHandler {
        private final int OUTPUT_SLOT = 0;
        private final int SLOT_COUNT = 1;
        private final PainterBE blockEntity;

        public ItemHandlerImpl(PainterBE blockEntity) {
            this.blockEntity = blockEntity;
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return this.blockEntity.heldStack;
            }
            return ItemStack.EMPTY;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!(stack.getItem() instanceof PackageItem)) {
                return stack;
            }
            if (PackageItem.isPackage((ItemStack)this.blockEntity.heldStack)) {
                return stack;
            }
            if (!simulate) {
                this.blockEntity.craftProgress = 0;
                this.blockEntity.finishedCraft = false;
            }
            this.blockEntity.heldStack = stack.copy();
            this.blockEntity.setChanged();
            this.blockEntity.notifyUpdate();
            ItemStack result = ItemStack.EMPTY;
            return result;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0 || amount <= 0 || this.blockEntity.heldStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (!this.blockEntity.finishedCraft) {
                return ItemStack.EMPTY;
            }
            ItemStack filter = this.blockEntity.filtering.getFilter();
            int extractCount = Math.min(amount, this.blockEntity.heldStack.getCount());
            ItemStack extracted = this.blockEntity.heldStack.copyWithCount(extractCount);
            if (!simulate) {
                this.blockEntity.finishedCraft = false;
                this.blockEntity.craftProgress = 0;
                this.blockEntity.prevCraftProgress = 0;
                this.blockEntity.heldStack.shrink(extractCount);
                if (this.blockEntity.heldStack.isEmpty()) {
                    this.blockEntity.heldStack = ItemStack.EMPTY;
                }
                this.blockEntity.setChanged();
                this.blockEntity.notifyUpdate();
            }
            this.blockEntity.filtering.setFilter(filter);
            return extracted;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot == 0 && stack.getItem() instanceof PackageItem;
        }
    }
}

