/*
 * Decompiled with CFR 0.152.
 */
package me.elijah.more_shearable_mobs.client.renderer;

import com.google.common.collect.Maps;
import java.util.Map;
import me.elijah.more_shearable_mobs.ShearDataTrackers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10042;
import net.minecraft.class_1047;
import net.minecraft.class_10602;
import net.minecraft.class_10730;
import net.minecraft.class_10731;
import net.minecraft.class_10733;
import net.minecraft.class_10750;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_560;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_927;

@Environment(value=EnvType.CLIENT)
public class ShearableCowEntityRenderer
extends class_927<class_10730, class_10750, class_560> {
    private final Map<class_10731.class_10732, class_10602<class_560>> babyModelPairMap;
    private static final class_2960 SHEARED_TEXTURE_TEMP = class_2960.method_60655((String)"more_shearable_mobs", (String)"textures/entity/cow/shearedcow_temperate.png");
    private static final class_2960 SHEARED_TEXTURE_WARM = class_2960.method_60655((String)"more_shearable_mobs", (String)"textures/entity/cow/shearedcow_warm.png");
    private static final class_2960 SHEARED_TEXTURE_COLD = class_2960.method_60655((String)"more_shearable_mobs", (String)"textures/entity/cow/shearedcow_cold.png");
    private static final class_2960 BUTCHERED_TEXTURE_TEMP = class_2960.method_60655((String)"more_shearable_mobs", (String)"textures/entity/cow/skelecow_temperate.png");
    private static final class_2960 BUTCHERED_TEXTURE_WARM = class_2960.method_60655((String)"more_shearable_mobs", (String)"textures/entity/cow/skelecow_warm.png");
    private static final class_2960 BUTCHERED_TEXTURE_COLD = class_2960.method_60655((String)"more_shearable_mobs", (String)"textures/entity/cow/skelecow_cold.png");

    public ShearableCowEntityRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new class_560(context.method_32167(class_5602.field_27698)), 0.7f);
        this.babyModelPairMap = ShearableCowEntityRenderer.createBabyModelPairMap(context);
    }

    private static Map<class_10731.class_10732, class_10602<class_560>> createBabyModelPairMap(class_5617.class_5618 context) {
        return Maps.newEnumMap(Map.of(class_10731.class_10732.field_56429, new class_10602((class_3879)new class_560(context.method_32167(class_5602.field_27698)), (class_3879)new class_560(context.method_32167(class_5602.field_52959))), class_10731.class_10732.field_56431, new class_10602((class_3879)new class_560(context.method_32167(class_5602.field_56496)), (class_3879)new class_560(context.method_32167(class_5602.field_56497))), class_10731.class_10732.field_56430, new class_10602((class_3879)new class_560(context.method_32167(class_5602.field_56494)), (class_3879)new class_560(context.method_32167(class_5602.field_56495)))));
    }

    public class_10750 createRenderState() {
        return new ShearableCowRenderState();
    }

    public void updateRenderState(class_10730 cow, class_10750 state, float tickDelta) {
        super.method_62355((class_1309)cow, (class_10042)state, tickDelta);
        state.field_56507 = (class_10731)cow.method_67349().comp_349();
        ((ShearableCowRenderState)state).cowEntity = cow;
    }

    public class_2960 getTexture(class_10750 state) {
        class_10730 cow = ((ShearableCowRenderState)state).cowEntity;
        if (!cow.method_6109() && ((Boolean)cow.method_5841().method_12789(ShearDataTrackers.IS_COW_BUTCHERED)).booleanValue()) {
            if (((class_5321)cow.method_67349().method_40230().orElseThrow()).equals(class_10733.field_56436)) {
                return BUTCHERED_TEXTURE_WARM;
            }
            if (((class_5321)cow.method_67349().method_40230().orElseThrow()).equals(class_10733.field_56437)) {
                return BUTCHERED_TEXTURE_COLD;
            }
            return BUTCHERED_TEXTURE_TEMP;
        }
        if (((Boolean)cow.method_5841().method_12789(ShearDataTrackers.IS_COW_SHEARED)).booleanValue()) {
            if (((class_5321)cow.method_67349().method_40230().orElseThrow()).equals(class_10733.field_56436)) {
                return SHEARED_TEXTURE_WARM;
            }
            if (((class_5321)cow.method_67349().method_40230().orElseThrow()).equals(class_10733.field_56437)) {
                return SHEARED_TEXTURE_COLD;
            }
            return SHEARED_TEXTURE_TEMP;
        }
        return state.field_56507 == null ? class_1047.method_4539() : state.field_56507.comp_3632().comp_3573().comp_3627();
    }

    public void render(class_10750 cowEntityRenderState, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        if (cowEntityRenderState.field_56507 != null) {
            this.field_4737 = (class_560)this.babyModelPairMap.get(cowEntityRenderState.field_56507.comp_3632().comp_3572()).method_66533(cowEntityRenderState.field_53457);
            super.method_4054((class_10042)cowEntityRenderState, matrixStack, vertexConsumerProvider, i);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ShearableCowRenderState
    extends class_10750 {
        public class_10730 cowEntity;
    }
}

