/*
 * Decompiled with CFR 0.152.
 */
package de.smallinger.chatcalc;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import de.smallinger.chatcalc.ChatHelper;
import de.smallinger.chatcalc.Config;
import de.smallinger.chatcalc.CustomConstant;
import de.smallinger.chatcalc.CustomFunction;
import de.smallinger.chatcalc.FunctionParameter;
import de.smallinger.chatcalc.Testcases;
import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ChatCalculator {
    public static final HashSet<String> CONSTANT_TABLE = new HashSet();
    public static final HashSet<Pair<String, Integer>> FUNCTION_TABLE = new HashSet();
    public static final Pattern NUMBER = Pattern.compile("[-+]?(\\d,?)*(\\.\\d+)?");
    public static final Pattern FUNCTION = Pattern.compile("[a-zA-Z]+\\(([a-zA-Z]+;)*?([a-zA-Z]+)\\)");
    public static final Pattern CONSTANT = Pattern.compile("[a-zA-Z]+");
    public static final String SEPARATOR = ";";
    public static final char SEPARATOR_CHAR = ';';

    @Contract(value="_->_", mutates="param1")
    public static boolean tryParse(@NotNull EditBox field) {
        MutableComponent line;
        MutableComponent msg;
        int cursor;
        Minecraft client = Minecraft.getInstance();
        String originalText = field.getValue();
        String text = ChatHelper.getSection(originalText, cursor = field.getCursorPosition());
        String[] split = text.split("=");
        if (split.length == 2) {
            if (Config.JSON.has(split[0])) {
                Config.JSON.addProperty(split[0], split[1]);
                Config.refreshJson();
                return ChatHelper.replaceSection(field, "");
            }
            either = ChatCalculator.parseDeclaration(text);
            if (either.isPresent()) {
                left = either.get().left();
                right = either.get().right();
                if (left.isPresent()) {
                    Config.FUNCTIONS.put((Pair<String, Integer>)new Pair((Object)((CustomFunction)left.get()).name(), (Object)((CustomFunction)left.get()).params().length), (CustomFunction)left.get());
                    Config.refreshJson();
                    return ChatHelper.replaceSection(field, "");
                }
                if (right.isPresent()) {
                    Config.CONSTANTS.put(((CustomConstant)right.get()).name(), (CustomConstant)right.get());
                    Config.refreshJson();
                    return ChatHelper.replaceSection(field, "");
                }
            }
        } else if (split.length == 1) {
            if (Config.JSON.has(split[0])) {
                return ChatHelper.replaceSection(field, Config.JSON.get(split[0]).getAsString());
            }
            if (!split[0].isEmpty() && Config.JSON.has(split[0].substring(0, split[0].length() - 1)) && split[0].endsWith("?") && client.player != null) {
                client.player.displayClientMessage((Component)Component.translatable((String)("chatcal." + split[0].substring(0, split[0].length() - 1) + ".description")), false);
                return false;
            }
            either = ChatCalculator.parseDeclaration(text);
            if (either.isPresent()) {
                left = either.get().left();
                right = ((Either)either.get()).right();
                if (left.isPresent()) {
                    Pair pair = new Pair((Object)((CustomFunction)left.get()).name(), (Object)((CustomFunction)left.get()).params().length);
                    if (Config.FUNCTIONS.containsKey(pair)) {
                        Config.FUNCTIONS.remove(pair);
                        Config.refreshJson();
                        return ChatHelper.replaceSection(field, "");
                    }
                } else if (right.isPresent() && Config.CONSTANTS.containsKey(((CustomConstant)right.get()).name())) {
                    Config.CONSTANTS.remove(((CustomConstant)right.get()).name());
                    Config.refreshJson();
                    return ChatHelper.replaceSection(field, "");
                }
            }
        }
        if ((text.equals("config?") || text.equals("cfg?") || text.equals("?")) && client.player != null) {
            client.player.displayClientMessage((Component)Component.translatable((String)"chatcal.config.description"), false);
            return false;
        }
        if (text.equals("testcases?")) {
            Testcases.test(Testcases.TESTCASES);
            return false;
        }
        if (text.equals("functions?")) {
            msg = Component.literal((String)"Currently defined custom functions are:");
            for (CustomFunction func : Config.FUNCTIONS.values()) {
                String funcStr = func.toString();
                line = Component.literal((String)("\n" + funcStr));
                line.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(funcStr)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Click to copy to clipboard"))));
                msg.append((Component)line);
            }
            client.player.displayClientMessage((Component)msg, false);
            return false;
        }
        if (text.equals("constants?")) {
            msg = Component.literal((String)"Currently defined custom constants are:");
            for (CustomConstant constant : Config.CONSTANTS.values()) {
                String constStr = constant.toString();
                line = Component.literal((String)("\n" + constStr));
                line.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(constStr)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Click to copy to clipboard"))));
                msg.append((Component)line);
            }
            client.player.displayClientMessage((Component)msg, false);
            return false;
        }
        if (NUMBER.matcher(text).matches()) {
            return false;
        }
        boolean add = false;
        if (text.endsWith("=")) {
            text = text.substring(0, text.length() - 1);
            add = true;
        }
        try {
            long start = System.nanoTime();
            CONSTANT_TABLE.clear();
            FUNCTION_TABLE.clear();
            double result = Config.makeEngine().eval(text, new FunctionParameter[0]);
            double micros = (double)(System.nanoTime() - start) / 1000.0;
            String solution = Config.getDecimalFormat().format(result);
            if (solution.equals("-0")) {
                solution = "0";
            }
            Config.saveToChatHud(originalText);
            Config.saveToClipboard(originalText);
            return add ? ChatHelper.addSectionAfterIndex(field, solution) : ChatHelper.replaceSection(field, solution);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Optional<Either<CustomFunction, CustomConstant>> parseDeclaration(String text) {
        return CustomFunction.fromString(text).map(Either::left).or(() -> CustomConstant.fromString(text).map(Either::right));
    }
}

