/*
 * Decompiled with CFR 0.152.
 */
package de.smallinger.chatcalc;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import de.smallinger.chatcalc.CustomConstant;
import de.smallinger.chatcalc.CustomFunction;
import de.smallinger.chatcalc.MathEngine;
import de.smallinger.chatcalc.NibbleMathEngine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;

public class Config {
    public static final JsonObject JSON;
    public static final Gson GSON;
    public static final File CONFIG_FILE;
    public static final Map<Pair<String, Integer>, CustomFunction> FUNCTIONS;
    public static final Map<String, CustomConstant> CONSTANTS;
    public static final ImmutableMap<String, String> DEFAULTS;

    public static DecimalFormat getDecimalFormat() {
        return new DecimalFormat(JSON.get("decimal_format").getAsString());
    }

    public static double convertFromDegrees(double value) {
        return Boolean.parseBoolean(JSON.get("radians").getAsString()) ? Math.toRadians(value) : value;
    }

    public static double convertFromRadians(double value) {
        return Boolean.parseBoolean(JSON.get("radians").getAsString()) ? value : Math.toDegrees(value);
    }

    public static double convertToRadians(double value) {
        return Boolean.parseBoolean(JSON.get("radians").getAsString()) ? value : Math.toRadians(value);
    }

    public static boolean radians() {
        return Boolean.parseBoolean(JSON.get("radians").getAsString());
    }

    public static void refreshJson() {
        try {
            FileWriter writer = new FileWriter(CONFIG_FILE);
            JSON.add("functions", (JsonElement)FUNCTIONS.values().stream().map(Object::toString).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
            JSON.add("constants", (JsonElement)CONSTANTS.values().stream().map(Object::toString).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
            writer.write(GSON.toJson((JsonElement)JSON));
            JSON.remove("functions");
            JSON.remove("constants");
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void readJson() {
        try (BufferedReader reader = new BufferedReader(new FileReader(CONFIG_FILE));){
            JsonArray array;
            var json = new Object(){
                JsonObject obj;
            };
            try {
                json.obj = JsonParser.parseString((String)reader.lines().collect(Collectors.joining("\n"))).getAsJsonObject();
            }
            catch (Exception ignored) {
                json.obj = new JsonObject();
            }
            DEFAULTS.forEach((key, defaultValue) -> {
                JsonPrimitive primitive;
                JsonElement patt0$temp = json.obj.get(key);
                JSON.add(key, (JsonElement)(patt0$temp instanceof JsonPrimitive && (primitive = (JsonPrimitive)patt0$temp).isString() ? primitive : new JsonPrimitive(defaultValue)));
            });
            Object object = json.obj.get("functions");
            if (object instanceof JsonArray) {
                array = (JsonArray)object;
                array.forEach(e -> {
                    JsonPrimitive primitive;
                    if (e instanceof JsonPrimitive && (primitive = (JsonPrimitive)e).isString()) {
                        CustomFunction.fromString(e.getAsString()).ifPresent(func -> FUNCTIONS.put((Pair<String, Integer>)new Pair((Object)func.name(), (Object)func.params().length), (CustomFunction)func));
                    }
                });
            }
            if ((object = json.obj.get("constants")) instanceof JsonArray) {
                array = (JsonArray)object;
                for (JsonElement e2 : array) {
                    JsonPrimitive primitive;
                    if (!(e2 instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)e2).isString()) continue;
                    CustomConstant.fromString(e2.getAsString()).ifPresent(constant -> CONSTANTS.put(constant.name(), (CustomConstant)constant));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean displayAbove() {
        return Boolean.parseBoolean(JSON.get("display_above").getAsString());
    }

    public static void saveToChatHud(String input) {
        if (JSON.get("copy_type").getAsString().equalsIgnoreCase("chat_history")) {
            // empty if block
        }
    }

    public static double func(String name, double ... values) {
        CustomFunction func = FUNCTIONS.get(new Pair((Object)name, (Object)values.length));
        if (func != null) {
            return func.get(values);
        }
        throw new IllegalArgumentException("Tried to call unknown function: " + name);
    }

    public static void saveToClipboard(String input) {
        if (JSON.get("copy_type").getAsString().equalsIgnoreCase("clipboard")) {
            Minecraft client = Minecraft.getInstance();
            client.keyboardHandler.setClipboard(input);
        }
    }

    public static MathEngine makeEngine() {
        return new NibbleMathEngine();
    }

    static {
        DEFAULTS = ImmutableMap.builder().put((Object)"decimal_format", (Object)"#,##0.##").put((Object)"radians", (Object)"false").put((Object)"copy_type", (Object)"chat_history").put((Object)"display_above", (Object)"true").build();
        CONFIG_FILE = new File(".", "config/chatcal.json");
        GSON = new GsonBuilder().setPrettyPrinting().create();
        JSON = new JsonObject();
        File dir = new File(".", "config");
        if ((dir.exists() && dir.isDirectory() || dir.mkdirs()) && !CONFIG_FILE.exists()) {
            try {
                CONFIG_FILE.createNewFile();
                FileWriter writer = new FileWriter(CONFIG_FILE);
                writer.write("{\n");
                for (Map.Entry element : DEFAULTS.entrySet()) {
                    writer.write(String.format("    \"%s\": \"%s\",\n", element.getKey(), element.getValue()));
                }
                writer.write("    \"functions\": []\n");
                writer.write("}");
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FUNCTIONS = new HashMap<Pair<String, Integer>, CustomFunction>();
        CONSTANTS = new HashMap<String, CustomConstant>();
        if (CONFIG_FILE.exists() && CONFIG_FILE.isFile() && CONFIG_FILE.canRead()) {
            Config.readJson();
        }
    }
}

