/*
 * Decompiled with CFR 0.152.
 */
package de.smallinger.chatcalc;

import de.smallinger.chatcalc.ChatCalculator;
import de.smallinger.chatcalc.Config;
import de.smallinger.chatcalc.FunctionParameter;
import java.util.Optional;

public record CustomConstant(String name, String eval) {
    public static Optional<CustomConstant> fromString(String text) {
        int equalsIdx = text.indexOf(61);
        if (equalsIdx == -1) {
            return Optional.empty();
        }
        String lhs = text.substring(0, equalsIdx);
        String rhs = text.substring(equalsIdx + 1);
        if (!ChatCalculator.CONSTANT.matcher(lhs).matches()) {
            return Optional.empty();
        }
        return Optional.of(new CustomConstant(lhs, rhs));
    }

    public double get() {
        if (ChatCalculator.CONSTANT_TABLE.contains(this.name)) {
            throw new IllegalArgumentException("Tried to compute constant a second time, recursively");
        }
        ChatCalculator.CONSTANT_TABLE.add(this.name);
        double value = Config.makeEngine().eval(this.eval, new FunctionParameter[0]);
        ChatCalculator.CONSTANT_TABLE.remove(this.name);
        return value;
    }

    @Override
    public String toString() {
        return this.name + "=" + this.eval;
    }
}

