/*
 * Decompiled with CFR 0.152.
 */
package de.smallinger.chatcalc;

import com.mojang.datafixers.util.Pair;
import de.smallinger.chatcalc.ChatCalculator;
import de.smallinger.chatcalc.Config;
import de.smallinger.chatcalc.FunctionParameter;
import java.util.Optional;

public record CustomFunction(String name, String eval, String[] params) {
    public static Optional<CustomFunction> fromString(String text) {
        int equalsIdx = text.indexOf(61);
        if (equalsIdx == -1) {
            return Optional.empty();
        }
        String lhs = text.substring(0, equalsIdx);
        String rhs = text.substring(equalsIdx + 1);
        if (!ChatCalculator.FUNCTION.matcher(lhs).matches()) {
            return Optional.empty();
        }
        int functionNameEnd = lhs.indexOf(40);
        String functionName = lhs.substring(0, functionNameEnd);
        int paramsEnd = lhs.substring(functionNameEnd).indexOf(41) + functionNameEnd;
        String[] params = lhs.substring(functionNameEnd + 1, paramsEnd).split(";");
        return Optional.of(new CustomFunction(functionName, rhs, params));
    }

    public double get(double ... values) {
        if (values.length != this.params.length) {
            throw new IllegalArgumentException("Invalid amount of arguments for custom function");
        }
        Pair pair = new Pair((Object)this.name, (Object)this.params.length);
        if (ChatCalculator.FUNCTION_TABLE.contains(pair)) {
            throw new IllegalArgumentException("Tried to call function twice, recursively");
        }
        FunctionParameter[] parameters = new FunctionParameter[values.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = new FunctionParameter(this.params[i], values[i]);
        }
        ChatCalculator.FUNCTION_TABLE.add((Pair<String, Integer>)pair);
        double value = Config.makeEngine().eval(this.eval, parameters);
        ChatCalculator.FUNCTION_TABLE.remove(pair);
        return value;
    }

    @Override
    public String toString() {
        return this.name + "(" + String.join((CharSequence)";", this.params) + ")=" + this.eval;
    }
}

