/*
 * Decompiled with CFR 0.152.
 */
package de.smallinger.chatcalc;

import de.smallinger.chatcalc.Config;
import java.util.LinkedHashSet;
import java.util.function.DoubleSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;

public class MathematicalConstant {
    public static final LinkedHashSet<MathematicalConstant> CONSTANTS = new LinkedHashSet();
    private final String name;
    private final DoubleSupplier value;

    public MathematicalConstant(String name, DoubleSupplier value) {
        this.name = name;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public double value() {
        return this.value.getAsDouble();
    }

    static {
        CONSTANTS.add(new MathematicalConstant("random", Math::random));
        CONSTANTS.add(new MathematicalConstant("rand", Math::random));
        CONSTANTS.add(new MathematicalConstant("rad", () -> Config.radians() ? 1.0 : 57.29577951308232));
        CONSTANTS.add(new MathematicalConstant("deg", () -> Config.radians() ? Math.PI / 180 : 1.0));
        CONSTANTS.add(new MathematicalConstant("yaw", () -> Config.convertFromDegrees(Mth.wrapDegrees((float)Minecraft.getInstance().player.getYRot()))));
        CONSTANTS.add(new MathematicalConstant("pitch", () -> Config.convertFromDegrees(Mth.wrapDegrees((float)Minecraft.getInstance().player.getXRot()))));
        CONSTANTS.add(new MathematicalConstant("pi", () -> Math.PI));
        CONSTANTS.add(new MathematicalConstant("tau", () -> Math.PI * 2));
        CONSTANTS.add(new MathematicalConstant("e", () -> Math.E));
        CONSTANTS.add(new MathematicalConstant("phi", () -> 1.618033988749895));
        CONSTANTS.add(new MathematicalConstant("x", () -> Minecraft.getInstance().player.getX()));
        CONSTANTS.add(new MathematicalConstant("y", () -> Minecraft.getInstance().player.getY()));
        CONSTANTS.add(new MathematicalConstant("z", () -> Minecraft.getInstance().player.getZ()));
    }
}

