/*
 * Decompiled with CFR 0.152.
 */
package de.smallinger.chatcalc;

import com.google.common.math.DoubleMath;
import de.smallinger.chatcalc.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import net.minecraft.util.Mth;

public final class MathematicalFunction {
    public static final Map<String, Function<double[], OptionalDouble>> FUNCTIONS = new HashMap<String, Function<double[], OptionalDouble>>();
    public final String func;

    public String toString() {
        return this.func;
    }

    public MathematicalFunction(String value) {
        this.func = value;
    }

    public double apply(double ... values) {
        return Optional.ofNullable(FUNCTIONS.get(this.func)).map(function -> ((OptionalDouble)function.apply(values)).orElseThrow(IllegalArgumentException::new)).orElseGet(() -> Config.func(this.func, values));
    }

    public static double gcf(double a, double b) {
        double t;
        if (b > a) {
            t = a;
            a = b;
            b = t;
        }
        while (b != 0.0) {
            t = b;
            b = MathematicalFunction.mod(a, b);
            a = t;
        }
        return a;
    }

    public static double lcm(double a, double b) {
        return a * b / MathematicalFunction.gcf(a, b);
    }

    public static double log(double base, double value) {
        return Math.log(value) / Math.log(base);
    }

    public static double mod(double a, double b) {
        return a % b + ((Double.doubleToLongBits(a) >>> 63 ^ Double.doubleToLongBits(b) >>> 63) > 0L ? b : 0.0);
    }

    public static double factorial(double x) {
        return x % 1.0 == 0.0 & x >= 1.0 ? DoubleMath.factorial((int)((int)x)) : Math.sqrt(Math.PI * 2 * x) * Math.pow(x / Math.E, x) * (1.0 + 1.0 / (12.0 * x) + 1.0 / (288.0 * x * x) - 139.0 / (51840.0 * x * x * x) - 571.0 / (2488320.0 * x * x * x * x) + 163879.0 / (2.0901888E8 * x * x * x * x * x) + 5246819.0 / (7.52467968E10 * x * x * x * x * x * x) - 5.34703531E8 / (9.029615616E11 * x * x * x * x * x * x * x));
    }

    private static Function<double[], OptionalDouble> simple(DoubleUnaryOperator simple) {
        return values -> ((double[])values).length == 1 ? OptionalDouble.of(simple.applyAsDouble(values[0])) : OptionalDouble.empty();
    }

    static {
        FUNCTIONS.put("sqrt", MathematicalFunction.simple(Math::sqrt));
        FUNCTIONS.put("cbrt", MathematicalFunction.simple(Math::cbrt));
        FUNCTIONS.put("sin", MathematicalFunction.simple(val -> Math.sin(Config.convertToRadians(val))));
        FUNCTIONS.put("cos", MathematicalFunction.simple(val -> Math.cos(Config.convertToRadians(val))));
        FUNCTIONS.put("tan", MathematicalFunction.simple(val -> Math.tan(Config.convertToRadians(val))));
        FUNCTIONS.put("csc", MathematicalFunction.simple(val -> 1.0 / Math.sin(Config.convertToRadians(val))));
        FUNCTIONS.put("sec", MathematicalFunction.simple(val -> 1.0 / Math.cos(Config.convertToRadians(val))));
        FUNCTIONS.put("cot", MathematicalFunction.simple(val -> 1.0 / Math.tan(Config.convertToRadians(val))));
        FUNCTIONS.put("arcsin", MathematicalFunction.simple(val -> Config.convertFromRadians(Math.asin(val))));
        FUNCTIONS.put("asin", FUNCTIONS.get("arcsin"));
        FUNCTIONS.put("arccos", MathematicalFunction.simple(val -> Config.convertFromRadians(Math.acos(val))));
        FUNCTIONS.put("acos", FUNCTIONS.get("arccos"));
        FUNCTIONS.put("arctan", MathematicalFunction.simple(val -> Config.convertFromRadians(Math.atan(val))));
        FUNCTIONS.put("atan", FUNCTIONS.get("arctan"));
        FUNCTIONS.put("arccsc", MathematicalFunction.simple(val -> Config.convertFromRadians(Math.asin(1.0 / val))));
        FUNCTIONS.put("acsc", FUNCTIONS.get("arccsc"));
        FUNCTIONS.put("arcsec", MathematicalFunction.simple(val -> Config.convertFromRadians(Math.acos(1.0 / val))));
        FUNCTIONS.put("asec", FUNCTIONS.get("arcsec"));
        FUNCTIONS.put("arccot", MathematicalFunction.simple(val -> Config.convertFromRadians(Math.atan(1.0 / val))));
        FUNCTIONS.put("acot", FUNCTIONS.get("arccot"));
        FUNCTIONS.put("floor", MathematicalFunction.simple(Math::floor));
        FUNCTIONS.put("ceil", MathematicalFunction.simple(Math::ceil));
        FUNCTIONS.put("round", MathematicalFunction.simple(x -> Math.floor(x + 0.5)));
        FUNCTIONS.put("abs", MathematicalFunction.simple(Math::abs));
        FUNCTIONS.put("log", MathematicalFunction.simple(Math::log10));
        FUNCTIONS.put("ln", MathematicalFunction.simple(Math::log));
        FUNCTIONS.put("exp", MathematicalFunction.simple(Math::exp));
        FUNCTIONS.put("sgn", MathematicalFunction.simple(x -> Double.isNaN(x) || x + 0.0 == 0.0 ? 0.0 : (x >= 0.0 ? 1.0 : -1.0)));
        FUNCTIONS.put("min", values -> DoubleStream.of(values).min());
        FUNCTIONS.put("max", values -> DoubleStream.of(values).max());
        FUNCTIONS.put("gcf", values -> DoubleStream.of(values).reduce(MathematicalFunction::gcf));
        FUNCTIONS.put("lcm", values -> DoubleStream.of(values).reduce(MathematicalFunction::lcm));
        FUNCTIONS.put("clamp", values -> ((double[])values).length == 3 ? OptionalDouble.of(Mth.clamp((double)values[0], (double)values[1], (double)values[2])) : OptionalDouble.empty());
        FUNCTIONS.put("cmp", values -> ((double[])values).length >= 2 && ((double[])values).length <= 3 ? OptionalDouble.of(Math.abs(values[0] - values[1]) <= (((double[])values).length == 2 ? 0.0 : values[2]) ? 0.0 : (values[0] < values[1] ? -1.0 : (values[0] > values[1] ? 1.0 : 0.0))) : OptionalDouble.empty());
    }
}

