/*
 * Decompiled with CFR 0.152.
 */
package de.smallinger.chatcalc;

import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import de.smallinger.chatcalc.Config;
import de.smallinger.chatcalc.CustomConstant;
import de.smallinger.chatcalc.FunctionParameter;
import de.smallinger.chatcalc.MathEngine;
import de.smallinger.chatcalc.MathematicalConstant;
import de.smallinger.chatcalc.MathematicalFunction;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import net.minecraft.util.Mth;

public class NibbleMathEngine
implements MathEngine {
    byte[] bytes;
    int idx;
    FunctionParameter[] params;
    boolean abs;

    @Override
    public double eval(String input, FunctionParameter[] paramaters) {
        this.bytes = this.fixParenthesis(input).concat("\u0000").getBytes(StandardCharsets.US_ASCII);
        this.idx = 0;
        this.abs = false;
        this.params = paramaters;
        double result = this.expression();
        if (this.idx + 1 != this.bytes.length) {
            throw new IllegalArgumentException("Evaluation had unexpected remaining characters");
        }
        return result;
    }

    private String fixParenthesis(String input) {
        int openingMissing = 0;
        for (int i = 0; i < ((String)input).length(); ++i) {
            char c = ((String)input).charAt(i);
            if (c == ')') {
                ++openingMissing;
                continue;
            }
            if (c == '(') break;
        }
        int closingMissing = 0;
        for (int i = ((String)input).length() - 1; i >= 0; --i) {
            char c = ((String)input).charAt(i);
            if (c == '(') {
                ++closingMissing;
                continue;
            }
            if (c == ')') break;
        }
        input = "(".repeat(openingMissing) + (String)input + ")".repeat(closingMissing);
        int opening = 0;
        int closing = 0;
        for (int i = 0; i < ((String)input).length(); ++i) {
            char c = ((String)input).charAt(i);
            if (c == '(') {
                ++opening;
                continue;
            }
            if (c != ')') continue;
            ++closing;
        }
        return "(".repeat(Math.max(0, closing - opening)) + (String)input + ")".repeat(Math.max(0, opening - closing));
    }

    private boolean bite(char bite) {
        if (this.bytes[this.idx] == bite) {
            ++this.idx;
            return true;
        }
        return false;
    }

    private double expression() {
        double x = this.modulo();
        while (true) {
            if (this.bite('+')) {
                x += this.modulo();
                continue;
            }
            if (!this.bite('-')) break;
            x -= this.modulo();
        }
        return x;
    }

    private double modulo() {
        double x = this.term();
        while (this.bite('%')) {
            x = MathematicalFunction.mod(x, this.term());
        }
        return x;
    }

    private double term() {
        double x = this.grouping();
        while (true) {
            if (this.bite('*')) {
                x *= this.grouping();
                continue;
            }
            if (!this.bite('/')) break;
            x /= this.grouping();
        }
        return x;
    }

    private double grouping() {
        long sign = 0L;
        while (this.bytes[this.idx] == 43 | this.bytes[this.idx] == 45) {
            if (this.bytes[this.idx++] != 45) continue;
            sign ^= Long.MIN_VALUE;
        }
        double x = this.part();
        while (this.isStartOfPart(this.bytes[this.idx])) {
            x *= this.part();
        }
        return Double.longBitsToDouble(Double.doubleToLongBits(x) ^ sign);
    }

    private double part() {
        double x;
        boolean absBefore;
        block61: {
            if (this.bite('(')) {
                absBefore = this.abs;
                this.abs = false;
                x = this.expression();
                if (!this.bite(')')) {
                    throw new IllegalArgumentException("Expected closing parenthesis");
                }
                this.abs = absBefore;
            } else if (!this.abs && this.bite('|')) {
                absBefore = this.abs;
                this.abs = true;
                x = Math.abs(this.expression());
                if (!this.bite('|')) {
                    throw new IllegalArgumentException("Expected closing absolute value character");
                }
                this.abs = absBefore;
            } else if (this.bytes[this.idx] <= 57 & this.bytes[this.idx] >= 48 | this.bytes[this.idx] == 46 | this.bytes[this.idx] == 44) {
                start = this.idx;
                while (this.bytes[this.idx] <= 57 & this.bytes[this.idx] >= 48 | this.bytes[this.idx] == 46 | this.bytes[this.idx] == 44) {
                    ++this.idx;
                }
                x = Double.parseDouble(new String(this.bytes, start, this.idx - start, StandardCharsets.US_ASCII).replace(",", ""));
            } else if (this.bytes[this.idx] >= 97 & this.bytes[this.idx] <= 122 | this.bytes[this.idx] >= 65 & this.bytes[this.idx] <= 90) {
                start = this.idx;
                while (this.bytes[this.idx] >= 97 & this.bytes[this.idx] <= 122 | this.bytes[this.idx] >= 65 & this.bytes[this.idx] <= 90) {
                    ++this.idx;
                }
                if (this.bytes[this.idx] == 95) {
                    ++this.idx;
                }
                String str = new String(this.bytes, start, this.idx - start, StandardCharsets.US_ASCII);
                if (Streams.concat((Stream[])new Stream[]{Config.FUNCTIONS.keySet().stream().map(Pair::getFirst), MathematicalFunction.FUNCTIONS.keySet().stream()}).noneMatch(str::startsWith)) {
                    for (FunctionParameter param : this.params) {
                        if (!str.startsWith(param.name())) continue;
                        this.idx -= str.length() - param.name().length();
                        x = param.value();
                        break block61;
                    }
                    for (MathematicalConstant constant : MathematicalConstant.CONSTANTS) {
                        if (!str.startsWith(constant.name())) continue;
                        this.idx -= str.length() - constant.name().length();
                        x = constant.value();
                        break block61;
                    }
                    for (CustomConstant constant : Config.CONSTANTS.values()) {
                        if (!str.startsWith(constant.name())) continue;
                        this.idx -= str.length() - constant.name().length();
                        x = constant.get();
                        break block61;
                    }
                }
                if (str.equals("sum")) {
                    boolean absBefore2 = this.abs;
                    this.abs = false;
                    if (!this.bite('(')) {
                        throw new IllegalArgumentException("Expected parenthesis for summation");
                    }
                    start = this.idx;
                    while (this.bytes[this.idx] >= 97 & this.bytes[this.idx] <= 122 | this.bytes[this.idx] >= 65 & this.bytes[this.idx] <= 90) {
                        ++this.idx;
                    }
                    String param = new String(this.bytes, start, this.idx - start, StandardCharsets.US_ASCII);
                    if (!this.bite('=')) {
                        throw new IllegalArgumentException("Expected starting value for parameter in summation");
                    }
                    lowerBound = Mth.floor((double)this.expression());
                    if (!this.bite(';')) {
                        throw new IllegalArgumentException("Expected multiple parameters in summation");
                    }
                    int upperBound = Mth.floor((double)this.expression());
                    if (!this.bite(';')) {
                        throw new IllegalArgumentException("Expected multiple parameters in summation");
                    }
                    start = this.idx;
                    int parenthesis = 0;
                    while (parenthesis >= 0) {
                        byte c = this.bytes[this.idx];
                        if (c == 40) {
                            ++parenthesis;
                        } else if (c == 41) {
                            --parenthesis;
                        } else if (c == 0) {
                            throw new IllegalArgumentException("Expected closing parenthesis in summation");
                        }
                        ++this.idx;
                    }
                    String expression = new String(this.bytes, start, this.idx - 1 - start, StandardCharsets.US_ASCII);
                    double sum = 0.0;
                    FunctionParameter[] summationParams = new FunctionParameter[this.params.length + 1];
                    System.arraycopy(this.params, 0, summationParams, 0, this.params.length);
                    for (int i = lowerBound; i <= upperBound; ++i) {
                        summationParams[this.params.length] = new FunctionParameter(param, i);
                        sum += Config.makeEngine().eval(expression, summationParams);
                    }
                    this.abs = absBefore2;
                    x = sum;
                } else if (str.equals("prod")) {
                    boolean absBefore3 = this.abs;
                    this.abs = false;
                    if (!this.bite('(')) {
                        throw new IllegalArgumentException("Expected parenthesis for product");
                    }
                    start = this.idx;
                    while (this.bytes[this.idx] >= 97 & this.bytes[this.idx] <= 122 | this.bytes[this.idx] >= 65 & this.bytes[this.idx] <= 90) {
                        ++this.idx;
                    }
                    String param = new String(this.bytes, start, this.idx - start, StandardCharsets.US_ASCII);
                    if (!this.bite('=')) {
                        throw new IllegalArgumentException("Expected starting value for parameter in product");
                    }
                    lowerBound = Mth.floor((double)this.expression());
                    if (!this.bite(';')) {
                        throw new IllegalArgumentException("Expected multiple parameters in product");
                    }
                    int upperBound = Mth.floor((double)this.expression());
                    if (!this.bite(';')) {
                        throw new IllegalArgumentException("Expected multiple parameters in product");
                    }
                    start = this.idx;
                    int parenthesis = 0;
                    while (parenthesis >= 0) {
                        byte c = this.bytes[this.idx];
                        if (c == 40) {
                            ++parenthesis;
                        } else if (c == 41) {
                            --parenthesis;
                        } else if (c == 0) {
                            throw new IllegalArgumentException("Expected closing parenthesis in product");
                        }
                        ++this.idx;
                    }
                    String expression = new String(this.bytes, start, this.idx - 1 - start, StandardCharsets.US_ASCII);
                    double prod = 1.0;
                    FunctionParameter[] productParams = new FunctionParameter[this.params.length + 1];
                    System.arraycopy(this.params, 0, productParams, 0, this.params.length);
                    for (int i = lowerBound; i <= upperBound; ++i) {
                        productParams[this.params.length] = new FunctionParameter(param, i);
                        prod *= Config.makeEngine().eval(expression, productParams);
                    }
                    this.abs = absBefore3;
                    x = prod;
                } else if (str.equals("log_")) {
                    boolean absBefore4 = this.abs;
                    this.abs = false;
                    double base = this.part();
                    if (!this.bite('(')) {
                        throw new IllegalArgumentException("Expected parenthesis for logarithmic function");
                    }
                    double value = this.expression();
                    if (!this.bite(')')) {
                        throw new IllegalArgumentException("Expected closing parenthesis for logarithmic function");
                    }
                    this.abs = absBefore4;
                    x = MathematicalFunction.log(base, value);
                } else {
                    double[] values;
                    double exponent;
                    boolean absBefore5;
                    block62: {
                        absBefore5 = this.abs;
                        this.abs = false;
                        int param_count = 1;
                        double d = exponent = this.bite('^') ? this.part() : 1.0;
                        if (!this.bite('(')) {
                            throw new IllegalArgumentException("Expected parenthesis for function");
                        }
                        int depth = 0;
                        int before = this.idx;
                        while (this.bytes[this.idx] != 0) {
                            if (this.bytes[this.idx] == 59 & depth == 0) {
                                ++param_count;
                            } else if (this.bytes[this.idx] == 41) {
                                if (depth-- == 0) {
                                    break;
                                }
                            } else if (this.bytes[this.idx] == 40) {
                                ++depth;
                            }
                            ++this.idx;
                        }
                        this.idx = before;
                        values = new double[param_count];
                        int value_count = 0;
                        do {
                            if (this.bite('\u0000')) {
                                throw new IllegalArgumentException("Expected closing parenthesis for function");
                            }
                            values[value_count++] = this.expression();
                            if (this.bite(')')) break block62;
                        } while (this.bite(';'));
                        throw new IllegalArgumentException("Expected that a semicolon exists between the parameters");
                    }
                    this.abs = absBefore5;
                    x = Math.pow(new MathematicalFunction(str).apply(values), exponent);
                }
            } else {
                throw new IllegalArgumentException("Expected a valid character for equation, not '" + (char)this.bytes[this.idx] + "' (at index " + this.idx + ")");
            }
        }
        if (this.bite('!')) {
            x = MathematicalFunction.factorial(x);
        }
        if (this.bite('^')) {
            absBefore = this.abs;
            this.abs = false;
            x = Math.pow(x, this.grouping());
            this.abs = absBefore;
        }
        return x;
    }

    private boolean isStartOfPart(byte c) {
        return c >= 97 & c <= 122 | c >= 48 & c <= 57 | c == 40 | c == 124 & !this.abs;
    }

    public String toString() {
        return new String(this.bytes, this.idx, this.bytes.length - this.idx - 1);
    }
}

