/*
 * Decompiled with CFR 0.152.
 */
package de.smallinger.chatcalc.mixin;

import com.mojang.datafixers.util.Pair;
import de.smallinger.chatcalc.ChatCalculator;
import de.smallinger.chatcalc.ChatHelper;
import de.smallinger.chatcalc.Config;
import de.smallinger.chatcalc.FunctionParameter;
import java.util.OptionalDouble;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EditBox.class})
public abstract class EditBoxMixin
extends AbstractWidget {
    @Shadow
    @Final
    private Font font;
    @Unique
    private Pair<String, OptionalDouble> chatcal$evaluationCache;

    public EditBoxMixin(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @Shadow
    public abstract int getCursorPosition();

    @Shadow
    public abstract String getValue();

    @Inject(method={"renderWidget"}, at={@At(value="TAIL")})
    private void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!Config.displayAbove()) {
            this.chatcal$evaluationCache = null;
            return;
        }
        String word = ChatHelper.getSection(this.getValue(), this.getCursorPosition());
        if (ChatCalculator.NUMBER.matcher(word).matches()) {
            this.chatcal$evaluationCache = null;
            return;
        }
        try {
            double result;
            if (this.chatcal$evaluationCache != null && ((String)this.chatcal$evaluationCache.getFirst()).equals(word)) {
                if (((OptionalDouble)this.chatcal$evaluationCache.getSecond()).isEmpty()) {
                    return;
                }
                result = ((OptionalDouble)this.chatcal$evaluationCache.getSecond()).getAsDouble();
            } else {
                ChatCalculator.CONSTANT_TABLE.clear();
                ChatCalculator.FUNCTION_TABLE.clear();
                result = Config.makeEngine().eval(word, new FunctionParameter[0]);
                this.chatcal$evaluationCache = new Pair((Object)word, (Object)OptionalDouble.of(result));
            }
            String formattedResult = "=" + Config.getDecimalFormat().format(result);
            MutableComponent tooltipText = Component.literal((String)formattedResult);
            context.setTooltipForNextFrame(this.font, (Component)tooltipText, this.getX() - 8, this.getY() - 4);
        }
        catch (Throwable ignored) {
            this.chatcal$evaluationCache = new Pair((Object)word, (Object)OptionalDouble.empty());
        }
    }
}

