/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.tpmaster.mixin;

import com.hexagram2021.tpmaster.TeleportMaster;
import com.hexagram2021.tpmaster.common.config.TPMCommonConfig;
import com.hexagram2021.tpmaster.server.commands.TPMCommands;
import com.hexagram2021.tpmaster.server.util.ITeleportable;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin
implements ITeleportable {
    @Shadow
    @Final
    public MinecraftServer f_8924_;
    private Entity teleportMasterRequester = null;
    private ITeleportable.RequestType requestType = null;
    private int teleportMasterAwayCoolDownTicks = 0;
    private int teleportMasterRequestCoolDownTicks = 0;
    private int teleportMasterAutoDenyTicks = 0;
    private final GlobalPos[] teleportMasterHomes = new GlobalPos[((Integer)TPMCommonConfig.MAX_HOME_COUNT.get()).intValue()];
    private GlobalPos lastDeathPoint = null;

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;tick()V", shift=At.Shift.AFTER)})
    public void tickTeleportMaster(CallbackInfo ci) {
        if (this.teleportMasterAwayCoolDownTicks > 0) {
            --this.teleportMasterAwayCoolDownTicks;
        }
        if (this.teleportMasterRequestCoolDownTicks > 0) {
            --this.teleportMasterRequestCoolDownTicks;
        }
        if (this.teleportMasterAutoDenyTicks > 0) {
            --this.teleportMasterAutoDenyTicks;
            if (this.teleportMasterAutoDenyTicks == 0) {
                try {
                    TPMCommands.deny((Entity)((ServerPlayer)this));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readTeleportMasterData(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128425_("TeleportMasterRequester", 11)) {
            UUID uuid = nbt.m_128342_("TeleportMasterRequester");
            this.teleportMasterRequester = uuid.equals(Util.f_137441_) ? null : ((ServerPlayer)this).m_9236_().m_46003_(uuid);
        }
        if (nbt.m_128425_("RequestType", 1)) {
            byte req = nbt.m_128445_("RequestType");
            this.requestType = req <= 0 || req > ITeleportable.RequestType.values().length ? null : ITeleportable.RequestType.values()[req - 1];
        }
        this.teleportMasterAwayCoolDownTicks = nbt.m_128451_("TeleportMasterAwayCoolDownTicks");
        this.teleportMasterRequestCoolDownTicks = nbt.m_128451_("TeleportMasterRequestCoolDownTicks");
        this.teleportMasterAutoDenyTicks = nbt.m_128451_("TeleportMasterAutoDenyTicks");
        if (nbt.m_128425_("TeleportMasterHomes", 10)) {
            CompoundTag homesTag = nbt.m_128469_("TeleportMasterHomes");
            for (int i = 0; i < (Integer)TPMCommonConfig.MAX_HOME_COUNT.get(); ++i) {
                if (homesTag.m_128425_(String.valueOf(i), 10)) {
                    CompoundTag curHome = homesTag.m_128469_(String.valueOf(i));
                    int finalI = i;
                    String dimension = curHome.m_128461_("dimension");
                    this.f_8924_.m_129784_().stream().filter(key -> key.m_135782_().toString().equals(dimension)).findFirst().ifPresentOrElse(key -> {
                        this.teleportMasterHomes[finalI] = GlobalPos.m_122643_((ResourceKey)key, (BlockPos)BlockPos.m_122022_((long)curHome.m_128454_("pos")));
                    }, () -> {
                        TeleportMaster.LOGGER.error("No dimension named \"%s\".".formatted(dimension));
                        this.teleportMasterHomes[finalI] = null;
                    });
                    continue;
                }
                this.teleportMasterHomes[i] = null;
            }
        } else {
            for (int i = 0; i < (Integer)TPMCommonConfig.MAX_HOME_COUNT.get(); ++i) {
                this.teleportMasterHomes[i] = null;
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addTeleportMasterData(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128362_("TeleportMasterRequester", this.teleportMasterRequester == null ? Util.f_137441_ : this.teleportMasterRequester.m_20148_());
        nbt.m_128344_("RequestType", (byte)(this.requestType == null ? 0 : this.requestType.ordinal() + 1));
        nbt.m_128405_("TeleportMasterAwayCoolDownTicks", this.teleportMasterAwayCoolDownTicks);
        nbt.m_128405_("TeleportMasterRequestCoolDownTicks", this.teleportMasterRequestCoolDownTicks);
        nbt.m_128405_("TeleportMasterAutoDenyTicks", this.teleportMasterAutoDenyTicks);
        CompoundTag homesTag = new CompoundTag();
        for (int i = 0; i < (Integer)TPMCommonConfig.MAX_HOME_COUNT.get(); ++i) {
            if (this.teleportMasterHomes[i] == null) continue;
            CompoundTag curHome = new CompoundTag();
            curHome.m_128359_("dimension", this.teleportMasterHomes[i].m_122640_().m_135782_().toString());
            curHome.m_128356_("pos", this.teleportMasterHomes[i].m_122646_().m_121878_());
            homesTag.m_128365_(String.valueOf(i), (Tag)curHome);
        }
        nbt.m_128365_("TeleportMasterHomes", (Tag)homesTag);
    }

    @Inject(method={"die"}, at={@At(value="TAIL")})
    public void recordDeathPoint(DamageSource damageSource, CallbackInfo ci) {
        ServerPlayer current = (ServerPlayer)this;
        BlockPos pos = current.m_20183_();
        this.setTeleportMasterLastDeathPoint(GlobalPos.m_122643_((ResourceKey)current.m_9236_().m_46472_(), (BlockPos)pos));
        current.m_213846_((Component)Component.m_237110_((String)"info.tpmaster.death", (Object[])new Object[]{current.m_9236_().m_46472_().m_135782_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
    }

    @Inject(method={"restoreFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;setLastDeathLocation(Ljava/util/Optional;)V", shift=At.Shift.AFTER)})
    public void restoreTeleportMasterData(ServerPlayer source, boolean won, CallbackInfo ci) {
        if (source instanceof ITeleportable) {
            ITeleportable teleportable = (ITeleportable)source;
            this.teleportMasterRequester = teleportable.getTeleportMasterRequester();
            this.requestType = teleportable.getRequestType();
            this.teleportMasterAwayCoolDownTicks = teleportable.getTeleportMasterAwayCoolDownTick();
            this.teleportMasterRequestCoolDownTicks = teleportable.getTeleportMasterRequestCoolDownTick();
            this.teleportMasterAutoDenyTicks = (Integer)TPMCommonConfig.REQUEST_COMMAND_AUTO_DENY_TICK.get();
            for (int i = 0; i < (Integer)TPMCommonConfig.MAX_HOME_COUNT.get(); ++i) {
                this.teleportMasterHomes[i] = teleportable.getTeleportMasterHome(i);
            }
            this.lastDeathPoint = teleportable.getTeleportMasterLastDeathPoint();
        }
    }

    @Override
    @Nullable
    public Entity getTeleportMasterRequester() {
        return this.teleportMasterRequester;
    }

    @Override
    @Nullable
    public ITeleportable.RequestType getRequestType() {
        return this.requestType;
    }

    @Override
    public void setTeleportMasterRequest(@NotNull ITeleportable target, @NotNull ITeleportable.RequestType type) {
        target.receiveTeleportMasterRequestFrom((Entity)this, type);
        if (!((ServerPlayer)this).m_150110_().f_35937_) {
            this.teleportMasterRequestCoolDownTicks = (Integer)TPMCommonConfig.REQUEST_COMMAND_COOL_DOWN_TICK.get();
        }
    }

    @Override
    public void receiveTeleportMasterRequestFrom(@NotNull Entity from, @NotNull ITeleportable.RequestType type) {
        this.teleportMasterRequester = from;
        this.requestType = type;
        this.teleportMasterAutoDenyTicks = (Integer)TPMCommonConfig.REQUEST_COMMAND_AUTO_DENY_TICK.get();
    }

    @Override
    public void setTeleportMasterAway() {
        if (!((ServerPlayer)this).m_150110_().f_35937_) {
            this.teleportMasterAwayCoolDownTicks = (Integer)TPMCommonConfig.AWAY_COMMAND_COOL_DOWN_TICK.get();
        }
    }

    @Override
    public void clearTeleportMasterRequest() {
        this.teleportMasterRequester = null;
        this.requestType = null;
    }

    @Override
    public boolean canUseTeleportMasterAway() {
        return this.teleportMasterAwayCoolDownTicks <= 0;
    }

    @Override
    public boolean canUseTeleportMasterRequest() {
        return this.teleportMasterRequestCoolDownTicks <= 0;
    }

    @Override
    public int getTeleportMasterAwayCoolDownTick() {
        return this.teleportMasterAwayCoolDownTicks;
    }

    @Override
    public int getTeleportMasterRequestCoolDownTick() {
        return this.teleportMasterRequestCoolDownTicks;
    }

    @Override
    public void setTeleportMasterHome(GlobalPos pos, int index) throws CommandSyntaxException {
        if (index < 0 || index >= (Integer)TPMCommonConfig.MAX_HOME_COUNT.get()) {
            throw TPMCommands.INVALID_SETHOME_INDEX_PARAMETER.create((Object)index, TPMCommonConfig.MAX_HOME_COUNT.get());
        }
        this.teleportMasterHomes[index] = pos;
    }

    @Override
    @Nullable
    public GlobalPos getTeleportMasterHome(int index) {
        return this.teleportMasterHomes[index];
    }

    @Override
    public GlobalPos[] getTeleportMasterHomes() {
        return this.teleportMasterHomes;
    }

    @Override
    public void setTeleportMasterLastDeathPoint(@Nullable GlobalPos pos) {
        this.lastDeathPoint = pos;
    }

    @Override
    @Nullable
    public GlobalPos getTeleportMasterLastDeathPoint() {
        return this.lastDeathPoint;
    }
}

