/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.tpmaster.server.commands;

import com.hexagram2021.tpmaster.common.config.TPMCommonConfig;
import com.hexagram2021.tpmaster.server.util.ITeleportable;
import com.hexagram2021.tpmaster.server.util.LevelUtils;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.TeleportCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Monster;

public class TPMCommands {
    private static final SimpleCommandExceptionType NO_NEED_TO_ACCEPT = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.tpmaster.accept.failed.no_request"));
    private static final SimpleCommandExceptionType NO_NEED_TO_DENY = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.tpmaster.deny.failed.no_request"));
    private static final DynamicCommandExceptionType TARGET_UNHANDLED_RESERVATION = new DynamicCommandExceptionType(name -> Component.m_237110_((String)"commands.tpmaster.request.failed.reserved", (Object[])new Object[]{name}));
    private static final DynamicCommandExceptionType INVALID_AWAY_DISTANCE_PARAMETER = new DynamicCommandExceptionType(d -> Component.m_237110_((String)"commands.tpmaster.away.invalid.distance", (Object[])new Object[]{d}));
    private static final SimpleCommandExceptionType CANNOT_FIND_POSITION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.tpmaster.away.failed.no_position"));
    public static final Dynamic2CommandExceptionType INVALID_SETHOME_INDEX_PARAMETER = new Dynamic2CommandExceptionType((i, max) -> Component.m_237110_((String)"commands.tpmaster.sethome.invalid.index", (Object[])new Object[]{i, max}));
    private static final DynamicCommandExceptionType NO_HOME_TO_HOME = new DynamicCommandExceptionType(d -> Component.m_237110_((String)"commands.tpmaster.home.failed.no_home", (Object[])new Object[]{d}));
    private static final DynamicCommandExceptionType NO_LEVEL_FOUNDED_TO_HOME = new DynamicCommandExceptionType(level -> Component.m_237110_((String)"commands.tpmaster.home.failed.no_level", (Object[])new Object[]{level}));
    private static final SimpleCommandExceptionType NO_DEATH_POINT_TO_BACK = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.tpmaster.back.failed.no_home"));
    private static final DynamicCommandExceptionType NO_LEVEL_FOUNDED_TO_BACK = new DynamicCommandExceptionType(level -> Component.m_237110_((String)"commands.tpmaster.back.failed.no_level", (Object[])new Object[]{level}));
    private static final DynamicCommandExceptionType COOL_DOWN_AWAY = new DynamicCommandExceptionType(d -> Component.m_237110_((String)"commands.tpmaster.away.failed.cool_down", (Object[])new Object[]{d}));
    private static final DynamicCommandExceptionType COOL_DOWN_REQUEST = new DynamicCommandExceptionType(d -> Component.m_237110_((String)"commands.tpmaster.request.failed.cool_down", (Object[])new Object[]{d}));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpm").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"a").requires(stack -> stack.m_6761_(((Integer)TPMCommonConfig.ACCEPT_DENY_PERMISSION_LEVEL.get()).intValue()))).executes(context -> TPMCommands.accept((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81374_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"d").requires(stack -> stack.m_6761_(((Integer)TPMCommonConfig.ACCEPT_DENY_PERMISSION_LEVEL.get()).intValue()))).executes(context -> TPMCommands.deny(((CommandSourceStack)context.getSource()).m_81374_())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"w").requires(stack -> stack.m_6761_(((Integer)TPMCommonConfig.AWAY_PERMISSION_LEVEL.get()).intValue()))).executes(context -> TPMCommands.away((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81374_(), 0, true, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)10000)).executes(context -> TPMCommands.away((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81374_(), (Integer)context.getArgument("distance", Integer.class), true, null))).then(Commands.m_82129_((String)"mustOnLand", (ArgumentType)BoolArgumentType.bool()).executes(context -> TPMCommands.away((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81374_(), (Integer)context.getArgument("distance", Integer.class), (Boolean)context.getArgument("mustOnLand", Boolean.class), null)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"r").requires(stack -> stack.m_6761_(((Integer)TPMCommonConfig.REQUEST_PERMISSION_LEVEL.get()).intValue()))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> TPMCommands.request((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81374_(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), ITeleportable.RequestType.ASK))).then(Commands.m_82127_((String)"a").executes(context -> TPMCommands.request((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81374_(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), ITeleportable.RequestType.ASK)))).then(Commands.m_82127_((String)"i").executes(context -> TPMCommands.request((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81374_(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), ITeleportable.RequestType.INVITE)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").requires(stack -> stack.m_6761_(((Integer)TPMCommonConfig.SPAWN_PERMISSION_LEVEL.get()).intValue()))).executes(context -> TPMCommands.spawn((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81374_())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sethome").requires(stack -> stack.m_6761_(((Integer)TPMCommonConfig.HOME_PERMISSION_LEVEL.get()).intValue()))).executes(context -> TPMCommands.sethome(((CommandSourceStack)context.getSource()).m_81374_(), 0))).then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0, (int)((Integer)TPMCommonConfig.MAX_HOME_COUNT.get() - 1))).executes(context -> TPMCommands.sethome(((CommandSourceStack)context.getSource()).m_81374_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"home").requires(stack -> stack.m_6761_(((Integer)TPMCommonConfig.HOME_PERMISSION_LEVEL.get()).intValue()))).executes(context -> TPMCommands.home((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81374_(), 0))).then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0, (int)((Integer)TPMCommonConfig.MAX_HOME_COUNT.get() - 1))).executes(context -> TPMCommands.home((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81374_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"b").requires(stack -> stack.m_6761_(((Integer)TPMCommonConfig.BACK_PERMISSION_LEVEL.get()).intValue()))).executes(context -> TPMCommands.back((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81374_())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(stack -> stack.m_6761_(((Integer)TPMCommonConfig.REMOVE_PERMISSION_LEVEL.get()).intValue()))).then(Commands.m_82127_((String)"home").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0, (int)((Integer)TPMCommonConfig.MAX_HOME_COUNT.get() - 1))).executes(context -> TPMCommands.removeHome(((CommandSourceStack)context.getSource()).m_81374_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index")))))).then(Commands.m_82127_((String)"b").executes(context -> TPMCommands.removeBack(((CommandSourceStack)context.getSource()).m_81374_()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"help").requires(stack -> stack.m_6761_(((Integer)TPMCommonConfig.HELP_PERMISSION_LEVEL.get()).intValue()))).executes(context -> TPMCommands.help(((CommandSourceStack)context.getSource()).m_81374_())));
    }

    private static int accept(CommandSourceStack stack, Entity entity) throws CommandSyntaxException {
        if (entity instanceof ITeleportable) {
            ITeleportable teleportable = (ITeleportable)entity;
            Entity requester = teleportable.getTeleportMasterRequester();
            ITeleportable.RequestType requestType = teleportable.getRequestType();
            if (requester == null || requestType == null) {
                throw NO_NEED_TO_ACCEPT.create();
            }
            switch (requestType) {
                case ASK: {
                    TeleportCommand.m_139014_((CommandSourceStack)stack, (Entity)requester, (ServerLevel)((ServerLevel)entity.m_9236_()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), EnumSet.noneOf(RelativeMovement.class), (float)requester.m_146908_(), (float)requester.m_146909_(), null);
                    break;
                }
                case INVITE: {
                    TeleportCommand.m_139014_((CommandSourceStack)stack, (Entity)entity, (ServerLevel)((ServerLevel)requester.m_9236_()), (double)requester.m_20185_(), (double)requester.m_20186_(), (double)requester.m_20189_(), EnumSet.noneOf(RelativeMovement.class), (float)entity.m_146908_(), (float)entity.m_146909_(), null);
                }
            }
            entity.m_213846_((Component)Component.m_237110_((String)"commands.tpmaster.accept.success", (Object[])new Object[]{requester.m_7755_().getString()}));
            requester.m_213846_((Component)Component.m_237110_((String)"commands.tpmaster.request.accepted", (Object[])new Object[]{entity.m_7755_().getString()}));
            teleportable.clearTeleportMasterRequest();
        }
        return 1;
    }

    public static int deny(Entity entity) throws CommandSyntaxException {
        if (entity instanceof ITeleportable) {
            ITeleportable teleportable = (ITeleportable)entity;
            Entity requester = teleportable.getTeleportMasterRequester();
            if (requester == null) {
                throw NO_NEED_TO_DENY.create();
            }
            entity.m_213846_((Component)Component.m_237110_((String)"commands.tpmaster.deny.success", (Object[])new Object[]{requester.m_7755_().getString()}));
            requester.m_213846_((Component)Component.m_237110_((String)"commands.tpmaster.request.denied", (Object[])new Object[]{entity.m_7755_().getString()}));
            teleportable.clearTeleportMasterRequest();
        }
        return 1;
    }

    private static int away(CommandSourceStack stack, Entity entity, int distance, boolean mustOnLand, @Nullable TeleportCommand.LookAt lookAt) throws CommandSyntaxException {
        if (entity instanceof ITeleportable) {
            ITeleportable teleportable = (ITeleportable)entity;
            if (!teleportable.canUseTeleportMasterAway()) {
                throw COOL_DOWN_AWAY.create((Object)(teleportable.getTeleportMasterAwayCoolDownTick() / 20));
            }
            teleportable.setTeleportMasterAway();
        }
        if (distance == 0) {
            distance = entity.m_9236_().m_213780_().m_188503_(600) + 600;
        } else if (distance < 0 || distance > 10000) {
            throw INVALID_AWAY_DISTANCE_PARAMETER.create((Object)distance);
        }
        boolean flag = false;
        RandomSource random = entity.m_9236_().m_213780_();
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        for (int i = 0; i < (Integer)TPMCommonConfig.AWAY_TRY_COUNT.get(); ++i) {
            double phi = random.m_188500_() * 2.0 * Math.acos(-1.0);
            x = entity.m_20185_() + (double)distance * Math.cos(phi) + random.m_188500_() * (Double)TPMCommonConfig.AWAY_NOISE_BOUND.get() * (double)distance;
            z = entity.m_20189_() + (double)distance * Math.sin(phi) + random.m_188500_() * (Double)TPMCommonConfig.AWAY_NOISE_BOUND.get() * (double)distance;
            BlockPos blockPos = new BlockPos((int)x, 200, (int)z);
            String biomeId = ((ResourceKey)entity.m_9236_().m_204166_(blockPos).m_203543_().orElseThrow()).m_135782_().toString();
            boolean conti = false;
            if (mustOnLand) {
                for (String ocean : (List)TPMCommonConfig.OCEAN_BIOME_KEYS.get()) {
                    if (!biomeId.equals(ocean)) continue;
                    conti = true;
                    break;
                }
            }
            if (conti) continue;
            flag = true;
            y = LevelUtils.getTopBlock(entity.m_9236_(), blockPos);
            if (!(y < 8.0)) break;
        }
        if (!flag) {
            throw CANNOT_FIND_POSITION.create();
        }
        TeleportCommand.m_139014_((CommandSourceStack)stack, (Entity)entity, (ServerLevel)((ServerLevel)entity.m_9236_()), (double)x, (double)y, (double)z, EnumSet.noneOf(RelativeMovement.class), (float)entity.m_146908_(), (float)entity.m_146909_(), (TeleportCommand.LookAt)lookAt);
        entity.m_213846_((Component)Component.m_237110_((String)"commands.tpmaster.away.success", (Object[])new Object[]{distance}));
        return 1;
    }

    private static int request(CommandSourceStack stack, Entity entity, Entity target, ITeleportable.RequestType type) throws CommandSyntaxException {
        ITeleportable teleportable;
        if (entity instanceof ITeleportable && !(teleportable = (ITeleportable)entity).canUseTeleportMasterRequest()) {
            throw COOL_DOWN_REQUEST.create((Object)(teleportable.getTeleportMasterRequestCoolDownTick() / 20));
        }
        if (target instanceof ITeleportable) {
            ITeleportable teleportableTarget = (ITeleportable)target;
            if (teleportableTarget.getTeleportMasterRequester() != null) {
                throw TARGET_UNHANDLED_RESERVATION.create((Object)target.m_7755_().getString());
            }
            if (entity instanceof ITeleportable) {
                ITeleportable teleportable2 = (ITeleportable)entity;
                teleportable2.setTeleportMasterRequest(teleportableTarget, type);
            } else {
                teleportableTarget.receiveTeleportMasterRequestFrom(entity, type);
            }
            entity.m_213846_((Component)Component.m_237110_((String)"commands.tpmaster.request.success", (Object[])new Object[]{target.m_7755_().getString()}));
            target.m_213846_((Component)Component.m_237110_((String)(switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case ITeleportable.RequestType.ASK -> "commands.tpmaster.request.receive.ask";
                case ITeleportable.RequestType.INVITE -> "commands.tpmaster.request.receive.invite";
            }), (Object[])new Object[]{entity.m_7755_().getString(), (Integer)TPMCommonConfig.REQUEST_COMMAND_AUTO_DENY_TICK.get() / 20}));
        } else {
            boolean flag2;
            entity.m_213846_((Component)Component.m_237110_((String)"commands.tpmaster.request.success", (Object[])new Object[]{target.m_7755_().getString()}));
            boolean flag1 = entity instanceof Monster || entity instanceof NeutralMob && !(entity instanceof TamableAnimal);
            boolean bl = flag2 = target instanceof Monster || target instanceof NeutralMob && !(target instanceof TamableAnimal);
            if (flag1 == flag2) {
                switch (type) {
                    case ASK: {
                        TeleportCommand.m_139014_((CommandSourceStack)stack, (Entity)entity, (ServerLevel)((ServerLevel)target.m_9236_()), (double)target.m_20185_(), (double)target.m_20186_(), (double)target.m_20189_(), EnumSet.noneOf(RelativeMovement.class), (float)entity.m_146908_(), (float)entity.m_146909_(), null);
                        break;
                    }
                    case INVITE: {
                        TeleportCommand.m_139014_((CommandSourceStack)stack, (Entity)target, (ServerLevel)((ServerLevel)entity.m_9236_()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), EnumSet.noneOf(RelativeMovement.class), (float)target.m_146908_(), (float)target.m_146909_(), null);
                    }
                }
                entity.m_213846_((Component)Component.m_237110_((String)"commands.tpmaster.request.accepted", (Object[])new Object[]{target.m_7755_().getString()}));
            } else {
                entity.m_213846_((Component)Component.m_237110_((String)"commands.tpmaster.request.denied", (Object[])new Object[]{target.m_7755_().getString()}));
            }
        }
        return 1;
    }

    private static int spawn(CommandSourceStack stack, Entity entity) throws CommandSyntaxException {
        ServerLevel overworld = stack.m_81377_().m_129783_();
        BlockPos spawnPoint = overworld.m_220360_();
        TeleportCommand.m_139014_((CommandSourceStack)stack, (Entity)entity, (ServerLevel)overworld, (double)spawnPoint.m_123341_(), (double)((double)spawnPoint.m_123342_() + 1.0), (double)spawnPoint.m_123343_(), EnumSet.noneOf(RelativeMovement.class), (float)entity.m_146908_(), (float)entity.m_146909_(), null);
        return 1;
    }

    private static int sethome(Entity entity, int index) throws CommandSyntaxException {
        if (entity instanceof ITeleportable) {
            ITeleportable teleportable = (ITeleportable)entity;
            BlockPos pos = entity.m_20097_();
            GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)entity.m_9236_().m_46472_(), (BlockPos)entity.m_20097_());
            teleportable.setTeleportMasterHome(globalPos, index);
            entity.m_213846_((Component)Component.m_237110_((String)"commands.tpmaster.sethome.success", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), index}));
        }
        return 1;
    }

    private static int home(CommandSourceStack stack, Entity entity, int index) throws CommandSyntaxException {
        if (entity instanceof ITeleportable) {
            ITeleportable teleportable = (ITeleportable)entity;
            GlobalPos globalPos = teleportable.getTeleportMasterHome(index);
            if (globalPos == null) {
                throw NO_HOME_TO_HOME.create((Object)index);
            }
            ServerLevel level = stack.m_81377_().m_129880_(globalPos.m_122640_());
            if (level == null) {
                throw NO_LEVEL_FOUNDED_TO_HOME.create((Object)globalPos.m_122640_().toString());
            }
            BlockPos pos = globalPos.m_122646_();
            TeleportCommand.m_139014_((CommandSourceStack)stack, (Entity)entity, (ServerLevel)level, (double)pos.m_123341_(), (double)((double)pos.m_123342_() + 1.0), (double)pos.m_123343_(), EnumSet.noneOf(RelativeMovement.class), (float)entity.m_146908_(), (float)entity.m_146909_(), null);
        }
        return 1;
    }

    private static int back(CommandSourceStack stack, Entity entity) throws CommandSyntaxException {
        if (entity instanceof ITeleportable) {
            ITeleportable teleportable = (ITeleportable)entity;
            GlobalPos globalPos = teleportable.getTeleportMasterLastDeathPoint();
            if (globalPos == null) {
                throw NO_DEATH_POINT_TO_BACK.create();
            }
            ServerLevel level = stack.m_81377_().m_129880_(globalPos.m_122640_());
            if (level == null) {
                throw NO_LEVEL_FOUNDED_TO_BACK.create((Object)globalPos.m_122640_().toString());
            }
            BlockPos pos = globalPos.m_122646_();
            TeleportCommand.m_139014_((CommandSourceStack)stack, (Entity)entity, (ServerLevel)level, (double)pos.m_123341_(), (double)((double)pos.m_123342_() + 1.0), (double)pos.m_123343_(), EnumSet.noneOf(RelativeMovement.class), (float)entity.m_146908_(), (float)entity.m_146909_(), null);
        }
        return 1;
    }

    private static int removeHome(Entity entity, int index) throws CommandSyntaxException {
        if (entity instanceof ITeleportable) {
            ITeleportable teleportable = (ITeleportable)entity;
            teleportable.setTeleportMasterHome(null, index);
            entity.m_213846_((Component)Component.m_237110_((String)"commands.tpmaster.remove.home.success", (Object[])new Object[]{index}));
        }
        return 1;
    }

    private static int removeBack(Entity entity) {
        if (entity instanceof ITeleportable) {
            ITeleportable teleportable = (ITeleportable)entity;
            teleportable.setTeleportMasterLastDeathPoint(null);
            entity.m_213846_((Component)Component.m_237115_((String)"commands.tpmaster.remove.back.success"));
        }
        return 1;
    }

    private static int help(Entity entity) {
        entity.m_213846_((Component)Component.m_237115_((String)"commands.tpmaster.help"));
        return 1;
    }
}

