/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.metal_gear_ray.client.gui;

import com.TBK.metal_gear_ray.common.entity.MetalGearRayEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class ActionGui
implements IGuiOverlay {
    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        assert (player != null);
        if (mc.f_91066_.m_92176_().m_90612_() && player.m_20159_() && (entity = player.m_20202_()) instanceof MetalGearRayEntity) {
            MetalGearRayEntity netheriteForge = (MetalGearRayEntity)entity;
            guiGraphics.m_280168_().m_85836_();
            float cc = (float)netheriteForge.cooldownLaser / 600.0f;
            this.printOverlay(guiGraphics, this.getGuiTextures(), screenWidth, screenHeight);
            if (netheriteForge.bladeOn()) {
                this.printOverlay(guiGraphics, this.getBladeState(), screenWidth, screenHeight);
            }
            if (netheriteForge.towerOn()) {
                this.printOverlay(guiGraphics, this.getTowerState(), screenWidth, screenHeight);
            }
            this.printAmount(guiGraphics, this.getOffMissileTextures(), screenWidth, screenHeight, 12);
            this.printAmount(guiGraphics, this.getMissileTextures(), screenWidth, screenHeight, netheriteForge.getAmount());
            this.printOverlayPercent(guiGraphics, this.getLaserTextures(), screenWidth, screenHeight, 1.0f);
            this.printOverlayPercent(guiGraphics, this.getOffLaserTextures(), screenWidth, screenHeight, cc);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void printAmount(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int screenWidth, int screenHeight, int amount) {
        float scale = 0.33f;
        int spriteWidth = 74;
        int spriteHeight = 74;
        int drawX = screenWidth / 2 - (int)((float)spriteWidth * scale / 2.0f) + 73;
        int drawY = screenHeight / 2 - (int)((float)spriteHeight * scale / 2.0f) - 72;
        for (int i = 0; i < amount; ++i) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_((double)drawX + 6.2700000000000005 * (double)i, (double)drawY, 0.0);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280163_(resourceLocation, 0, 0, 0.0f, 0.0f, spriteWidth, Mth.m_14167_((float)spriteHeight), spriteWidth, spriteHeight);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void printOverlayPercent(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int screenWidth, int screenHeight, float percentHeight) {
        float scale = 0.33f;
        int spriteWidth = 103;
        int spriteHeight = 101;
        int drawX = screenWidth / 2 - (int)((float)spriteWidth * scale / 2.0f);
        int drawY = screenHeight / 2 - (int)((float)spriteHeight * scale / 2.0f) + 67;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)drawX, (float)drawY, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280163_(resourceLocation, 0, 0, 0.0f, 0.0f, spriteWidth, Mth.m_14167_((float)((float)spriteHeight * percentHeight)), spriteWidth, spriteHeight);
        guiGraphics.m_280168_().m_85849_();
    }

    public void printOverlay(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int screenWidth, int screenHeight) {
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, (double)screenHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)screenWidth, (double)screenHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)screenWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_85849_();
    }

    public ResourceLocation getBladeState() {
        return new ResourceLocation("metal_gear_mod", "textures/gui/ray_blade_on_overlay.png");
    }

    public ResourceLocation getTowerState() {
        return new ResourceLocation("metal_gear_mod", "textures/gui/ray_turret_on_overlay.png");
    }

    public ResourceLocation getGuiTextures() {
        return new ResourceLocation("metal_gear_mod", "textures/gui/ray_overlay.png");
    }

    public ResourceLocation getMissileTextures() {
        return new ResourceLocation("metal_gear_mod", "textures/gui/missile_amount_on.png");
    }

    public ResourceLocation getOffMissileTextures() {
        return new ResourceLocation("metal_gear_mod", "textures/gui/missile_amount_off.png");
    }

    public ResourceLocation getLaserTextures() {
        return new ResourceLocation("metal_gear_mod", "textures/gui/ray_laser_on_overlay.png");
    }

    public ResourceLocation getOffLaserTextures() {
        return new ResourceLocation("metal_gear_mod", "textures/gui/ray_laser_off_overlay.png");
    }
}

