/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.metal_gear_ray.client.renderer;

import com.TBK.metal_gear_ray.client.model.MetalGearRayModel;
import com.TBK.metal_gear_ray.client.renderer.EmissiveLayer;
import com.TBK.metal_gear_ray.client.renderer.HeadModel;
import com.TBK.metal_gear_ray.common.entity.MetalGearRayEntity;
import com.TBK.metal_gear_ray.common.register.CVNRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MetalGearRayRenderer<T extends MetalGearRayEntity, M extends MetalGearRayModel<T>>
extends MobRenderer<T, M> {
    public final ResourceLocation TEXTURE = new ResourceLocation("metal_gear_mod", "textures/entity/metal_gear_ray/ray.png");
    private static final ResourceLocation BEAM_INNER_LOCATION = new ResourceLocation("metal_gear_mod", "textures/entity/metal_gear_ray/beam/beam_inner.png");
    private static final ResourceLocation BEAM_OUTER_LOCATION = new ResourceLocation("metal_gear_mod", "textures/entity/metal_gear_ray/beam/beam_outer.png");

    public MetalGearRayRenderer(EntityRendererProvider.Context p_174304_) {
        super(p_174304_, new MetalGearRayModel(p_174304_.m_174023_(MetalGearRayModel.LAYER_LOCATION)), 0.0f);
        this.m_115326_(new HeadModel(this));
        this.m_115326_(new EmissiveLayer(this));
        this.f_114477_ = 4.0f;
    }

    public boolean shouldRender(T p_115468_, Frustum p_115469_, double p_115470_, double p_115471_, double p_115472_) {
        if (super.m_5523_(p_115468_, p_115469_, p_115470_, p_115471_, p_115472_)) {
            return true;
        }
        List posList = ((MetalGearRayEntity)p_115468_).crackingBlock.keySet().stream().toList();
        for (BlockPos pos : posList) {
            Vec3 vector3d = Vec3.m_82528_((Vec3i)pos);
            Vec3 vector3dCorner = Vec3.m_82528_((Vec3i)pos).m_82520_(1.0, 1.0, 1.0);
            if (!p_115469_.m_113029_(new AABB(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, vector3dCorner.f_82479_, vector3dCorner.f_82480_, vector3dCorner.f_82481_))) continue;
            return true;
        }
        Vec3 origin = ((MetalGearRayEntity)p_115468_).getHeadPos();
        Vec3 end = ((MetalGearRayEntity)p_115468_).laserPosition;
        return end != null ? p_115469_.m_113029_(new AABB(origin.f_82479_, origin.f_82480_, origin.f_82481_, end.f_82479_, end.f_82480_, end.f_82481_)) : false;
    }

    @Nullable
    protected RenderType getRenderType(T p_115322_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(p_115322_));
    }

    public void render(T p_115455_, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        super.m_7392_(p_115455_, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
        for (Map.Entry<BlockPos, Integer> entry : ((MetalGearRayEntity)p_115455_).crackingBlock.entrySet()) {
            p_115458_.m_85836_();
            float progressMining = ((float)((MetalGearRayEntity)p_115455_).restoreCracking - (float)entry.getValue().intValue()) / 200.0f;
            if (progressMining >= 0.0f) {
                BlockPos miningPos = entry.getKey();
                double d0 = Mth.m_14139_((double)p_115457_, (double)((MetalGearRayEntity)p_115455_).f_19790_, (double)p_115455_.m_20185_());
                double d1 = Mth.m_14139_((double)p_115457_, (double)((MetalGearRayEntity)p_115455_).f_19791_, (double)p_115455_.m_20186_());
                double d2 = Mth.m_14139_((double)p_115457_, (double)((MetalGearRayEntity)p_115455_).f_19856_, (double)p_115455_.m_20189_());
                p_115458_.m_85837_((double)miningPos.m_123341_() - d0, (double)miningPos.m_123342_() - d1, (double)miningPos.m_123343_() - d2);
                PoseStack.Pose posestack$pose = p_115458_.m_85850_();
                int progress = Math.round((float)(ModelBakery.f_119229_.size() - 1) * Mth.m_14036_((float)progressMining, (float)0.0f, (float)1.0f));
                SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(Minecraft.m_91087_().m_91269_().m_110108_().m_6299_((RenderType)ModelBakery.f_119229_.get(progress)), posestack$pose.m_252922_(), posestack$pose.m_252943_(), 1.0f);
                ModelData modelData = p_115455_.m_9236_().getModelDataManager().getAt(miningPos);
                Minecraft.m_91087_().m_91289_().renderBreakingTexture(p_115455_.m_9236_().m_8055_(miningPos), miningPos, (BlockAndTintGetter)p_115455_.m_9236_(), p_115458_, (VertexConsumer)vertexconsumer1, modelData == null ? ModelData.EMPTY : modelData);
            }
            p_115458_.m_85849_();
        }
        if (((MetalGearRayEntity)p_115455_).isLaser()) {
            this.render(p_115458_, p_115459_, p_115455_, p_115457_);
        }
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, T jellyfish, float pPartialTicks) {
        float beamProgress = 1.0f;
        float ageInTicks = (float)((MetalGearRayEntity)jellyfish).f_19797_ + pPartialTicks;
        float shakeByX = (float)Math.sin(ageInTicks * 4.0f) * 0.075f;
        float shakeByY = (float)Math.sin(ageInTicks * 4.0f + 1.2f) * 0.075f;
        float shakeByZ = (float)Math.sin(ageInTicks * 4.0f + 2.4f) * 0.075f;
        Vec3 beamOrigin = ((MetalGearRayEntity)jellyfish).getHeadPos();
        Vec3 rawBeamPosition = ((MetalGearRayEntity)jellyfish).getBeamDirection();
        float length = (float)rawBeamPosition.m_82553_();
        Vec3 vec3 = rawBeamPosition.m_82541_();
        float xRot = (float)Math.acos(vec3.f_82480_);
        float yRot = (float)Math.atan2(vec3.f_82481_, vec3.f_82479_);
        float width = beamProgress * 1.5f;
        Vec3 offSet = beamOrigin.m_82546_(jellyfish.m_20182_());
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_((double)shakeByX + offSet.f_82479_, (double)shakeByY + offSet.f_82480_ - 1.0, (double)shakeByZ + offSet.f_82481_);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - yRot) * 57.295776f));
        pMatrixStack.m_252781_(Axis.f_252529_.m_252977_((-1.5707964f + xRot) * 57.295776f));
        pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        this.renderBeam(jellyfish, pMatrixStack, pBuffer, pPartialTicks, 1.5f, length, true, false);
        this.renderBeam(jellyfish, pMatrixStack, pBuffer, pPartialTicks, 1.5f, length, false, false);
        pMatrixStack.m_85849_();
    }

    private void renderBeam(T entity, PoseStack poseStack, MultiBufferSource source, float partialTicks, float width, float length, boolean inner, boolean glowSecondPass) {
        float speed;
        VertexConsumer vertexconsumer;
        int vertices;
        poseStack.m_85836_();
        float startAlpha = 1.0f;
        float endAlpha = 1.0f;
        if (inner) {
            vertices = 4;
            vertexconsumer = source.m_6299_(CVNRenderType.getBeam(BEAM_INNER_LOCATION, false));
            speed = 0.5f;
        } else {
            vertices = 8;
            vertexconsumer = source.m_6299_(CVNRenderType.getBeam(BEAM_OUTER_LOCATION, false));
            width += 0.25f;
            speed = 1.0f;
            endAlpha = 0.0f;
        }
        float v = ((float)((MetalGearRayEntity)entity).f_19797_ + partialTicks) * -0.25f * speed;
        float v1 = v + length * (inner ? 0.5f : 0.15f);
        float f4 = -width;
        float f5 = 0.0f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        for (int j = 0; j <= vertices; ++j) {
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float f7 = Mth.m_14089_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f8 = Mth.m_14031_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f9 = (float)j + 1.0f;
            vertexconsumer.m_252986_(matrix4f, f4 * 0.55f, f5 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f6, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f4, f5, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f6, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7, f8, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f9, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7 * 0.55f, f8 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f9, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(T p_114482_) {
        return this.TEXTURE;
    }
}

