/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.metal_gear_ray.client.renderer;

import com.TBK.metal_gear_ray.client.model.MissileModel;
import com.TBK.metal_gear_ray.common.entity.MissileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MissileRenderer<T extends MissileEntity>
extends EntityRenderer<T> {
    public final MissileModel<T> missile;
    public final Map<Integer, ResourceLocation> TEXTURES = Map.of(0, new ResourceLocation("metal_gear_mod", "textures/gui/target_reticle/target_0.png"), 1, new ResourceLocation("metal_gear_mod", "textures/gui/target_reticle/target_1.png"), 2, new ResourceLocation("metal_gear_mod", "textures/gui/target_reticle/target_2.png"), 3, new ResourceLocation("metal_gear_mod", "textures/gui/target_reticle/target_3.png"));

    public MissileRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
        this.missile = new MissileModel(p_174008_.m_174023_(MissileModel.LAYER_LOCATION));
    }

    public boolean shouldRender(T p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        return true;
    }

    public void render(T p_113839_, float p_113840_, float p_113841_, PoseStack p_113842_, MultiBufferSource p_113843_, int p_113844_) {
        super.m_7392_(p_113839_, p_113840_, p_113841_, p_113842_, p_113843_, p_113844_);
        p_113842_.m_85836_();
        if (((MissileEntity)((Object)p_113839_)).getTarget() != null) {
            double d0 = Mth.m_14139_((double)p_113841_, (double)((MissileEntity)((Object)p_113839_)).f_19790_, (double)p_113839_.m_20185_());
            double d1 = Mth.m_14139_((double)p_113841_, (double)((MissileEntity)((Object)p_113839_)).f_19791_, (double)p_113839_.m_20186_());
            double d2 = Mth.m_14139_((double)p_113841_, (double)((MissileEntity)((Object)p_113839_)).f_19792_, (double)p_113839_.m_20189_());
            double x = Mth.m_14139_((double)p_113841_, (double)((MissileEntity)((Object)p_113839_)).targetXOld, (double)((MissileEntity)((Object)p_113839_)).targetX);
            double y = Mth.m_14139_((double)p_113841_, (double)((MissileEntity)((Object)p_113839_)).targetYOld, (double)((MissileEntity)((Object)p_113839_)).targetY) + 0.24;
            double z = Mth.m_14139_((double)p_113841_, (double)((MissileEntity)((Object)p_113839_)).targetZOld, (double)((MissileEntity)((Object)p_113839_)).targetZ);
            double distance = Math.abs(Mth.m_14139_((double)p_113841_, (double)(((MissileEntity)((Object)p_113839_)).f_19791_ - ((MissileEntity)((Object)p_113839_)).targetYOld), (double)(p_113839_.m_20186_() - ((MissileEntity)((Object)p_113839_)).targetY)));
            int instancia = Mth.m_14165_((double)Mth.m_14008_((double)(3.0 * (1.0 - distance / Math.abs(((MissileEntity)((Object)p_113839_)).maxHeight))), (double)0.0, (double)3.0));
            p_113842_.m_85837_(x - d0, y - d1, z - d2);
            if (instancia < 3) {
                p_113842_.m_252781_(Axis.f_252436_.m_252977_(3.0f * (float)((MissileEntity)((Object)p_113839_)).f_19797_));
            }
            PoseStack.Pose pose = p_113842_.m_85850_();
            this.drawSlash(pose, p_113839_, p_113843_, p_113844_, 5.0f, p_113841_);
        }
        p_113842_.m_85849_();
        p_113842_.m_85836_();
        p_113842_.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14189_((float)p_113841_, (float)((MissileEntity)((Object)p_113839_)).f_19859_, (float)p_113839_.m_146908_()) - 90.0f));
        p_113842_.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14189_((float)p_113841_, (float)((MissileEntity)((Object)p_113839_)).f_19860_, (float)p_113839_.m_146909_())));
        this.missile.m_7695_(p_113842_, p_113843_.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(p_113839_))), p_113844_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        p_113842_.m_85849_();
    }

    public ResourceLocation getTextureLocation(T p_114482_) {
        return new ResourceLocation("metal_gear_mod", "textures/entity/metal_gear_ray/ray_missile.png");
    }

    public ResourceLocation getTextureReticle(int index) {
        return this.TEXTURES.get(index);
    }

    private void drawSlash(PoseStack.Pose pose, T entity, MultiBufferSource bufferSource, int light, float width, float partilTicks) {
        Matrix4f poseMatrix = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        double distance = Math.abs(Mth.m_14139_((double)partilTicks, (double)(((MissileEntity)((Object)entity)).f_19791_ - ((MissileEntity)((Object)entity)).targetYOld), (double)(entity.m_20186_() - ((MissileEntity)((Object)entity)).targetY)));
        int indexForDistance = ((MissileEntity)((Object)entity)).f_19797_ > ((MissileEntity)((Object)entity)).maxTickAltura && Math.abs(((MissileEntity)((Object)entity)).maxHeight) > 0.0 && ((MissileEntity)((Object)entity)).delayTime <= 0 ? Mth.m_14165_((double)Mth.m_14008_((double)(3.0 * (1.0 - distance / Math.abs(((MissileEntity)((Object)entity)).maxHeight))), (double)0.0, (double)3.0)) : 0;
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)this.getTextureReticle(indexForDistance)));
        float halfWidth = width * 0.5f;
        consumer.m_252986_(poseMatrix, -halfWidth, -0.1f, -halfWidth).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, halfWidth, -0.1f, -halfWidth).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, halfWidth, -0.1f, halfWidth).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, -halfWidth, -0.1f, halfWidth).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

