/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.metal_gear_ray.common.entity;

import com.TBK.metal_gear_ray.client.animations.MetalGearRayAnim;
import com.TBK.metal_gear_ray.common.api.IMecha;
import com.TBK.metal_gear_ray.common.entity.BeamExplosionEntity;
import com.TBK.metal_gear_ray.common.entity.BulletEntity;
import com.TBK.metal_gear_ray.common.entity.MissileEntity;
import com.TBK.metal_gear_ray.common.entity.TowerPart;
import com.TBK.metal_gear_ray.common.network.PacketHandler;
import com.TBK.metal_gear_ray.common.network.messager.PacketActionRay;
import com.TBK.metal_gear_ray.common.network.messager.PacketKeySync;
import com.TBK.metal_gear_ray.common.network.messager.PacketMissileTarget;
import com.TBK.metal_gear_ray.common.register.CVNItems;
import com.TBK.metal_gear_ray.common.register.CVNSounds;
import com.TBK.metal_gear_ray.common.register.MGParticles;
import com.TBK.metal_gear_ray.server.capability.ArsenalCapability;
import com.TBK.metal_gear_ray.server.keybind.MGKeybinds;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.wrapper.InvWrapper;

public class MetalGearRayEntity
extends PathfinderMob
implements ContainerListener,
HasCustomInventoryScreen,
PlayerRideableJumping,
RiderShieldingMount,
IMecha,
OwnableEntity {
    public static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(MetalGearRayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> LASER = SynchedEntityData.m_135353_(MetalGearRayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> AMOUNT = SynchedEntityData.m_135353_(MetalGearRayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TOWER_ON = SynchedEntityData.m_135353_(MetalGearRayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> BLADE_ON = SynchedEntityData.m_135353_(MetalGearRayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_ID = SynchedEntityData.m_135353_(MetalGearRayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public AnimationState stomp = new AnimationState();
    public AnimationState meleeAttack = new AnimationState();
    public AnimationState idle = new AnimationState();
    public AnimationState inWater = new AnimationState();
    public AnimationState isAir = new AnimationState();
    public AnimationState bladeOn = new AnimationState();
    public AnimationState bladeOff = new AnimationState();
    public AnimationState towerOn = new AnimationState();
    public AnimationState towerOff = new AnimationState();
    public AnimationState prepareLaser = new AnimationState();
    public AnimationState laser = new AnimationState();
    private int idleAnimationTimeout;
    private int swimAnimationTimeout;
    private int attackTimer;
    private final TowerPart<?> missileSlot0;
    private final TowerPart<?> missileSlot1;
    private final TowerPart<?> missileSlot2;
    private final TowerPart<?> tower0;
    private final TowerPart<?> tower1;
    private final TowerPart<?> tower2;
    private final TowerPart<?> tower3;
    private final TowerPart<?> head;
    private final TowerPart<?> body;
    private final TowerPart<?>[] slots;
    private final TowerPart<?>[] towers;
    private final TowerPart<?>[] bodyParts;
    private final TowerPart<?>[] parts;
    public Vec3 laserPosition = Vec3.f_82478_;
    public int prepareLaserTimer = 0;
    public int laserTimer = 0;
    public int resetTowerSoundTimer = 0;
    public float rotHeadY = 0.0f;
    public float rotHeadY0 = 0.0f;
    public float rotHeadX = 0.0f;
    public float rotHeadX0 = 0.0f;
    public boolean isJumping = false;
    public boolean isShooting = false;
    public float jumpPendingScale = 0.0f;
    public int cooldownLaser = 0;
    public int cooldownJump = 0;
    public Map<BlockPos, Integer> crackingBlock = new HashMap<BlockPos, Integer>();
    public int restoreCracking = 0;
    public int cooldownAmount = 0;
    public int smokeEffectTimer = 0;
    public int interpolationCamTimer = 0;
    public int interpolationCamTimer0 = 0;
    public int tickReload = 0;
    protected SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    private Vec3 positionOld = Vec3.f_82478_;
    protected static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(MetalGearRayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean step1Played = false;
    private boolean step2Played = false;
    private boolean lift1Played = false;
    private boolean lift2Played = false;
    private boolean passengersWaterBuffer = false;

    public MetalGearRayEntity(EntityType<? extends PathfinderMob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
        this.missileSlot0 = new TowerPart<MetalGearRayEntity>(this, "missileSlot0", 1.0f, 1.0f);
        this.missileSlot1 = new TowerPart<MetalGearRayEntity>(this, "missileSlot1", 1.0f, 1.0f);
        this.missileSlot2 = new TowerPart<MetalGearRayEntity>(this, "missileSlot2", 1.0f, 1.0f);
        this.tower0 = new TowerPart<MetalGearRayEntity>(this, "tower0", 1.0f, 1.0f);
        this.tower1 = new TowerPart<MetalGearRayEntity>(this, "tower1", 1.0f, 1.0f);
        this.tower2 = new TowerPart<MetalGearRayEntity>(this, "tower2", 1.0f, 1.0f);
        this.tower3 = new TowerPart<MetalGearRayEntity>(this, "tower3", 1.0f, 1.0f);
        this.head = new TowerPart<MetalGearRayEntity>(this, "head", 3.0f, 3.0f);
        this.body = new TowerPart<MetalGearRayEntity>(this, "body", 10.0f, 10.0f);
        this.slots = new TowerPart[]{this.missileSlot0, this.missileSlot1, this.missileSlot2};
        this.towers = new TowerPart[]{this.tower0, this.tower1, this.tower2, this.tower3};
        this.bodyParts = new TowerPart[]{this.body, this.head};
        this.parts = new TowerPart[]{this.missileSlot0, this.missileSlot1, this.missileSlot2, this.tower0, this.tower1, this.tower2, this.tower3, this.body, this.head};
        this.m_20234_(f_19843_.getAndAdd(this.parts.length + 1) + 1);
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].m_20234_(p_20235_ + i + 1);
        }
    }

    @org.jetbrains.annotations.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, @org.jetbrains.annotations.Nullable SpawnGroupData p_21437_, @org.jetbrains.annotations.Nullable CompoundTag p_21438_) {
        this.createInventory();
        this.setAmount(12);
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public static AttributeSupplier setAttributes() {
        return MetalGearRayEntity.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22284_, 40.0).m_22268_(Attributes.f_22285_, 10.0).m_22268_(Attributes.f_22277_, 45.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22288_, (double)0.43f).m_22265_();
    }

    protected int getInventorySize() {
        return 54;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new RayAttackGoal(this, 2.0, false));
        this.f_21346_.m_25352_(4, (Goal)new OwnerHurtTargetMetalGearGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal(this));
    }

    public Vec3 getHeadPos() {
        double x = this.head.m_20185_();
        double y = this.head.m_20186_();
        double z = this.head.m_20189_();
        return new Vec3(x, y, z);
    }

    public Vec3 getBeamDirection() {
        Vec3 direction;
        if (this.m_20160_()) {
            LivingEntity passanger = this.m_6688_();
            Vec3 view = this.m_20171_(passanger.m_5686_(1.0f) - 7.0f, passanger.m_6080_());
            direction = this.getHeadPos().m_82549_(view.m_82490_(50.0)).m_82546_(this.getHeadPos().m_82549_(view.m_82490_(1.0)));
        } else {
            direction = this.getHeadPos().m_82549_(this.viewHeadY().m_82490_(50.0)).m_82546_(this.getHeadPos().m_82549_(this.viewHeadY().m_82490_(0.5)));
        }
        return direction;
    }

    protected void executeRidersJump(float p_251967_, Vec3 p_275627_) {
        double d0 = this.m_21133_(Attributes.f_22288_) * (double)this.m_20098_() + (double)this.m_285755_();
        this.m_246865_(this.m_20154_().m_82542_(4.0, 0.0, 4.0).m_82541_().m_82490_((double)(22.2222f * p_251967_) * this.m_21133_(Attributes.f_22279_) * (double)this.m_6041_()).m_82520_(0.0, (double)(this.m_20069_() ? 10.0f : 4.4285f * p_251967_) * d0, 0.0));
        this.setIsJumping(true);
        this.f_19812_ = true;
    }

    protected void m_274498_(Player p_278233_, Vec3 p_275693_) {
        super.m_274498_(p_278233_, p_275693_);
        if (this.m_6109_()) {
            if (this.m_20096_() || this.m_20069_()) {
                if (this.isJumping() && this.m_9236_().f_46443_) {
                    this.applyRadius(10.0f, 0.2f, this.m_20182_());
                    PacketHandler.sendToServer(new PacketKeySync(4));
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CVNSounds.RAY_STOMP.get(), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
                    HashMap<BlockPos, Integer> posSet = new HashMap<BlockPos, Integer>();
                    for (BlockPos pos2 : BlockPos.m_121940_((BlockPos)this.m_20097_().m_7918_(10, 1, 10), (BlockPos)this.m_20097_().m_7918_(-10, -1, -10))) {
                        float entityHitDistance;
                        if (this.m_9236_().m_8055_(pos2).m_60795_() || !((entityHitDistance = Math.max((float)Math.sqrt(((double)pos2.m_123343_() - this.m_20189_()) * ((double)pos2.m_123343_() - this.m_20189_()) + ((double)pos2.m_123341_() - this.m_20185_()) * ((double)pos2.m_123341_() - this.m_20185_())), 0.0f)) <= 12.0f) || !(entityHitDistance >= 2.0f)) continue;
                        Random random1 = new Random();
                        double distance = (double)0.12f * Math.ceil(entityHitDistance) + (double)random1.nextFloat(0.0f, 1.0f);
                        BlockPos.MutableBlockPos pos1 = pos2.m_122032_();
                        boolean canSummon = true;
                        for (int i = 0; i < Mth.m_14165_((double)distance); ++i) {
                            if (!canSummon || this.m_9236_().m_8055_(pos1.m_7494_()).m_60795_()) continue;
                            canSummon = false;
                        }
                        if (!canSummon) continue;
                        distance = Mth.m_14036_((float)(12.0f / entityHitDistance), (float)0.0f, (float)1.0f);
                        posSet.put(new BlockPos(pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_()), (int)distance);
                        for (int j = 0; j < this.m_9236_().f_46441_.m_216339_(5, 10); ++j) {
                            Minecraft.m_91087_().f_91061_.m_107367_(pos2, Direction.UP);
                        }
                    }
                    this.crackingBlock = posSet;
                    this.restoreCracking = 200;
                }
                this.setIsJumping(false);
                if (this.jumpPendingScale > 0.0f && !this.isJumping()) {
                    this.executeRidersJump(1.0f, p_275693_);
                }
                this.jumpPendingScale = 0.0f;
            }
        } else {
            if (p_278233_.m_21124_(MobEffects.f_19611_) == null) {
                if (p_278233_.m_20069_()) {
                    p_278233_.m_147207_(new MobEffectInstance(MobEffects.f_19611_, 9999999, 2), (Entity)this);
                    this.passengersWaterBuffer = true;
                }
            } else if (!p_278233_.m_20069_() && this.passengersWaterBuffer) {
                p_278233_.m_21195_(MobEffects.f_19611_);
                this.passengersWaterBuffer = false;
            }
            if (p_278233_.m_20069_()) {
                p_278233_.m_20301_(300);
            }
        }
        p_278233_.m_20095_();
    }

    public void setSitting(boolean isSitting) {
        this.f_19804_.m_135381_(SITTING, (Object)isSitting);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public void setIsJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (this.m_20197_().contains(p_21016_.m_7639_())) {
            return false;
        }
        p_21017_ = Math.min(50.0f, p_21017_);
        if (p_21016_.m_7639_() instanceof Player) {
            this.f_20889_ = this.f_19797_;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return SoundEvents.f_12008_;
    }

    private static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.f_232256_() ? f % p_232317_.f_232255_() : f;
    }

    public void m_6667_(DamageSource p_21014_) {
        Player player;
        ArsenalCapability cap;
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 30; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)MGParticles.BEAM_EXPLOSION.get(), this.m_20185_() + (double)this.f_19796_.m_216339_(-30, 30), this.m_20186_() + (double)this.f_19796_.m_216339_(0, 10), this.m_20189_() + (double)this.f_19796_.m_216339_(-30, 30), 0.0, 0.0, 0.0);
            }
        }
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 30.0f, Level.ExplosionInteraction.NONE);
        LivingEntity livingEntity = this.m_269323_();
        if (livingEntity instanceof Player && (cap = ArsenalCapability.get(player = (Player)livingEntity)) != null) {
            cap.rayDie();
        }
        super.m_6667_(p_21014_);
    }

    public void m_8119_() {
        Player player;
        ArsenalCapability cap;
        super.m_8119_();
        LivingEntity livingEntity = this.m_269323_();
        if (livingEntity instanceof Player && (cap = ArsenalCapability.get(player = (Player)livingEntity)) != null) {
            cap.lastPos = new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_(), this.m_20183_().m_123343_());
            cap.lastDimension = this.m_9236_().m_46472_();
        }
        if ((this.f_20889_ + 250 < this.f_19797_ || this.m_21215_() + 250 < this.f_19797_) && this.m_21233_() != this.m_21223_() && this.f_19797_ % 100 == 0) {
            if (!this.m_9236_().f_46443_) {
                this.m_5634_(1.0f);
            }
            this.spawParticleHeal();
        }
        if (this.getAmount() < 12) {
            --this.cooldownAmount;
            if (this.cooldownAmount <= 0) {
                if (!this.m_9236_().f_46443_ && this.m_6688_() != null) {
                    this.m_9236_().m_6269_(null, (Entity)this.m_6688_(), (SoundEvent)CVNSounds.RAY_MISSILE_RELOAD.get(), SoundSource.NEUTRAL, 5.0f, 1.0f);
                }
                this.plusAmount(3);
                this.cooldownAmount = 200;
            }
        }
        if (!this.m_20160_()) {
            if (this.m_9236_().m_6249_((Entity)this, this.body.m_20191_().m_82400_(3.0), EntitySelector.f_20406_.and(e -> !this.m_7306_((Entity)e))).isEmpty()) {
                this.setTowerOn(false);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7605_((Entity)this, (byte)9);
                }
                this.resetTowerSoundTimer = 0;
            } else {
                this.setTowerOn(true);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7605_((Entity)this, (byte)12);
                }
            }
        } else {
            this.m_20197_().forEach(e -> {
                if (e instanceof LivingEntity) {
                    e.m_20095_();
                    ((LivingEntity)e).m_7292_(new MobEffectInstance(MobEffects.f_19607_, 5, 99, false, false));
                }
            });
        }
        if (this.cooldownJump > 0) {
            --this.cooldownJump;
        }
        this.tickParts();
        this.tickLaser();
        this.tickAttack();
        this.rotHeadY0 = this.rotHeadY;
        this.rotHeadX0 = this.rotHeadX;
        this.interpolationCamTimer0 = this.interpolationCamTimer;
        if (this.m_9236_().f_46443_) {
            this.clientTick();
        } else {
            this.serverTick();
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 20 == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            boolean flag = false;
            AABB aabb = this.body.m_20191_().m_82400_(1.0);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!(block instanceof LeavesBlock) && !blockstate.m_204336_(BlockTags.f_13106_)) continue;
                flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
        if (this.tickReload > 0) {
            --this.tickReload;
        }
        while (this.rotHeadX - this.rotHeadX0 < -180.0f) {
            this.rotHeadX0 -= 360.0f;
        }
        while (this.rotHeadX - this.rotHeadX0 >= 180.0f) {
            this.rotHeadX0 += 360.0f;
        }
        while (this.rotHeadY - this.rotHeadY0 < -180.0f) {
            this.rotHeadY0 -= 360.0f;
        }
        while (this.rotHeadY - this.rotHeadY0 >= 180.0f) {
            this.rotHeadY0 += 360.0f;
        }
    }

    private void tickLaser() {
        double f6;
        double f5;
        Vec3 vec32;
        if (this.prepareLaserTimer > 0) {
            --this.prepareLaserTimer;
            this.m_21573_().m_26573_();
            if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
                this.m_146884_(this.m_20182_());
                vec32 = this.m_5448_().m_20182_().m_82546_(this.m_146892_());
                f5 = -Math.toDegrees(Math.atan2(vec32.f_82480_, Math.sqrt(vec32.f_82479_ * vec32.f_82479_ + vec32.f_82481_ * vec32.f_82481_)));
                f6 = Math.toDegrees(Math.atan2(vec32.f_82481_, vec32.f_82479_)) - 90.0;
                this.f_20885_ = (float)f6;
                this.m_5616_((float)f6);
                this.f_20883_ = (float)f6;
                this.m_146922_((float)f6);
                this.m_146926_((float)f5);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.rotHeadX = this.lerpRotation(this.rotHeadX, (float)f5, 5.0f);
                this.rotHeadY = Mth.m_14036_((float)this.lerpRotation(this.rotHeadY, (float)f6 - this.m_146908_(), 5.0f), (float)-60.0f, (float)60.0f);
            }
            if (this.prepareLaserTimer == 0) {
                if (!this.m_9236_().f_46443_) {
                    this.setLaser(true);
                    if (this.m_20160_()) {
                        this.laserPosition = null;
                        this.m_9236_().m_7605_((Entity)this, (byte)14);
                    } else if (this.m_5448_() != null) {
                        this.laserPosition = this.m_5448_().m_20182_();
                        PacketHandler.sendToAllTracking(new PacketActionRay(this.m_19879_(), (int)this.m_5448_().m_20185_(), (int)this.m_5448_().m_20186_(), (int)this.m_5448_().m_20189_(), 0), (LivingEntity)this);
                    }
                } else {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CVNSounds.RAY_SHOOT_LASER.get(), SoundSource.NEUTRAL, 3.0f, 1.0f + 3.0f * this.f_19796_.m_188501_(), false);
                    this.idleAnimationTimeout = 200;
                    this.prepareLaser.m_216973_();
                    this.laser.m_216977_(this.f_19797_);
                }
            }
        }
        if (this.cooldownLaser > 0) {
            --this.cooldownLaser;
        }
        if (this.isLaser()) {
            --this.laserTimer;
            this.m_21573_().m_26573_();
            if (this.m_20160_()) {
                if (this.f_19797_ % 2 == 0 && this.m_6688_() != null) {
                    blockEnd = this.m_9236_().m_45547_(new ClipContext(this.getHeadPos(), this.getHeadPos().m_82549_(this.m_20171_(this.m_6688_().m_5686_(1.0f) - 7.0f, this.m_6688_().m_6080_()).m_82490_(50.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                    List<EntityHitResult> hits = this.getBeamEntityHitResult(this.m_9236_(), (Entity)this, this.getHeadPos(), this.getHeadPos().m_82549_(this.m_20171_(this.m_6688_().m_5686_(1.0f) - 7.0f, this.m_6688_().m_6080_()).m_82490_(50.0)), this.m_20191_().m_82400_(100.0), e -> !this.m_7306_((Entity)e), 0.5f);
                    if (hits != null) {
                        for (EntityHitResult hit : hits) {
                            LivingEntity entity;
                            if (!(hit.m_82443_() instanceof LivingEntity) || !(entity = (LivingEntity)hit.m_82443_()).m_6469_(this.m_269291_().m_269264_(), 4.0f)) continue;
                            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 3, 10));
                        }
                    }
                    if (!this.m_9236_().m_8055_(blockEnd.m_82425_()).m_60795_()) {
                        BlockPos end = blockEnd.m_82425_();
                        if (this.m_9236_().f_46443_) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_9236_().m_7106_((ParticleOptions)MGParticles.BEAM_EXPLOSION.get(), (double)(end.m_123341_() + this.f_19796_.m_216339_(-2, 2)), (double)(end.m_123342_() + this.f_19796_.m_216339_(0, 2)), (double)(end.m_123343_() + this.f_19796_.m_216339_(-2, 2)), 0.0, 0.0, 0.0);
                            }
                        } else {
                            MetalGearRayEntity.createExplosion(end, (LivingEntity)this, Explosion.BlockInteraction.KEEP);
                        }
                    }
                }
            } else {
                if (this.f_19797_ % 2 == 0) {
                    blockEnd = this.m_9236_().m_45547_(new ClipContext(this.getHeadPos(), this.getHeadPos().m_82549_(this.viewHeadY().m_82490_(50.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                    List<EntityHitResult> hits = this.getBeamEntityHitResult(this.m_9236_(), (Entity)this, this.getHeadPos(), this.getHeadPos().m_82549_(this.viewHeadY().m_82490_(50.0)), this.m_20191_().m_82400_(100.0), e -> !this.m_7306_((Entity)e), 0.5f);
                    if (hits != null) {
                        for (EntityHitResult hit : hits) {
                            LivingEntity entity;
                            if (!(hit.m_82443_() instanceof LivingEntity) || !(entity = (LivingEntity)hit.m_82443_()).m_6469_(this.m_269291_().m_269264_(), 4.0f)) continue;
                            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 3, 10));
                        }
                    }
                    if (!this.m_9236_().m_8055_(blockEnd.m_82425_()).m_60795_()) {
                        BlockPos end = blockEnd.m_82425_();
                        if (this.m_9236_().f_46443_) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_9236_().m_7106_((ParticleOptions)MGParticles.BEAM_EXPLOSION.get(), (double)(end.m_123341_() + this.f_19796_.m_216339_(-2, 2)), (double)(end.m_123342_() + this.f_19796_.m_216339_(0, 2)), (double)(end.m_123343_() + this.f_19796_.m_216339_(-2, 2)), 0.0, 0.0, 0.0);
                            }
                        } else {
                            MetalGearRayEntity.createExplosion(end, (LivingEntity)this, Explosion.BlockInteraction.KEEP);
                        }
                    }
                    if (!this.m_9236_().f_46443_ && !this.isValidTarget((Entity)this.m_5448_())) {
                        this.m_6710_(null);
                        LivingEntity livingEntity = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(40.0), EntitySelector.f_20406_.and(e -> !this.m_7306_((Entity)e) && this.isValidTarget((Entity)e))).stream().findFirst().orElse(null);
                        if (livingEntity != null) {
                            this.m_6710_(livingEntity);
                            this.laserPosition = livingEntity.m_20182_().m_82520_(0.0, (double)livingEntity.m_20206_(), 0.0);
                            PacketHandler.sendToAllTracking(new PacketActionRay(this.m_19879_(), (int)this.laserPosition.f_82479_, (int)this.laserPosition.f_82480_, (int)this.laserPosition.f_82481_, 0), (LivingEntity)this);
                        }
                        if (this.m_5448_() == null) {
                            this.setLaser(false);
                            this.cooldownLaser = 600;
                            this.laserPosition = null;
                            if (!this.m_9236_().f_46443_) {
                                this.m_9236_().m_7605_((Entity)this, (byte)17);
                            }
                        }
                    }
                }
                if (this.laserPosition != null) {
                    this.m_146884_(this.m_20182_());
                    vec32 = this.laserPosition.m_82546_(this.getHeadPos());
                    f5 = -Math.toDegrees(Math.atan2(vec32.f_82480_, Math.sqrt(vec32.f_82479_ * vec32.f_82479_ + vec32.f_82481_ * vec32.f_82481_)));
                    f6 = Math.toDegrees(Math.atan2(vec32.f_82481_, vec32.f_82479_)) - 90.0 - (double)this.m_146908_();
                    this.rotHeadX = this.lerpRotation(this.rotHeadX, (float)f5, 5.0f);
                    this.rotHeadY = Mth.m_14036_((float)this.lerpRotation(this.rotHeadY, (float)f6, 5.0f), (float)-45.0f, (float)45.0f);
                }
            }
            if (this.laserTimer <= 0) {
                this.setLaser(false);
                this.cooldownLaser = 600;
                this.laserPosition = null;
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7605_((Entity)this, (byte)17);
                }
            }
        }
    }

    private void tickAttack() {
        if (this.isAttacking()) {
            --this.attackTimer;
            if (this.bladeOn()) {
                if (this.attackTimer == 16) {
                    if (this.m_9236_().f_46443_) {
                        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CVNSounds.RAY_SWORD_SWING.get(), SoundSource.NEUTRAL, 4.0f, 1.0f, false);
                    }
                    List targets = this.m_9236_().m_6443_(Entity.class, this.body.m_20191_().m_82377_(7.0, 7.0, 7.0), e -> e != this.m_6688_() && e != this && this.m_20270_((Entity)e) <= 20.0f + e.m_20205_() / 2.0f && e.m_20186_() <= this.m_20186_() + 10.0);
                    for (Entity living : targets) {
                        float entityHitAngle = (float)((Math.atan2(living.m_20189_() - this.m_20189_(), living.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                        float entityAttackingAngle = this.m_146908_() % 360.0f;
                        float arc = 180.0f;
                        if (entityHitAngle < 0.0f) {
                            entityHitAngle += 360.0f;
                        }
                        if (entityAttackingAngle < 0.0f) {
                            entityAttackingAngle += 360.0f;
                        }
                        float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                        float entityHitDistance = (float)Math.sqrt((living.m_20189_() - this.m_20189_()) * (living.m_20189_() - this.m_20189_()) + (living.m_20185_() - this.m_20185_()) * (living.m_20185_() - this.m_20185_())) - living.m_20205_() / 2.0f;
                        if (!(living instanceof LivingEntity) || !((double)entityHitDistance <= 19.7 && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f)) continue;
                        living.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 30.0f);
                        living.m_20254_(3);
                        float f0 = 2.0f / living.m_20205_() * 0.5f;
                        Vec3 vec3 = new Vec3(living.m_20185_() - this.m_20185_(), 0.0, living.m_20189_() - this.m_20189_()).m_82541_().m_82490_((double)f0);
                        living.m_5997_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    }
                }
            } else if (this.attackTimer == 5) {
                if (this.m_9236_().f_46443_) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CVNSounds.RAY_STOMP.get(), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
                    HashMap<BlockPos, Integer> posSet = new HashMap<BlockPos, Integer>();
                    for (BlockPos pos2 : BlockPos.m_121940_((BlockPos)this.m_20097_().m_7918_(10, 1, 10), (BlockPos)this.m_20097_().m_7918_(-10, -1, -10))) {
                        float entityHitDistance;
                        if (this.m_9236_().m_8055_(pos2).m_60795_() || !((entityHitDistance = Math.max((float)Math.sqrt(((double)pos2.m_123343_() - this.m_20189_()) * ((double)pos2.m_123343_() - this.m_20189_()) + ((double)pos2.m_123341_() - this.m_20185_()) * ((double)pos2.m_123341_() - this.m_20185_())), 0.0f)) <= 12.0f) || !(entityHitDistance >= 2.0f)) continue;
                        Random random1 = new Random();
                        double distance = (double)0.12f * Math.ceil(entityHitDistance) + (double)random1.nextFloat(0.0f, 1.0f);
                        BlockPos.MutableBlockPos pos1 = pos2.m_122032_();
                        boolean canSummon = true;
                        for (int i = 0; i < Mth.m_14165_((double)distance); ++i) {
                            if (!canSummon || this.m_9236_().m_8055_(pos1.m_7494_()).m_60795_()) continue;
                            canSummon = false;
                        }
                        if (!canSummon) continue;
                        distance = Mth.m_14036_((float)(12.0f / entityHitDistance), (float)0.0f, (float)1.0f);
                        posSet.put(new BlockPos(pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_()), (int)distance);
                        for (int j = 0; j < this.m_9236_().f_46441_.m_216339_(5, 10); ++j) {
                            Minecraft.m_91087_().f_91061_.m_107367_(pos2, Direction.UP);
                        }
                    }
                    this.crackingBlock = posSet;
                    this.restoreCracking = 200;
                }
                this.upEntities(this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(10.0)));
            }
            if (this.attackTimer == 0) {
                this.setIsAttacking(false);
            }
        }
    }

    public void tickStep() {
        float animationProgress = this.f_267362_.m_267756_();
        long u = (long)(animationProgress * 50.0f * 2.0f);
        float seconds = MetalGearRayEntity.getElapsedSeconds(MetalGearRayAnim.walklegs, u);
        if (!this.step1Played && seconds >= 1.755f) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CVNSounds.RAY_FOOTSTEP2.get(), SoundSource.HOSTILE, 10.0f, 1.0f, false);
            this.step1Played = true;
        }
        if (!this.step2Played && seconds >= 2.869f) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CVNSounds.RAY_FOOTSTEP2.get(), SoundSource.HOSTILE, 10.0f, 1.0f, false);
            this.step2Played = true;
        }
        if (!this.lift1Played && seconds >= 0.271f) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CVNSounds.RAY_FOOTSTEP1.get(), SoundSource.HOSTILE, 10.0f, 1.0f, false);
            this.lift1Played = true;
        }
        if (!this.lift2Played && seconds >= 2.088f) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CVNSounds.RAY_FOOTSTEP1.get(), SoundSource.HOSTILE, 10.0f, 1.0f, false);
            this.lift2Played = true;
        }
        if (seconds < 0.2f) {
            this.step1Played = false;
            this.step2Played = false;
            this.lift1Played = false;
            this.lift2Played = false;
        }
    }

    private void tickParts() {
        double leg0Z;
        if (this.towerOn()) {
            for (TowerPart<?> leg : this.towers) {
                leg.m_8119_();
                leg.setSize(EntityDimensions.m_20395_((float)1.0f, (float)1.0f));
            }
        } else {
            for (TowerPart<?> leg : this.towers) {
                leg.m_8119_();
                leg.setSize(EntityDimensions.m_20395_((float)0.0f, (float)0.0f));
            }
        }
        float yawRad = (float)Math.toRadians(this.m_146908_());
        float sin = (float)Math.sin(yawRad);
        float cos = (float)Math.cos(yawRad);
        double body0X = -7.0f * sin;
        double body0Z = -(-7.0f * cos);
        Vec3[] pos = new Vec3[this.bodyParts.length];
        for (int j = 0; j < this.bodyParts.length; ++j) {
            pos[j] = new Vec3(this.bodyParts[j].m_20185_(), this.bodyParts[j].m_20186_(), this.bodyParts[j].m_20189_());
        }
        this.tickPart(this.head, body0X, 7.0, body0Z);
        this.tickPart(this.body, 0.0, 0.0, 0.0);
        for (int k = 0; k < this.bodyParts.length; ++k) {
            this.bodyParts[k].f_19854_ = pos[k].f_82479_;
            this.bodyParts[k].f_19855_ = pos[k].f_82480_;
            this.bodyParts[k].f_19856_ = pos[k].f_82481_;
            this.bodyParts[k].f_19790_ = pos[k].f_82479_;
            this.bodyParts[k].f_19791_ = pos[k].f_82480_;
            this.bodyParts[k].f_19792_ = pos[k].f_82481_;
        }
        Vec3[] posSlot = new Vec3[this.slots.length];
        for (int j = 0; j < this.slots.length; ++j) {
            posSlot[j] = new Vec3(this.slots[j].m_20185_(), this.slots[j].m_20186_(), this.slots[j].m_20189_());
        }
        for (int k = 0; k < this.slots.length; ++k) {
            double leg0X = (float)(5 - k * 2) * cos + -2.5f * sin;
            leg0Z = (float)(5 - k * 2) * sin - -2.5f * cos;
            this.tickPart(this.slots[k], leg0X, 8.0, leg0Z);
            this.slots[k].f_19854_ = posSlot[k].f_82479_;
            this.slots[k].f_19855_ = posSlot[k].f_82480_;
            this.slots[k].f_19856_ = posSlot[k].f_82481_;
            this.slots[k].f_19790_ = posSlot[k].f_82479_;
            this.slots[k].f_19791_ = posSlot[k].f_82480_;
            this.slots[k].f_19792_ = posSlot[k].f_82481_;
        }
        if (this.towerOn()) {
            Vec3[] avec3 = new Vec3[this.towers.length];
            for (int j = 0; j < this.towers.length; ++j) {
                avec3[j] = new Vec3(this.towers[j].m_20185_(), this.towers[j].m_20186_(), this.towers[j].m_20189_());
            }
            double leg0X = 2.0f * cos + -4.0f * sin;
            leg0Z = 2.0f * sin - -4.0f * cos;
            double leg1X = -2.0f * cos + -4.0f * sin;
            double leg1Z = -2.0f * sin - -4.0f * cos;
            double leg2X = -(4.0f * cos);
            double leg2Z = -(4.0f * sin);
            double leg3X = -(-4.0f * cos);
            double leg3Z = -(-4.0f * sin);
            this.tickPart(this.tower0, leg0X, 9.0, leg0Z);
            this.tickPart(this.tower1, leg1X, 9.0, leg1Z);
            this.tickPart(this.tower2, leg2X, 8.0, leg2Z);
            this.tickPart(this.tower3, leg3X, 8.0, leg3Z);
            for (int l = 0; l < this.towers.length; ++l) {
                this.towers[l].f_19854_ = avec3[l].f_82479_;
                this.towers[l].f_19855_ = avec3[l].f_82480_;
                this.towers[l].f_19856_ = avec3[l].f_82481_;
                this.towers[l].f_19790_ = avec3[l].f_82479_;
                this.towers[l].f_19791_ = avec3[l].f_82480_;
                this.towers[l].f_19792_ = avec3[l].f_82481_;
            }
            if (!this.m_20160_()) {
                this.checkTick();
            } else {
                this.towerTick();
            }
        }
    }

    private boolean isValidTarget(Entity target) {
        if (target == null || !target.m_6084_()) {
            return false;
        }
        Vec3 vec32 = target.m_20182_().m_82546_(this.getHeadPos());
        double f5 = -Math.toDegrees(Math.atan2(vec32.f_82480_, Math.sqrt(vec32.f_82479_ * vec32.f_82479_ + vec32.f_82481_ * vec32.f_82481_)));
        double f6 = Math.toDegrees(Math.atan2(vec32.f_82481_, vec32.f_82479_)) - 90.0 - (double)this.m_146908_();
        return f6 <= 45.0 || f6 >= -45.0;
    }

    public static BeamExplosionEntity createExplosion(BlockPos end, LivingEntity entity, Explosion.BlockInteraction interaction) {
        BeamExplosionEntity explosion = new BeamExplosionEntity(entity.m_9236_(), (Entity)entity, null, new ExplosionDamageCalculator(), end.m_123341_(), end.m_123342_(), end.m_123343_(), 4.0f, false, interaction);
        if (ForgeEventFactory.onExplosionStart((Level)entity.m_9236_(), (Explosion)explosion)) {
            return explosion;
        }
        explosion.m_46061_();
        explosion.m_46075_(false);
        return explosion;
    }

    public void applyRadius(float radius, float speedY, Vec3 pos) {
        int i = Mth.m_14167_((float)((float)Math.PI * radius * radius));
        float radius1 = (float)Math.PI / (float)i;
        Random random1 = new Random();
        for (int j = 0; j <= i * 2; ++j) {
            float f1 = Mth.m_14031_((float)((float)j * radius1)) * radius;
            float f2 = Mth.m_14089_((float)((float)j * radius1)) * radius;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)((float)pos.f_82479_ + f2), (double)((float)pos.f_82480_), (double)((float)pos.f_82481_ + f1), (double)0.01f, (double)random1.nextFloat(0.0f, speedY), (double)0.01f);
        }
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public boolean m_5825_() {
        return true;
    }

    public void knockBack(List<Entity> p_31132_, boolean up) {
        double d0 = (this.m_20191_().f_82288_ + this.m_20191_().f_82291_) / 2.0;
        double d1 = (this.m_20191_().f_82290_ + this.m_20191_().f_82293_) / 2.0;
        for (Entity entity : p_31132_) {
            if (!(entity instanceof LivingEntity)) continue;
            this.knockBack((LivingEntity)entity, d0, d1);
        }
    }

    private void knockBack(LivingEntity entity, double d0, double d1) {
        double d2 = entity.m_20185_() - d0;
        double d3 = entity.m_20189_() - d1;
        double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
        entity.m_5997_(d2 / d4 * 16.0, (double)0.2f, d3 / d4 * 16.0);
        entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 2.0f);
        this.m_19970_((LivingEntity)this, (Entity)entity);
    }

    public float getCamInterpolation(float partialTicks) {
        float time = Mth.m_14179_((float)partialTicks, (float)this.interpolationCamTimer0, (float)this.interpolationCamTimer);
        return 1.0f - time / 10.0f;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean m_6069_() {
        return super.m_6069_();
    }

    public Vec3 viewHeadY() {
        return this.m_20171_(this.rotHeadX, this.rotHeadY + this.m_146908_());
    }

    private float lerpRotation(float currentYaw, float targetYaw, float maxTurnSpeed) {
        float deltaYaw = Mth.m_14177_((float)(targetYaw - currentYaw));
        float clampedDelta = Mth.m_14036_((float)deltaYaw, (float)(-maxTurnSpeed), (float)maxTurnSpeed);
        return currentYaw + clampedDelta;
    }

    public List<EntityHitResult> getBeamEntityHitResult(Level p_150176_, Entity p_150177_, Vec3 p_150178_, Vec3 p_150179_, AABB p_150180_, Predicate<Entity> p_150181_, float p_150182_) {
        double d0 = Double.MAX_VALUE;
        ArrayList<EntityHitResult> results = new ArrayList<EntityHitResult>();
        for (Entity entity1 : p_150176_.m_6249_(p_150177_, p_150180_, p_150181_)) {
            AABB aabb = entity1.m_20191_().m_82400_((double)p_150182_);
            Optional optional = aabb.m_82371_(p_150178_, p_150179_);
            if (!optional.isPresent()) continue;
            results.add(new EntityHitResult(entity1));
        }
        return results.isEmpty() ? null : results;
    }

    public InteractionResult m_6071_(Player p_27584_, InteractionHand p_27585_) {
        ItemStack stack = p_27584_.m_21120_(p_27585_);
        if (stack.m_150930_(Items.f_42418_) && this.m_21233_() != this.m_21223_()) {
            if (!this.m_9236_().f_46443_) {
                this.m_5634_(30.0f);
            }
            this.spawParticleHeal();
            if (!p_27584_.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41619_() && p_27584_.m_6144_()) {
            this.setSitting(!this.isSitting());
            if (p_27584_.m_9236_().f_46443_) {
                p_27584_.m_5661_((Component)Component.m_237115_((String)("ray." + (this.isSitting() ? "sitting" : "follow"))), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21805_() != null) {
            ArsenalCapability arsenal;
            if (stack.m_150930_((Item)CVNItems.DEPLOYER.get()) && this.m_21805_().equals(p_27584_.m_20148_()) && !this.m_20197_().contains(this.m_269323_()) && (arsenal = ArsenalCapability.get(p_27584_)) != null && arsenal.rayActive) {
                if (p_27584_.m_9236_().f_46443_) {
                    p_27584_.m_9236_().m_7785_(p_27584_.m_20185_(), p_27584_.m_20186_(), p_27584_.m_20189_(), SoundEvents.f_11738_, SoundSource.HOSTILE, 5.0f, 1.0f, false);
                    p_27584_.m_5661_((Component)Component.m_237115_((String)"ray.save"), true);
                } else {
                    arsenal.saveRay(this, p_27584_);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.m_21805_().equals(p_27584_.m_20148_())) {
                this.doPlayerRide(p_27584_);
            }
        }
        return super.m_6071_(p_27584_, p_27585_);
    }

    public void spawParticleHeal() {
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            double box = this.m_20205_();
            double xp = this.m_20185_() + random.nextDouble(-box, box);
            double yp = this.m_20186_() + random.nextDouble(0.0, this.m_20206_());
            double zp = this.m_20189_() + random.nextDouble(-box, box);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, xp, yp, zp, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        Iterator iterator = this.m_20197_().iterator();
        if (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            return (LivingEntity)entity;
        }
        return null;
    }

    protected void doPlayerRide(Player pPlayer) {
        this.setSitting(false);
        this.setTowerOn(false);
        if (!this.m_9236_().f_46443_) {
            pPlayer.m_146922_(this.m_146908_());
            pPlayer.m_146926_(this.m_146909_());
            pPlayer.m_20329_((Entity)this);
        }
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return false;
    }

    public boolean m_20142_() {
        return super.m_20142_();
    }

    public void m_7023_(Vec3 pTravelVector) {
        LivingEntity livingentity = this.m_6688_();
        if (this.m_6084_()) {
            if (this.m_20160_() && livingentity != null && !this.m_6107_()) {
                if (!this.isLaser()) {
                    this.m_146922_(livingentity.m_146908_());
                    this.f_19859_ = this.m_146908_();
                    this.m_146926_(livingentity.m_146909_() * 0.5f);
                    this.m_19915_(this.m_146908_(), this.m_146909_());
                    this.f_20885_ = this.f_20883_ = this.m_146908_();
                    float f = livingentity.f_20900_ * 0.5f;
                    float f1 = livingentity.f_20902_;
                    if (f1 <= 0.0f) {
                        f1 *= 0.25f;
                    }
                    if (this.m_6109_()) {
                        float f0 = this.m_20069_() ? (float)this.m_21133_(Attributes.f_22279_) / 2.0f : (this.m_20142_() ? (float)this.m_21133_(Attributes.f_22279_) : (float)this.m_21133_(Attributes.f_22279_) / 3.0f);
                        this.m_7910_(f0);
                        if (this.m_20069_()) {
                            double d4;
                            double d3 = livingentity.m_20154_().f_82480_;
                            double d = d4 = d3 < -0.2 ? 0.085 : 0.06;
                            if (f == 0.0f || f1 == 0.0f) {
                                d4 -= d4;
                            }
                            this.m_19920_(this.m_6113_(), livingentity.m_20184_().m_82520_((double)f, (d3 - livingentity.m_20184_().f_82480_) * d4 + (double)(f + f1) * d3, (double)f1));
                            super.m_7023_(this.m_20184_());
                        } else {
                            super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                        }
                    } else if (livingentity instanceof Player) {
                        this.m_20256_(Vec3.f_82478_);
                    }
                } else {
                    this.rotHeadY = Mth.m_14036_((float)(livingentity.m_146908_() - this.m_146908_()), (float)-45.0f, (float)45.0f);
                    this.rotHeadX = livingentity.m_146909_() * 0.5f;
                    if (this.rotHeadY <= -45.0f) {
                        livingentity.m_146922_(-45.0f + this.m_146908_());
                    }
                    if (this.rotHeadY >= 45.0f) {
                        livingentity.m_146922_(45.0f + this.m_146908_());
                    }
                }
                this.m_267651_(false);
                this.m_146872_();
            } else if (this.m_6109_() && this.m_20069_()) {
                this.m_19920_(0.01f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.9));
            } else {
                super.m_7023_(pTravelVector);
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_19956_(Entity pPassenger, Entity.MoveFunction moveFunction) {
        super.m_19956_(pPassenger, moveFunction);
        if (this.m_6688_() == pPassenger) {
            if (pPassenger instanceof Mob) {
                Mob mob = (Mob)pPassenger;
                this.f_20883_ = mob.f_20883_;
            }
            pPassenger.m_146884_(this.getHeadPos());
        }
    }

    public int m_245614_() {
        return this.cooldownJump;
    }

    public boolean m_7306_(Entity p_20356_) {
        for (int j = 0; j < this.getParts().length; ++j) {
            if (this.getParts()[j] != p_20356_) continue;
            return true;
        }
        for (Entity passanger : this.m_20197_()) {
            if (passanger != p_20356_) continue;
            return true;
        }
        return super.m_7306_(p_20356_) || this.m_269323_() != null && this.m_269323_().m_7306_(p_20356_);
    }

    public boolean isLaser() {
        return (Boolean)this.f_19804_.m_135370_(LASER);
    }

    public void setLaser(boolean value) {
        this.laserTimer = value ? 200 : 0;
        this.f_19804_.m_135381_(LASER, (Object)value);
    }

    private void checkTick() {
        this.isShooting = false;
        for (TowerPart<?> part : this.towers) {
            LivingEntity target = this.m_5448_();
            if (target == null || this.f_19797_ % 5 != 0) continue;
            if (!this.m_9236_().f_46443_) {
                BulletEntity arrow = new BulletEntity(this.m_9236_());
                arrow.m_5602_((Entity)this);
                arrow.m_146884_(part.m_20182_());
                arrow.m_6686_(target.m_20185_() - part.m_20185_(), target.m_20186_() - part.m_20186_(), target.m_20189_() - part.m_20189_(), 1.5f, 1.0f);
                this.m_9236_().m_7967_((Entity)arrow);
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)CVNSounds.RAY_TURRET_SHOOT3.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            this.isShooting = true;
        }
    }

    private void towerTick() {
        this.isShooting = true;
        if (this.f_19797_ % 5 == 0 && !this.m_9236_().f_46443_) {
            LivingEntity passanger = this.m_6688_();
            Vec3 view = this.m_20171_(passanger.m_5686_(1.0f) - 7.0f, passanger.m_6080_());
            BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(this.getHeadPos(), this.getHeadPos().m_82549_(view.m_82490_(30.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            for (TowerPart<?> part : this.towers) {
                BlockPos target = result.m_82425_();
                BulletEntity arrow = new BulletEntity(this.m_9236_());
                arrow.m_5602_((Entity)this);
                arrow.m_146884_(part.m_20182_());
                arrow.m_6686_((double)target.m_123341_() - part.m_20185_(), (double)target.m_123342_() - part.m_20186_(), (double)target.m_123343_() - part.m_20189_(), 1.5f, 1.0f);
                this.m_9236_().m_7967_((Entity)arrow);
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)CVNSounds.RAY_TURRET_SHOOT3.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    protected float m_6059_() {
        return super.m_6059_();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    private void tickPart(TowerPart<?> p_31116_, double p_31117_, double p_31118_, double p_31119_) {
        p_31116_.m_6034_(this.m_20185_() + p_31117_, this.m_20186_() + p_31118_, this.m_20189_() + p_31119_);
    }

    public void upEntities(List<LivingEntity> list) {
        for (LivingEntity livingEntity : list) {
            if (this.m_7306_((Entity)livingEntity) || !livingEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 25.0f)) continue;
            double dx = livingEntity.m_20185_() - this.m_20185_();
            double dz = livingEntity.m_20189_() - this.m_20189_();
            double normalize = dx * dx + dz * dz;
            livingEntity.m_5997_(dx / normalize, 1.0, dz / normalize);
        }
    }

    protected void m_267689_(float p_268362_) {
        float f = this.m_20089_() == Pose.STANDING && !this.m_20069_() && this.m_20096_() ? Math.min(p_268362_ * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void m_141965_(ClientboundAddEntityPacket p_218825_) {
        super.m_141965_(p_218825_);
    }

    @org.jetbrains.annotations.Nullable
    public PartEntity<?>[] getParts() {
        return this.parts;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public float getStepHeight() {
        return 3.0f;
    }

    public void clientTick() {
        if (this.m_20069_()) {
            if (this.swimAnimationTimeout <= 0) {
                this.swimAnimationTimeout = 35;
                this.stomp.m_216973_();
                this.meleeAttack.m_216973_();
                this.idle.m_216973_();
                this.inWater.m_216977_(this.f_19797_);
                this.idleAnimationTimeout = 0;
            } else {
                --this.swimAnimationTimeout;
            }
        } else if (this.m_20096_()) {
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = 80;
                this.inWater.m_216973_();
                this.stomp.m_216973_();
                this.meleeAttack.m_216973_();
                this.idle.m_216977_(this.f_19797_);
                this.swimAnimationTimeout = 0;
            } else {
                --this.idleAnimationTimeout;
            }
        } else {
            this.idle.m_216973_();
        }
        if (this.smokeEffectTimer > 0) {
            --this.smokeEffectTimer;
            Vec3 head = this.getHeadPos();
            for (int j = 0; j < 3; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, head.f_82479_, head.f_82480_, head.f_82481_, 0.0, 0.0, 0.0);
            }
        }
        if (this.interpolationCamTimer > 0) {
            --this.interpolationCamTimer;
        }
        if (this.prepareLaserTimer == 12) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CVNSounds.RAY_CHARGE_LASER.get(), SoundSource.NEUTRAL, 10.0f, 1.0f, false);
        }
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20202_() == this && Minecraft.m_91087_().f_91066_.f_92091_.m_90857_()) {
            PacketHandler.sendToServer(new PacketKeySync(2));
        }
        if (!this.m_20096_() && !this.m_20069_()) {
            this.isAir.m_216977_(this.f_19797_);
        } else {
            this.isAir.m_216973_();
        }
        if (this.restoreCracking > 0) {
            --this.restoreCracking;
            if (this.restoreCracking == 0) {
                this.crackingBlock.clear();
            }
        }
        this.tickStep();
    }

    public void serverTick() {
        if (this.f_19797_ % 5 == 0) {
            if (this.positionOld != null && this.positionOld.m_82509_((Position)this.m_20182_(), 0.01)) {
                this.m_6858_(false);
            }
            this.positionOld = this.m_20182_();
        }
        if (this.m_20142_()) {
            this.knockBack(this.m_9236_().m_6249_((Entity)this, this.body.m_20191_().m_82400_((double)0.1f), e -> !this.m_7306_((Entity)e)), false);
        }
    }

    public int getAmount() {
        return (Integer)this.f_19804_.m_135370_(AMOUNT);
    }

    public void setAmount(int amount) {
        this.f_19804_.m_135381_(AMOUNT, (Object)amount);
    }

    public void plusAmount(int i) {
        this.setAmount(this.getAmount() + i);
    }

    public void setOwnerId(UUID uuid) {
        this.f_19804_.m_135381_(OWNER_ID, Optional.ofNullable(uuid));
    }

    private void setIsAttacking(boolean b) {
        this.f_19804_.m_135381_(ATTACKING, (Object)b);
    }

    private boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public boolean towerOn() {
        return (Boolean)this.f_19804_.m_135370_(TOWER_ON);
    }

    private void setTowerOn(boolean b) {
        this.f_19804_.m_135381_(TOWER_ON, (Object)b);
    }

    private void setBladeOn(boolean b) {
        this.f_19804_.m_135381_(BLADE_ON, (Object)b);
    }

    public boolean bladeOn() {
        return (Boolean)this.f_19804_.m_135370_(BLADE_ON);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_ID, Optional.empty());
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(BLADE_ON, (Object)false);
        this.f_19804_.m_135372_(TOWER_ON, (Object)false);
        this.f_19804_.m_135372_(LASER, (Object)false);
        this.f_19804_.m_135372_(AMOUNT, (Object)0);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isSitting() || this.isAttacking() && !this.bladeOn();
    }

    private boolean isOrderedToSit() {
        return this.isSitting();
    }

    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128405_("amount", this.getAmount());
        p_21484_.m_128379_("onBlade", this.bladeOn());
        p_21484_.m_128379_("onTower", this.towerOn());
        if (this.m_21805_() != null) {
            p_21484_.m_128362_("Owner", this.m_21805_());
        }
        p_21484_.m_128379_("sitting", this.isSitting());
        ListTag listtag = new ListTag();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(compoundtag);
                listtag.add((Object)compoundtag);
            }
            p_21484_.m_128365_("Items", (Tag)listtag);
        }
    }

    public void m_7378_(CompoundTag p_21450_) {
        UUID uuid;
        if (this.inventory == null) {
            this.createInventory();
        }
        if (this.inventory != null) {
            ListTag listtag = p_21450_.m_128437_("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                int j = compoundtag.m_128445_("Slot") & 0xFF;
                if (j >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
            }
        }
        super.m_7378_(p_21450_);
        this.setAmount(p_21450_.m_128451_("amount"));
        this.setTowerOn(p_21450_.m_128471_("onTower"));
        this.setBladeOn(p_21450_.m_128471_("onBlade"));
        if (p_21450_.m_128403_("Owner")) {
            uuid = p_21450_.m_128342_("Owner");
        } else {
            String s = p_21450_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setSitting(p_21450_.m_128471_("sitting"));
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.setIsAttacking(true);
            this.idle.m_216973_();
            this.attackTimer = 40;
            this.idleAnimationTimeout = 40;
            this.stomp.m_216977_(this.f_19797_);
        }
        if (p_21375_ == 5) {
            this.setIsAttacking(true);
            this.attackTimer = 35;
            this.idle.m_216973_();
            this.idleAnimationTimeout = 35;
            this.meleeAttack.m_216977_(this.f_19797_);
        } else if (p_21375_ == 8) {
            this.setTowerOn(false);
            this.towerOff.m_216977_(this.f_19797_);
        } else if (p_21375_ == 12) {
            this.setTowerOn(true);
            this.towerOn.m_216977_(this.f_19797_);
        } else if (p_21375_ == 9) {
            this.setBladeOn(false);
            this.bladeOff.m_216977_(this.f_19797_);
        } else if (p_21375_ == 11) {
            this.setBladeOn(true);
            this.bladeOn.m_216977_(this.f_19797_);
        } else if (p_21375_ == 13) {
            this.prepareLaser.m_216977_(this.f_19797_);
            this.prepareLaserTimer = 58;
        } else if (p_21375_ == 14) {
            this.setLaser(true);
        } else if (p_21375_ == 15) {
            if (this.towerOn()) {
                this.towerOn.m_216973_();
                this.towerOff.m_216977_(this.f_19797_);
            } else {
                this.towerOff.m_216973_();
                this.towerOn.m_216977_(this.f_19797_);
            }
            this.setTowerOn(!this.towerOn());
        } else if (p_21375_ == 16) {
            if (this.bladeOn()) {
                this.bladeOn.m_216973_();
                this.bladeOff.m_216977_(this.f_19797_);
            } else {
                this.bladeOff.m_216973_();
                this.bladeOn.m_216977_(this.f_19797_);
            }
            this.setBladeOn(!this.bladeOn());
        } else if (p_21375_ == 17) {
            this.cooldownLaser = 600;
            this.smokeEffectTimer = 100;
            this.interpolationCamTimer = 10;
            this.interpolationCamTimer0 = 10;
            this.setLaser(false);
            this.idleAnimationTimeout = 0;
            this.laser.m_216973_();
            this.laserPosition = null;
        } else if (p_21375_ == 71) {
            this.plusAmount(-3);
            this.tickReload = 10;
            this.cooldownAmount = 200;
        } else if (p_21375_ == 72) {
            this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)CVNSounds.RAY_MISSILE_RELOAD.get(), SoundSource.NEUTRAL, 5.0f, 1.0f, true);
        }
        super.m_7822_(p_21375_);
    }

    public void m_7888_(int p_30591_) {
        if (this.cooldownJump <= 0) {
            if (p_30591_ < 0) {
                p_30591_ = 0;
            }
            this.jumpPendingScale = p_30591_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_30591_ / 90.0f;
            this.cooldownJump = 40;
        }
    }

    public boolean m_7132_() {
        return true;
    }

    public void m_7199_(int p_21695_) {
        this.m_5496_((SoundEvent)CVNSounds.RAY_JUMP.get(), 30.0f, 1.0f);
    }

    public void m_8012_() {
    }

    public double m_262813_() {
        return 5.0;
    }

    @Override
    public void handleKey(int key) {
        if (key == 1) {
            if (this.getAmount() > 0 && this.tickReload <= 0) {
                int i = 0;
                List<LivingEntity> list = new ArrayList();
                BlockHitResult blockEnd = this.m_9236_().m_45547_(new ClipContext(this.getHeadPos(), this.getHeadPos().m_82549_(this.m_20171_(this.m_6688_().m_5686_(1.0f), this.m_6688_().m_6080_()).m_82490_(100.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                EntityHitResult hit = ProjectileUtil.m_150175_((Level)this.m_9236_(), (Entity)this, (Vec3)this.getHeadPos(), (Vec3)this.getHeadPos().m_82549_(this.m_20171_(this.m_6688_().m_5686_(1.0f), this.m_6688_().m_6080_()).m_82490_(100.0)), (AABB)this.m_20191_().m_82400_(100.0), e -> !this.m_7306_((Entity)e), (float)0.5f);
                if (hit != null) {
                    target = hit.m_82443_().m_20182_();
                    list = hit.m_82443_().m_9236_().m_6443_(LivingEntity.class, hit.m_82443_().m_20191_().m_82400_(5.0), e -> !this.m_7306_((Entity)e));
                    list.sort(Comparator.comparingDouble(e -> e.m_20275_(target.f_82479_, target.f_82480_, target.f_82481_)));
                } else if (blockEnd.m_6662_() != HitResult.Type.MISS) {
                    target = blockEnd.m_82425_().m_252807_();
                    list = new ArrayList(this.m_9236_().m_6443_(LivingEntity.class, new AABB(blockEnd.m_82425_()).m_82400_(5.0), e -> !this.m_7306_((Entity)e)));
                    list.sort(Comparator.comparingDouble(e -> e.m_20275_(target.f_82479_, target.f_82480_, target.f_82481_)));
                }
                this.tickReload = 10;
                if (!list.isEmpty()) {
                    this.plusAmount(-3);
                    this.m_9236_().m_7605_((Entity)this, (byte)71);
                    this.cooldownAmount = 200;
                    int k = list.size() > 2 ? 1 : 4 - list.size();
                    for (LivingEntity living : list) {
                        for (int j = 0; j < k; ++j) {
                            this.spawnMissile(living, i);
                            if (i > 2) break;
                            ++i;
                        }
                        if (i <= 2) continue;
                        break;
                    }
                }
            }
        } else if (key == 0) {
            if (!this.m_20069_() && !this.isAttacking() && this.m_20096_()) {
                this.setIsAttacking(true);
                if (this.bladeOn()) {
                    this.attackTimer = 35;
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_7605_((Entity)this, (byte)5);
                    }
                } else {
                    this.attackTimer = 40;
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_7605_((Entity)this, (byte)4);
                    }
                }
            }
        } else if (MGKeybinds.attackKey4.getKey().m_84873_() == key) {
            if (!this.m_20069_() && !this.m_9236_().f_46443_ && this.prepareLaserTimer <= 0 && this.cooldownLaser <= 0) {
                if (this.isLaser()) {
                    this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11937_, SoundSource.NEUTRAL, 2.0f, 1.0f);
                    this.setLaser(false);
                    this.cooldownLaser = 600;
                    this.m_9236_().m_7605_((Entity)this, (byte)17);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)13);
                    this.prepareLaserTimer = 58;
                }
            }
        } else if (MGKeybinds.attackKey3.getKey().m_84873_() == key) {
            if (!this.isAttacking()) {
                if (this.bladeOn()) {
                    this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12311_, SoundSource.NEUTRAL, 2.0f, -2.0f);
                } else {
                    this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12312_, SoundSource.NEUTRAL, 2.0f, -2.0f);
                }
                this.setBladeOn(!this.bladeOn());
                this.m_9236_().m_7605_((Entity)this, (byte)16);
            }
        } else {
            if (this.towerOn()) {
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12311_, SoundSource.NEUTRAL, 2.0f, -2.0f);
            } else {
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12312_, SoundSource.NEUTRAL, 2.0f, -2.0f);
            }
            this.setTowerOn(!this.towerOn());
            this.m_9236_().m_7605_((Entity)this, (byte)15);
        }
    }

    public void spawnMissile(LivingEntity living, int i) {
        MissileEntity missile = new MissileEntity(this.m_9236_(), i + 1);
        missile.m_5602_((Entity)this);
        missile.setTarget(living);
        missile.m_6034_(this.slots[i].m_20185_(), this.slots[i].m_20186_(), this.slots[i].m_20189_());
        missile.calculateRotPosition(missile.m_20183_(), living.m_20183_());
        this.m_9236_().m_7967_((Entity)missile);
        PacketHandler.sendToAllTracking(new PacketMissileTarget(missile.m_19879_(), living.m_19879_(), i + 1), (LivingEntity)this);
    }

    public void m_5757_(Container p_18983_) {
    }

    protected boolean m_6129_() {
        return this.m_20069_();
    }

    public void sinkInFluid(FluidType type) {
        super.sinkInFluid(type);
    }

    public void m_213583_(Player p_217023_) {
        if (!(this.m_9236_().f_46443_ || this.m_20160_() && !this.m_20363_((Entity)p_217023_))) {
            this.openInventory((ServerPlayer)p_217023_, (Container)this.inventory);
        }
    }

    public void openInventory(ServerPlayer player, Container p_9060_) {
        if (player.f_36096_ != player.f_36095_) {
            player.m_6915_();
        }
        player.m_9217_();
        player.f_8906_.m_9829_((Packet)new ClientboundOpenScreenPacket(player.f_8940_, MenuType.f_39962_, (Component)Component.m_237113_((String)"Ray Inventory")));
        player.f_36096_ = ChestMenu.m_39246_((int)player.f_8940_, (Inventory)player.m_150109_(), (Container)p_9060_);
        player.m_143399_(player.f_36096_);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.f_36096_));
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_()) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    @org.jetbrains.annotations.Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_ID)).orElse(null);
    }

    class RayAttackGoal
    extends MeleeAttackGoal {
        public StratAttack currentAttack;
        public int nextTimerStrat;
        public int maxTimerStrat;

        public RayAttackGoal(PathfinderMob p_25552_, double p_25553_, boolean p_25554_) {
            super(p_25552_, p_25553_, p_25554_);
            this.currentAttack = StratAttack.STOMP;
            this.nextTimerStrat = 0;
            this.maxTimerStrat = 0;
        }

        public void m_8056_() {
            super.m_8056_();
            this.currentAttack = StratAttack.STOMP;
            this.maxTimerStrat = 200 + MetalGearRayEntity.this.m_9236_().f_46441_.m_188503_(10) * MetalGearRayEntity.this.m_9236_().f_46441_.m_188503_(5);
        }

        public boolean m_8036_() {
            return !MetalGearRayEntity.this.m_20160_() && super.m_8036_() && MetalGearRayEntity.this.prepareLaserTimer <= 0 && !MetalGearRayEntity.this.m_20160_() && !MetalGearRayEntity.this.isLaser();
        }

        public void m_8037_() {
            StratAttack strat = this.currentAttack;
            if (strat == StratAttack.STOMP) {
                super.m_8037_();
            } else {
                MetalGearRayEntity.this.m_21573_().m_26573_();
            }
            if (!MetalGearRayEntity.this.isAttacking() && this.nextTimerStrat++ > this.maxTimerStrat) {
                this.nextTimerStrat = 0;
                this.maxTimerStrat = 20 + MetalGearRayEntity.this.m_9236_().f_46441_.m_188503_(3) * MetalGearRayEntity.this.m_9236_().f_46441_.m_188503_(3);
                int nextStrat = MetalGearRayEntity.this.cooldownLaser <= 0 && MetalGearRayEntity.this.isValidTarget((Entity)MetalGearRayEntity.this.m_5448_()) ? MetalGearRayEntity.this.f_19796_.m_216339_(0, 1) : 1;
                this.switchStrat(nextStrat);
            }
        }

        public void switchStrat(int idStrat) {
            switch (idStrat) {
                case 0: {
                    this.currentAttack = StratAttack.LASER;
                    MetalGearRayEntity.this.prepareLaserTimer = 58;
                    MetalGearRayEntity.this.m_9236_().m_7605_((Entity)MetalGearRayEntity.this, (byte)13);
                    break;
                }
                case 1: {
                    this.currentAttack = StratAttack.STOMP;
                }
            }
        }

        protected void m_6739_(LivingEntity p_25557_, double p_25558_) {
            double d0 = this.m_6639_(p_25557_) + 10.0;
            if (p_25558_ <= d0 && this.m_25565_() <= 0 && MetalGearRayEntity.this.attackTimer <= 0) {
                this.m_25563_();
            }
        }

        protected void m_25563_() {
            super.m_25563_();
            MetalGearRayEntity.this.setBladeOn(false);
            MetalGearRayEntity.this.setIsAttacking(true);
            MetalGearRayEntity.this.attackTimer = 40;
            if (!MetalGearRayEntity.this.m_9236_().f_46443_) {
                MetalGearRayEntity.this.m_9236_().m_7605_((Entity)MetalGearRayEntity.this, (byte)4);
            }
        }

        static enum StratAttack {
            LASER,
            STOMP;

        }
    }

    static class OwnerHurtTargetMetalGearGoal
    extends TargetGoal {
        private final MetalGearRayEntity tameAnimal;
        private LivingEntity ownerLastHurt;
        private int timestamp;

        public OwnerHurtTargetMetalGearGoal(MetalGearRayEntity p_26114_) {
            super((Mob)p_26114_, false);
            this.tameAnimal = p_26114_;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.tameAnimal.m_21805_() != null) {
                LivingEntity livingentity = this.tameAnimal.m_269323_();
                if (livingentity == null) {
                    return false;
                }
                this.ownerLastHurt = livingentity.m_21214_();
                int i = livingentity.m_21215_();
                return i != this.timestamp && this.m_26150_(this.ownerLastHurt, TargetingConditions.f_26872_);
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.ownerLastHurt);
            LivingEntity livingentity = this.tameAnimal.m_269323_();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21215_();
            }
            super.m_8056_();
        }
    }

    public static class FollowOwnerGoal
    extends Goal {
        private final MetalGearRayEntity tamable;
        private LivingEntity owner;
        private final LevelReader level;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;
        private final boolean canFly;

        public FollowOwnerGoal(MetalGearRayEntity p_25294_) {
            this.tamable = p_25294_;
            this.level = p_25294_.m_9236_();
            this.speedModifier = 2.0;
            this.navigation = p_25294_.m_21573_();
            this.startDistance = 40.0f;
            this.stopDistance = 7.0f;
            this.canFly = false;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(p_25294_.m_21573_() instanceof GroundPathNavigation) && !(p_25294_.m_21573_() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.tamable.m_269323_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            if (this.tamable.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            return !(this.tamable.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
        }

        private boolean unableToMove() {
            return this.tamable.isOrderedToSit() || this.tamable.m_20159_() || this.tamable.m_21523_();
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.tamable.m_21439_(BlockPathTypes.WATER);
            this.tamable.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
            this.tamable.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            this.tamable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tamable.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                if (this.tamable.m_20280_((Entity)this.owner) >= 900.0) {
                    this.teleportToOwner();
                } else {
                    this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
                }
            }
        }

        private void teleportToOwner() {
            BlockPos blockpos = this.owner.m_20183_();
            for (int i = 0; i < 10; ++i) {
                int j = this.randomIntInclusive(-3, 3);
                int k = this.randomIntInclusive(-1, 1);
                int l = this.randomIntInclusive(-3, 3);
                boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
                if (!flag) continue;
                return;
            }
        }

        private boolean maybeTeleportTo(int p_25304_, int p_25305_, int p_25306_) {
            if (Math.abs((double)p_25304_ - this.owner.m_20185_()) < 2.0 && Math.abs((double)p_25306_ - this.owner.m_20189_()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(p_25304_, p_25305_, p_25306_))) {
                return false;
            }
            this.tamable.m_7678_((double)p_25304_ + 0.5, p_25305_, (double)p_25306_ + 0.5, this.tamable.m_146908_(), this.tamable.m_146909_());
            this.navigation.m_26573_();
            return true;
        }

        private boolean canTeleportTo(BlockPos p_25308_) {
            BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)p_25308_.m_122032_());
            if (blockpathtypes != BlockPathTypes.WALKABLE) {
                return false;
            }
            BlockState blockstate = this.level.m_8055_(p_25308_.m_7495_());
            if (!this.canFly && blockstate.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = p_25308_.m_121996_((Vec3i)this.tamable.m_20183_());
            return this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(blockpos));
        }

        private int randomIntInclusive(int p_25301_, int p_25302_) {
            return this.tamable.m_217043_().m_188503_(p_25302_ - p_25301_ + 1) + p_25301_;
        }
    }
}

