/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.metal_gear_ray.common.entity;

import com.TBK.metal_gear_ray.common.entity.BeamExplosionEntity;
import com.TBK.metal_gear_ray.common.register.CVNEntityType;
import com.TBK.metal_gear_ray.common.register.CVNSounds;
import com.TBK.metal_gear_ray.common.register.MGParticles;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;

public class MissileEntity
extends AbstractArrow {
    public int lifeTime = 0;
    public LivingEntity target = null;
    private final IntOpenHashSet ignoredEntities = new IntOpenHashSet();
    private BlockState lastState;
    public double targetX = 0.0;
    public double targetY = 0.0;
    public double targetZ = 0.0;
    public double targetXOld = 0.0;
    public double targetYOld = 0.0;
    public double targetZOld = 0.0;
    public int maxTickAltura = 0;
    public double maxHeight = 0.0;
    public double distanceClient = 0.0;
    public double distanceClientOld = 0.0;
    public int delayTime = 0;
    public int lockTime = 0;

    public MissileEntity(Level p_37249_, int delayTime) {
        super((EntityType)CVNEntityType.MISSILE.get(), p_37249_);
        this.m_20242_(false);
        this.lifeTime = 50;
        this.delayTime = delayTime;
    }

    public MissileEntity(EntityType<MissileEntity> bulletEntityEntityType, Level level) {
        super(bulletEntityEntityType, level);
        this.lifeTime = 50;
    }

    protected boolean m_5603_(Entity p_36743_) {
        return super.m_5603_(p_36743_) && (this.m_19749_() == null || !this.m_19749_().m_7306_(p_36743_));
    }

    public boolean m_271807_() {
        return super.m_271807_();
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        this.targetX = target.m_20185_();
        this.targetY = target.m_20186_();
        this.targetZ = target.m_20189_();
        this.targetXOld = target.m_20185_();
        this.targetYOld = target.m_20186_();
        this.targetZOld = target.m_20189_();
        this.distanceClientOld = this.distanceClient = this.m_20182_().m_82546_(target.m_20182_()).m_82553_();
    }

    protected void m_6532_(HitResult p_37260_) {
        HitResult.Type hitresult$type = p_37260_.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)p_37260_);
        }
        BlockPos end = BlockPos.m_274446_((Position)p_37260_.m_82450_());
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)MGParticles.BEAM_EXPLOSION.get(), (double)(end.m_123341_() + this.f_19796_.m_216339_(-2, 2)), (double)(end.m_123342_() + this.f_19796_.m_216339_(0, 2)), (double)(end.m_123343_() + this.f_19796_.m_216339_(-2, 2)), 0.0, 0.0, 0.0);
            }
            this.m_9236_().m_245747_(this.getTarget().m_20183_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 20.0f, 1.0f, false);
        } else {
            BeamExplosionEntity entity = this.createExplosion(end);
            this.m_9236_().m_6443_(LivingEntity.class, new AABB(end).m_82400_(5.0), e -> !this.m_19749_().m_7306_((Entity)e)).forEach(e -> {
                e.f_19802_ = 0;
                e.m_6469_(this.m_269291_().m_269093_((Explosion)entity), 10.0f);
                e.f_19802_ = 0;
            });
        }
        this.m_146870_();
    }

    public BeamExplosionEntity createExplosion(BlockPos end) {
        BeamExplosionEntity explosion = new BeamExplosionEntity(this.m_9236_(), (Entity)this, null, new ExplosionDamageCalculator(), end.m_123341_(), end.m_123342_(), end.m_123343_(), 4.0f, false, Explosion.BlockInteraction.DESTROY);
        if (ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion)) {
            return explosion;
        }
        explosion.m_46061_();
        explosion.m_46075_(false);
        return explosion;
    }

    public Vec3 calculateJumpVelocity(BlockPos from, BlockPos to) {
        double g = 0.08;
        double dx = (double)to.m_123341_() + 0.5 - ((double)from.m_123341_() + 0.5);
        double dy = to.m_123342_() - from.m_123342_();
        double dz = (double)to.m_123343_() + 0.5 - ((double)from.m_123343_() + 0.5);
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        double vHoriz = 0.6;
        int ticks = 70;
        double vx = dx / (double)ticks;
        double vz = dz / (double)ticks;
        double vy = (dy + 0.5 * g * (double)ticks * (double)ticks) / (double)ticks;
        int tickAltura = Mth.m_14165_((double)(vy / g));
        this.maxHeight = vy * vy / (2.0 * g);
        this.maxTickAltura = tickAltura + this.f_19797_ + Mth.m_14167_((float)((float)tickAltura * 0.25f));
        return new Vec3(vx, vy, vz);
    }

    public Vec3 updateVelocity(Vec3 from, Vec3 to) {
        double dx = to.f_82479_ + 0.5 - (from.f_82479_ + 0.5);
        double dz = to.f_82481_ + 0.5 - (from.f_82481_ + 0.5);
        int ticks = Math.max(1, 70 - this.f_19797_);
        double vx = dx / (double)ticks;
        double vz = dz / (double)ticks;
        return new Vec3(vx, this.m_20184_().f_82480_, vz);
    }

    public void calculateRotPosition(BlockPos from, BlockPos to) {
        double g = 0.08;
        double dx = (double)to.m_123341_() + 0.5 - ((double)from.m_123341_() + 0.5);
        double dy = to.m_123342_() - from.m_123342_();
        double dz = (double)to.m_123343_() + 0.5 - ((double)from.m_123343_() + 0.5);
        int ticks = 70;
        double vx = dx / (double)ticks;
        double vz = dz / (double)ticks;
        double vy = (dy + 0.5 * g * (double)ticks * (double)ticks) / (double)ticks;
        this.updateRot(new Vec3(vx, vy, vz), true);
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void m_8119_() {
        boolean flag = this.m_36797_();
        this.targetXOld = this.targetX;
        this.targetYOld = this.targetY;
        this.targetZOld = this.targetZ;
        this.distanceClientOld = this.distanceClient;
        if (this.getTarget() != null) {
            Vec3 vec31 = this.getTarget().m_20182_();
            this.targetX = vec31.f_82479_;
            this.targetY = vec31.f_82480_;
            this.targetZ = vec31.f_82481_;
            this.distanceClient = vec31.m_82546_(this.m_20182_()).m_82553_();
        }
        if (this.m_9236_().f_46443_ && this.getTarget() != null && this.f_19797_ % 6 == 0) {
            this.m_9236_().m_245747_(this.getTarget().m_20183_(), (SoundEvent)CVNSounds.RAY_MISSILE_LOCK.get(), SoundSource.NEUTRAL, 3.0f, 1.0f, false);
        }
        if (this.delayTime <= 0) {
            VoxelShape voxelshape;
            this.m_6075_();
            if (this.getTarget() != null) {
                start = this.m_20182_();
                Vec3 end = new Vec3(this.targetX, this.targetY, this.targetZ);
                Vec3 velocity = this.updateVelocity(start, end);
                this.m_20256_(velocity);
            }
            Vec3 vec3 = this.m_20184_();
            BlockPos blockpos = this.m_20183_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!(blockstate.m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_())) {
                Vec3 vec31 = this.m_20182_();
                for (AABB aabb : voxelshape.m_83299_()) {
                    if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                    this.f_36703_ = true;
                    break;
                }
            }
            if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_) || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType))) {
                this.m_20095_();
            }
            this.f_36704_ = 0;
            Vec3 vec32 = this.m_20182_();
            Vec3 vec33 = vec32.m_82549_(vec3);
            BlockHitResult hitresult = this.m_9236_().m_45547_(new ClipContext(vec32, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_213877_()) {
                EntityHitResult entityhitresult = this.m_6351_(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_19749_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag) {
                    switch (ForgeEventFactory.onProjectileImpactResult((Projectile)this, (HitResult)hitresult)) {
                        case SKIP_ENTITY: {
                            if (hitresult.m_6662_() != HitResult.Type.ENTITY) {
                                this.m_6532_((HitResult)hitresult);
                                this.f_19812_ = true;
                                break;
                            }
                            this.ignoredEntities.add(entityhitresult.m_82443_().m_19879_());
                            entityhitresult = null;
                            break;
                        }
                        case STOP_AT_CURRENT_NO_DAMAGE: {
                            this.m_146870_();
                            entityhitresult = null;
                            break;
                        }
                        case STOP_AT_CURRENT: {
                            this.m_36767_((byte)0);
                        }
                        case DEFAULT: {
                            this.m_6532_((HitResult)hitresult);
                            this.f_19812_ = true;
                        }
                    }
                }
                if (entityhitresult == null || this.m_36796_() <= 0) break;
                hitresult = null;
            }
            if (this.m_213877_()) {
                return;
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            for (int i = 0; i < 1; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_() - d5, this.m_20186_() - d6, this.m_20189_() - d1, -d5, -d6 + 0.2, -d1);
            }
            if (!this.m_20068_() && !flag) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
            }
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            this.updateRot(vec3, flag);
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
        } else {
            --this.delayTime;
            if (this.delayTime == 0) {
                start = this.m_20183_();
                BlockPos end = this.target.m_20183_();
                Vec3 velocity = this.calculateJumpVelocity((BlockPos)start, end);
                this.m_20256_(velocity);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7605_((Entity)this, (byte)4);
                }
            }
        }
    }

    public void updateRot(Vec3 vec3, boolean flag) {
        if (flag) {
            this.m_146922_((float)(Mth.m_14136_((double)(-vec3.f_82479_), (double)(-vec3.f_82481_)) * 57.2957763671875));
        } else {
            this.m_146922_(this.lerpRotation(this.m_146908_(), (float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875), 5.0f));
        }
        this.m_146926_(this.lerpRotation(this.m_146909_(), (float)(Mth.m_14136_((double)vec3.f_82480_, (double)vec3.m_165924_()) * 57.2957763671875), 5.0f));
    }

    private float lerpRotation(float currentYaw, float targetYaw, float maxTurnSpeed) {
        float deltaYaw = Mth.m_14177_((float)(targetYaw - currentYaw));
        float clampedDelta = Mth.m_14036_((float)deltaYaw, (float)(-maxTurnSpeed), (float)maxTurnSpeed);
        return currentYaw + clampedDelta;
    }

    private void m_36799_() {
        this.f_36703_ = false;
        Vec3 vec3 = this.m_20184_();
        this.m_20256_(vec3.m_82542_((double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f)));
    }

    private boolean m_36798_() {
        return this.f_36703_ && this.m_9236_().m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_144120_;
    }

    protected void m_5790_(EntityHitResult p_37259_) {
        Entity entity = p_37259_.m_82443_();
        if (this.m_19749_() == null || !this.m_19749_().m_7306_(entity)) {
            entity.f_19802_ = 0;
            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this.m_19749_()), 2.0f);
            entity.f_19802_ = 0;
        }
    }

    public void m_7822_(byte p_19882_) {
        if (p_19882_ == 4 && this.target != null) {
            BlockPos start = this.m_20183_();
            BlockPos end = this.target.m_20183_();
            this.calculateJumpVelocity(start, end);
        }
        super.m_7822_(p_19882_);
    }

    protected float m_6882_() {
        return 1.0f;
    }

    protected ItemStack m_7941_() {
        return null;
    }
}

