/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.metal_gear_ray.server;

import com.TBK.metal_gear_ray.common.api.IMecha;
import com.TBK.metal_gear_ray.common.entity.MetalGearRayEntity;
import com.TBK.metal_gear_ray.server.capability.ArsenalCapability;
import com.TBK.metal_gear_ray.server.capability.MGCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="metal_gear_mod")
public class Events {
    @SubscribeEvent
    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            ArsenalCapability oldCap = MGCapability.getEntityCap((Entity)event.getObject(), ArsenalCapability.class);
            if (oldCap == null) {
                ArsenalCapability.ArsenalPlayerProvider prov = new ArsenalCapability.ArsenalPlayerProvider();
                ArsenalCapability cap = (ArsenalCapability)prov.getCapability(MGCapability.ARSENAL_CAPABILITY).orElse(null);
                cap.setPlayer(player);
                event.addCapability(new ResourceLocation("metal_gear_mod", "arsenal_cap"), (ICapabilityProvider)prov);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderHandEvent(RenderHandEvent event) {
        Entity mount;
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20159_() && (mount = Minecraft.m_91087_().f_91074_.m_20202_()) instanceof IMecha) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderPlayer(RenderLivingEvent<?, ?> event) {
        Entity mount;
        if (event.getEntity() instanceof Player && event.getEntity().m_20159_() && (mount = event.getEntity().m_20202_()) instanceof IMecha) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntity().m_20202_() instanceof IMecha) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Pre event) {
        if (Minecraft.m_91087_().f_91074_.m_20202_() instanceof IMecha && event.getOverlay() == VanillaGuiOverlay.MOUNT_HEALTH.type()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Entity entity;
        if (Minecraft.m_91087_().f_91074_ != null && (entity = Minecraft.m_91087_().f_91074_.m_20202_()) instanceof MetalGearRayEntity) {
            MetalGearRayEntity ray = (MetalGearRayEntity)entity;
            event.setPitch(event.getPitch());
            event.setYaw(event.getYaw());
            if (!ray.isLaser() && !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
                Minecraft.m_91087_().f_91063_.m_109153_().m_90568_((double)(-13.0f * ray.getCamInterpolation(Minecraft.m_91087_().getPartialTick())), 0.0, 0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        oldPlayer.reviveCaps();
        oldPlayer.getCapability(MGCapability.ARSENAL_CAPABILITY).ifPresent(oldCap -> newPlayer.getCapability(MGCapability.ARSENAL_CAPABILITY).ifPresent(newCap -> newCap.copyFrom((ArsenalCapability)oldCap)));
        oldPlayer.invalidateCaps();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderEvent(RenderLivingEvent.Pre<?, ?> event) {
        Entity mount;
        if (event.getEntity().m_20159_() && (mount = event.getEntity().m_20202_()) instanceof MetalGearRayEntity) {
            MetalGearRayEntity ray = (MetalGearRayEntity)mount;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void seSalio(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_20159_() && event.getEntity().m_20202_() instanceof IMecha) {
            event.getEntity().m_142098_(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_());
        }
    }
}

