/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.metal_gear_ray.server.capability;

import com.TBK.metal_gear_ray.common.api.IArsenalPlayer;
import com.TBK.metal_gear_ray.common.entity.MetalGearRayEntity;
import com.TBK.metal_gear_ray.common.register.CVNEntityType;
import com.TBK.metal_gear_ray.common.register.MGParticles;
import com.TBK.metal_gear_ray.server.capability.MGCapability;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArsenalCapability
implements IArsenalPlayer {
    public Player player;
    public BlockPos lastPos = null;
    public ResourceKey<Level> lastDimension = Level.f_46428_;
    public boolean rayActive = false;
    public CompoundTag data = new CompoundTag();

    public static ArsenalCapability get(Player player) {
        return MGCapability.getEntityCap((Entity)player, ArsenalCapability.class);
    }

    @Override
    public void setPlayer(Player player) {
        this.player = player;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public boolean rayActive() {
        return this.rayActive;
    }

    public void setRayActive(boolean f) {
        this.rayActive = f;
    }

    public LivingEntity getRay(Level level) {
        LivingEntity ray = null;
        if (this.data.m_128403_("UUID")) {
            UUID uuid = this.data.m_128342_("UUID");
            AABB area = new AABB(this.player.m_20183_()).m_82400_(16.0);
            List list = level.m_6443_(LivingEntity.class, area, e -> e.m_20148_().equals(uuid));
            if (!list.isEmpty() && (ray = (LivingEntity)list.get(0)) != null) {
                return ray;
            }
            if (this.lastPos != null && this.lastDimension != null) {
                if (level.m_46472_() == this.lastDimension) {
                    Entity entity;
                    ChunkPos chunkPos = new ChunkPos(this.lastPos);
                    this.refreshRayLocation(level, chunkPos);
                    AABB area1 = new AABB(this.lastPos).m_82400_(16.0);
                    List list1 = level.m_6443_(LivingEntity.class, area1, e -> e.m_20148_().equals(uuid));
                    if (!list1.isEmpty() && (entity = (Entity)list1.get(0)).m_6084_()) {
                        ray = (LivingEntity)entity;
                    }
                } else {
                    Entity entity;
                    ServerLevel newLevel = level.m_7654_().m_129880_(this.lastDimension);
                    if (newLevel == null) {
                        return null;
                    }
                    ChunkPos chunkPos = new ChunkPos(this.lastPos);
                    this.refreshRayLocation(level, chunkPos);
                    AABB area1 = new AABB(this.lastPos).m_82400_(16.0);
                    List list1 = newLevel.m_6443_(LivingEntity.class, area1, e -> e.m_20148_().equals(uuid));
                    if (!list1.isEmpty() && (entity = (Entity)list1.get(0)).m_6084_()) {
                        ray = (LivingEntity)entity;
                    }
                }
            }
        }
        return ray;
    }

    public void refreshRayLocation(Level level, ChunkPos chunkPos) {
        level.m_7726_().m_7131_(chunkPos.f_45578_, chunkPos.f_45579_);
        level.m_7726_().m_7587_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, true);
    }

    public void checkRayState(Level level) {
        LivingEntity ray = this.getRay(level);
        if (ray == null) {
            this.rayActive = false;
            this.data = new CompoundTag();
        }
    }

    public void rayDie() {
        this.rayActive = false;
        this.data = new CompoundTag();
    }

    @Override
    public void spawnOrCreateRay(Player player, BlockPos pos) {
        boolean isSpawn = false;
        MetalGearRayEntity ray = null;
        if (this.data.m_128441_("isSummoning") && this.data.m_128403_("Owner")) {
            if (player.m_20148_().equals(this.data.m_128342_("Owner")) && (ray = (MetalGearRayEntity)((EntityType)CVNEntityType.RAY.get()).m_20615_(player.m_9236_())) != null) {
                ray.m_20258_(this.data);
                ray.m_146884_(Vec3.m_82512_((Vec3i)pos));
                ray.setOwnerId(player.m_20148_());
                this.data.m_128379_("isSummoning", true);
                this.rayActive = true;
                player.m_9236_().m_7967_((Entity)ray);
                isSpawn = true;
            }
        } else if (!player.m_9236_().f_46443_ && (ray = new MetalGearRayEntity((EntityType<? extends PathfinderMob>)((EntityType)CVNEntityType.RAY.get()), player.m_9236_())) != null) {
            ray.m_6518_((ServerLevelAccessor)player.m_9236_(), player.m_9236_().m_6436_(pos), MobSpawnType.MOB_SUMMONED, null, null);
            ray.setOwnerId(player.m_20148_());
            ray.m_146884_(Vec3.m_82512_((Vec3i)pos));
            player.m_9236_().m_7967_((Entity)ray);
            this.rayActive = true;
            CompoundTag tag = new CompoundTag();
            ray.m_20223_(tag);
            tag.m_128379_("isSummoning", true);
            this.data = tag;
            isSpawn = true;
        }
        Level level = this.player.m_9236_();
        if (level.f_46443_) {
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
            for (int i = 0; i < 6; ++i) {
                level.m_7106_((ParticleOptions)MGParticles.BEAM_EXPLOSION.get(), (double)(pos.m_123341_() + level.f_46441_.m_216339_(-2, 2)), (double)(pos.m_123342_() + level.f_46441_.m_216339_(0, 2)), (double)(pos.m_123343_() + level.f_46441_.m_216339_(-2, 2)), 0.0, 0.0, 0.0);
            }
        } else {
            MetalGearRayEntity.createExplosion(pos, (LivingEntity)this.player, Explosion.BlockInteraction.KEEP);
        }
    }

    public void copyFrom(ArsenalCapability capability) {
        this.rayActive = capability.rayActive;
        this.data = capability.data;
    }

    public void saveRay(MetalGearRayEntity ray, Player player) {
        CompoundTag tag = new CompoundTag();
        ray.m_20223_(tag);
        tag.m_128379_("isSummoning", false);
        this.rayActive = false;
        this.data = tag;
        ray.m_146870_();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("ray_active", this.rayActive);
        tag.m_128365_("ray_data", (Tag)this.data);
        if (this.lastPos != null) {
            tag.m_128365_("lastPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastPos));
        }
        tag.m_128359_("dimension", this.lastDimension.m_135782_().toString());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.rayActive = nbt.m_128471_("ray_active");
        this.data = nbt.m_128469_("ray_data");
        if (nbt.m_128441_("lastPos")) {
            this.lastPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("lastPos"));
        }
        this.lastDimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dimension")));
    }

    public static class ArsenalPlayerProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<IArsenalPlayer> instance = LazyOptional.of(ArsenalCapability::new);

        public <T> @NonNull @NotNull LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return MGCapability.ARSENAL_CAPABILITY.orEmpty(cap, this.instance.cast());
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)((IArsenalPlayer)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((IArsenalPlayer)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
        }
    }
}

