/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.worldshaper.item;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class SpearItem
extends Item {
    private final int maxHoldTicks;
    private final int reloadTicks;
    private final double baseDamage;
    private final double speedMultiplier;
    private final double vehicleBonus;
    private static final ResourceLocation AIM_SPEED_MOD_ID = ResourceLocation.parse((String)"worldshaper:spear_aim_speed");

    public SpearItem(Item.Properties properties, int maxHoldTicks, int reloadTicks, double baseDamage, double speedMultiplier, double vehicleBonus) {
        super(properties);
        this.maxHoldTicks = maxHoldTicks;
        this.reloadTicks = reloadTicks;
        this.baseDamage = baseDamage;
        this.speedMultiplier = speedMultiplier;
        this.vehicleBonus = vehicleBonus;
    }

    public SpearItem(Item.Properties properties, int maxHoldTicks, int reloadTicks) {
        this(properties, maxHoldTicks, reloadTicks, 4.0, 1.4, 1.25);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown(stack)) {
            return InteractionResult.FAIL;
        }
        AttributeInstance move = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (move != null && move.getModifier(AIM_SPEED_MOD_ID) == null) {
            move.addTransientModifier(new AttributeModifier(AIM_SPEED_MOD_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        player.startUsingItem(hand);
        return InteractionResult.CONSUME;
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int remainingUseDuration) {
        LivingEntity target;
        int elapsed;
        if (level.isClientSide) {
            return;
        }
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        if (player.getCooldowns().isOnCooldown(stack)) {
            player.stopUsingItem();
            return;
        }
        AttributeInstance move = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (move != null && move.getModifier(AIM_SPEED_MOD_ID) == null) {
            move.addTransientModifier(new AttributeModifier(AIM_SPEED_MOD_ID, 1.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        if ((elapsed = this.getUseDuration(stack, user) - remainingUseDuration) < 0) {
            elapsed = 0;
        }
        if (elapsed > 0 && (target = SpearItem.findTargetInFront(player, 5.0)) != null && target.isAlive()) {
            boolean moving;
            double speed = this.getMovementSpeed(player);
            float damage = this.computeDamage(speed, player);
            double dist = player.distanceTo((Entity)target);
            boolean inRange = dist <= 4.5;
            boolean bl = moving = speed >= 0.12;
            if (damage > 0.0f && inRange && moving) {
                target.hurt(player.damageSources().playerAttack(player), damage);
                Vec3 dir = player.getViewVector(1.0f);
                double materialSpeedMultiplier = this.speedMultiplier;
                double kb = Math.min(0.3 + this.getMovementSpeed(player) * 0.8 * materialSpeedMultiplier, 0.8);
                target.push(dir.x * kb, 0.08, dir.z * kb);
                EquipmentSlot slot = player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                stack.hurtAndBreak(1, (LivingEntity)player, slot);
                this.removeSpeedModifier(player);
                player.stopUsingItem();
                player.getCooldowns().addCooldown(stack, this.reloadTicks);
            }
        }
    }

    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity user, int timeLeft) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int elapsed = this.getUseDuration(stack, user) - timeLeft;
            if (elapsed >= this.maxHoldTicks) {
                player.getCooldowns().addCooldown(stack, this.reloadTicks);
            }
            this.removeSpeedModifier(player);
        }
        return true;
    }

    public void onStopUsing(ItemStack stack, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player player = (Player)user;
            this.removeSpeedModifier(player);
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown(stack)) {
            return 0;
        }
        return this.maxHoldTicks;
    }

    private void removeSpeedModifier(Player player) {
        AttributeInstance move = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (move != null && move.getModifier(AIM_SPEED_MOD_ID) != null) {
            move.removeModifier(AIM_SPEED_MOD_ID);
        }
    }

    protected static ItemAttributeModifiers createAttackAttributes(double attackDamage, double attackSpeed) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder.build();
    }

    private double getMovementSpeed(Player player) {
        Vec3 v = player.getDeltaMovement();
        double base = v.length();
        if (player.isPassenger() && player.getVehicle() != null) {
            Entity vehicle = player.getVehicle();
            Vec3 vehicleVel = vehicle.getDeltaMovement();
            double vehicleSpeed = vehicleVel.length();
            double vehicleMultiplier = 1.0;
            vehicleMultiplier = vehicle instanceof AbstractHorse ? 1.55 * this.vehicleBonus : (vehicle instanceof Camel ? 1.45 * this.vehicleBonus : (vehicle instanceof AbstractMinecart ? 1.35 * this.vehicleBonus : (vehicle instanceof Boat ? 1.35 * this.vehicleBonus : (vehicle instanceof Phantom ? 2.05 * this.vehicleBonus : 1.35 * this.vehicleBonus))));
            base = Math.max(base, vehicleSpeed * vehicleMultiplier);
        }
        if (player.isPassenger() && base < 0.1) {
            base = 0.325 * this.vehicleBonus;
        }
        return base;
    }

    private float computeDamage(double speed, Player player) {
        double minDamage;
        double speedInBlocksPerSecond = speed * 20.0;
        double damage = (this.baseDamage + speedInBlocksPerSecond * 0.65) * this.speedMultiplier;
        if (player.isPassenger()) {
            damage *= this.vehicleBonus;
        }
        if (damage < (minDamage = this.baseDamage * 0.75) && speed >= 0.12) {
            damage = minDamage;
        }
        return (float)damage;
    }

    private static LivingEntity findTargetInFront(Player player, double range) {
        Vec3 eye = player.getEyePosition(1.0f);
        Vec3 look = player.getViewVector(1.0f);
        Vec3 end = eye.add(look.scale(range));
        AABB box = new AABB(eye, end).inflate(0.5);
        List candidates = player.level().getEntities((Entity)player, box, e -> e instanceof LivingEntity && e != player);
        LivingEntity best = null;
        double bestDot = 0.9;
        for (Entity e2 : candidates) {
            Vec3 to = e2.position().add(0.0, (double)e2.getBbHeight() * 0.5, 0.0).subtract(eye).normalize();
            double dot = to.dot(look);
            if (!(dot > bestDot)) continue;
            bestDot = dot;
            best = (LivingEntity)e2;
        }
        return best;
    }
}

