/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.worldshaper.init;

import net.gospi.worldshaper.potion.ManaRegenerationMobEffect;
import net.gospi.worldshaper.potion.StunningMobEffect;
import net.gospi.worldshaper.procedures.ManaRegenerationPriIstiechieniiEffiektaProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class WorldshaperModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"worldshaper");
    public static final DeferredHolder<MobEffect, MobEffect> STUNNING = REGISTRY.register("stunning", () -> new StunningMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MANA_REGENERATION_EFFECT = REGISTRY.register("mana_regeneration_effect", () -> new ManaRegenerationMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            WorldshaperModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            WorldshaperModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(MANA_REGENERATION_EFFECT)) {
            ManaRegenerationPriIstiechieniiEffiektaProcedure.execute(entity);
        }
    }
}

