/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.worldshaper.procedures;

import net.gospi.worldshaper.init.WorldshaperModParticleTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class DashKeyPushProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.getPersistentData().getBooleanOr("dash", false)) {
            entity.setDeltaMovement(new Vec3(2.0 * entity.getLookAngle().x, 0.25, 2.0 * entity.getLookAngle().z));
            if (DashKeyPushProcedure.getEntityGameType(entity) != GameType.CREATIVE) {
                entity.getPersistentData().putBoolean("dash", false);
                entity.getPersistentData().putDouble("dashRegen", 0.0);
            }
            if (world.getBlockState(BlockPos.containing((double)x, (double)(y - 0.15), (double)z)).getBlock() != Blocks.AIR && world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)((SimpleParticleType)WorldshaperModParticleTypes.SPRINT_DUST.get()), x, y + 0.15, z, 15, 0.15, 0.15, 0.15, 0.1);
            }
        }
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }
}

