/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.worldshaper.recipe.brewing;

import net.gospi.worldshaper.init.WorldshaperModPotions;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;

@EventBusSubscriber
public class PotionOfManaRegenerationBrewingRecipe
implements IBrewingRecipe {
    @SubscribeEvent
    public static void init(RegisterBrewingRecipesEvent event) {
        event.getBuilder().addRecipe((IBrewingRecipe)new PotionOfManaRegenerationBrewingRecipe());
    }

    public boolean isInput(ItemStack input) {
        Item inputItem = input.getItem();
        return (inputItem == Items.POTION || inputItem == Items.SPLASH_POTION || inputItem == Items.LINGERING_POTION) && ((PotionContents)input.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER);
    }

    public boolean isIngredient(ItemStack ingredient) {
        return Ingredient.of((ItemLike)Items.LAPIS_LAZULI).test(ingredient);
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (this.isInput(input) && this.isIngredient(ingredient)) {
            return PotionContents.createItemStack((Item)input.getItem(), WorldshaperModPotions.MANA_REGENERATION_EFFECT);
        }
        return ItemStack.EMPTY;
    }
}

