/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.worldshaper.init;

import net.gospi.worldshaper.entity.GunpowderedArrowProjectileEntity;
import net.gospi.worldshaper.entity.HeadlessHorsemanEntity;
import net.gospi.worldshaper.entity.IronArrowProjectileEntity;
import net.gospi.worldshaper.entity.RimebittenEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class WorldshaperModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"worldshaper");
    public static final DeferredHolder<EntityType<?>, EntityType<IronArrowProjectileEntity>> IRON_ARROW_PROJECTILE = WorldshaperModEntities.register("iron_arrow_projectile", EntityType.Builder.of(IronArrowProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<GunpowderedArrowProjectileEntity>> GUNPOWDERED_ARROW_PROJECTILE = WorldshaperModEntities.register("gunpowdered_arrow_projectile", EntityType.Builder.of(GunpowderedArrowProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<HeadlessHorsemanEntity>> HEADLESS_HORSEMAN = WorldshaperModEntities.register("headless_horseman", EntityType.Builder.of(HeadlessHorsemanEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<RimebittenEntity>> RIMEBITTEN = WorldshaperModEntities.register("rimebitten", EntityType.Builder.of(RimebittenEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(0).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"worldshaper", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        HeadlessHorsemanEntity.init(event);
        RimebittenEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HEADLESS_HORSEMAN.get(), HeadlessHorsemanEntity.createAttributes().build());
        event.put((EntityType)RIMEBITTEN.get(), RimebittenEntity.createAttributes().build());
    }
}

