/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.worldshaper.item;

import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.gospi.worldshaper.procedures.MagicansArmorBonusSetProcedure;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class MagicansItem
extends Item {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(20, Map.of(ArmorType.BOOTS, 2, ArmorType.LEGGINGS, 5, ArmorType.CHESTPLATE, 6, ArmorType.HELMET, 2, ArmorType.BODY, 6), 25, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"worldshaper:equip.magican_armor")), 1.0f, 0.0f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"worldshaper:magicans_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"worldshaper:magicans")));

    private MagicansItem(Item.Properties properties) {
        super(properties);
    }

    public static class Boots
    extends MagicansItem {
        public Boots(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.BOOTS));
        }

        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, tooltipDisplay, componentConsumer, flag);
            componentConsumer.accept((Component)Component.translatable((String)"item.worldshaper.magicans_boots.description_0"));
            componentConsumer.accept((Component)Component.translatable((String)"item.worldshaper.magicans_boots.description_1"));
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }
    }

    public static class Chestplate
    extends MagicansItem {
        public Chestplate(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.CHESTPLATE));
        }

        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, tooltipDisplay, componentConsumer, flag);
            componentConsumer.accept((Component)Component.translatable((String)"item.worldshaper.magicans_chestplate.description_0"));
            componentConsumer.accept((Component)Component.translatable((String)"item.worldshaper.magicans_chestplate.description_1"));
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    MagicansArmorBonusSetProcedure.execute(entity);
                }
            }
        }
    }

    public static class Helmet
    extends MagicansItem {
        public Helmet(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.HELMET));
        }

        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, tooltipDisplay, componentConsumer, flag);
            componentConsumer.accept((Component)Component.translatable((String)"item.worldshaper.magicans_helmet.description_0"));
            componentConsumer.accept((Component)Component.translatable((String)"item.worldshaper.magicans_helmet.description_1"));
        }
    }
}

