/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.worldshaper.network;

import java.util.function.Supplier;
import net.gospi.worldshaper.WorldshaperMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class WorldshaperModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"worldshaper");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        WorldshaperMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(WorldshaperModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(WorldshaperModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        clone.manaBar = original.manaBar;
        clone.opalTotal = original.opalTotal;
        clone.PosY = original.PosY;
        if (!event.isWasDeath()) {
            // empty if block
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"worldshaper", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            TagValueOutput output = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
            message.data.serialize((ValueOutput)output);
            buffer.writeNbt((Tag)output.buildResult());
        }, buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)buffer.registryAccess(), (CompoundTag)buffer.readNbt()));
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess());
                    message.data.serialize((ValueOutput)output);
                    ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess(), (CompoundTag)output.buildResult()));
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements ValueIOSerializable {
        boolean _syncDirty = false;
        public double manaBar = 0.0;
        public double opalTotal = 0.0;
        public double PosY = 0.0;

        public void serialize(ValueOutput output) {
            output.putDouble("manaBar", this.manaBar);
            output.putDouble("opalTotal", this.opalTotal);
            output.putDouble("PosY", this.PosY);
        }

        public void deserialize(ValueInput input) {
            this.manaBar = input.getDoubleOr("manaBar", 0.0);
            this.opalTotal = input.getDoubleOr("opalTotal", 0.0);
            this.PosY = input.getDoubleOr("PosY", 0.0);
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }
}

