/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.worldshaper.procedures;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.gospi.worldshaper.procedures.MyalitedBlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber
public class MyaliteObsidianProcedureProcedure {
    private static final Set<BlockPos> checkedPositions = new HashSet<BlockPos>();
    private static int tickCounter = 0;
    private static final Random random = new Random();
    private static final float REPLACEMENT_CHANCE = 0.3f;

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (++tickCounter % 5 != 0) {
            return;
        }
        int checkRadius = 10;
        int processPerTick = 20;
        level2.players().forEach(player -> {
            BlockPos playerPos = player.blockPosition();
            int processed = 0;
            for (int x = -checkRadius; x <= checkRadius && processed < processPerTick; ++x) {
                for (int y = -checkRadius; y <= checkRadius && processed < processPerTick; ++y) {
                    for (int z = -checkRadius; z <= checkRadius && processed < processPerTick; ++z) {
                        BlockState state;
                        BlockPos checkPos = playerPos.offset(x, y, z);
                        if (!level2.isLoaded(checkPos) || (state = level2.getBlockState(checkPos)).getBlock() != Blocks.OBSIDIAN && state.getBlock() != Blocks.CRYING_OBSIDIAN || checkedPositions.contains(checkPos)) continue;
                        checkedPositions.add(checkPos.immutable());
                        ++processed;
                        level2.getServer().execute(() -> MyaliteObsidianProcedureProcedure.checkAndProcessBlock(level2, checkPos));
                    }
                }
            }
        });
        if (tickCounter > 200) {
            checkedPositions.clear();
            tickCounter = 0;
        }
    }

    private static void checkAndProcessBlock(ServerLevel level, BlockPos pos) {
        if (!level.isLoaded(pos)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        if (MyalitedBlockHelper.isMyalited((LevelAccessor)level, pos)) {
            return;
        }
        boolean hasAdjacentPortal = false;
        for (BlockPos neighborPos : MyaliteObsidianProcedureProcedure.getNeighbors(pos)) {
            if (level.getBlockState(neighborPos).getBlock() != Blocks.NETHER_PORTAL) continue;
            hasAdjacentPortal = true;
            break;
        }
        if (!hasAdjacentPortal) {
            return;
        }
        if (random.nextFloat() > 0.3f) {
            return;
        }
        if (state.getBlock() == Blocks.CRYING_OBSIDIAN) {
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.25, 0.25, 0.25, 0.1);
            MyalitedBlockHelper.removeMyalited((LevelAccessor)level, pos);
            level.destroyBlock(pos, false);
        } else if (state.getBlock() == Blocks.OBSIDIAN) {
            boolean wasMyalited = MyalitedBlockHelper.isMyalited((LevelAccessor)level, pos);
            level.setBlock(pos, Blocks.CRYING_OBSIDIAN.defaultBlockState(), 3);
            if (wasMyalited) {
                MyalitedBlockHelper.setMyalited((LevelAccessor)level, pos, true);
            }
        }
    }

    private static BlockPos[] getNeighbors(BlockPos pos) {
        return new BlockPos[]{pos.east(), pos.west(), pos.above(), pos.below(), pos.north(), pos.south()};
    }
}

