/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.worldshaper.procedures;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;

public class MyalitedBlockHelper {
    private static final Map<String, Set<Long>> myalitedBlocks = new HashMap<String, Set<Long>>();

    private static String getLevelKey(ServerLevel level) {
        return level.dimension().location().toString();
    }

    public static boolean isMyalited(LevelAccessor world, BlockPos pos) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel level = (ServerLevel)world;
        String levelKey = MyalitedBlockHelper.getLevelKey(level);
        Set<Long> blocks = myalitedBlocks.get(levelKey);
        if (blocks == null) {
            return false;
        }
        return blocks.contains(pos.asLong());
    }

    public static void setMyalited(LevelAccessor world, BlockPos pos, boolean value) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        String levelKey = MyalitedBlockHelper.getLevelKey(level);
        Set blocks = myalitedBlocks.computeIfAbsent(levelKey, k -> new HashSet());
        long posLong = pos.asLong();
        if (value) {
            blocks.add(posLong);
        } else {
            blocks.remove(posLong);
            if (blocks.isEmpty()) {
                myalitedBlocks.remove(levelKey);
            }
        }
    }

    public static void removeMyalited(LevelAccessor world, BlockPos pos) {
        MyalitedBlockHelper.setMyalited(world, pos, false);
    }
}

