/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.ability;

import java.util.WeakHashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.ability.TimedAbilitySystem;

@Mod.EventBusSubscriber
public class NightStoveAbilityHandler {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (TimedAbilitySystem.hasAbility(entity, "night_stove")) {
            float reducedDamage = event.getAmount() * 0.75f;
            event.setAmount(reducedDamage);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity attacker;
        LivingEntity livingEntity = attacker = event.getSource().m_7639_() instanceof LivingEntity ? (LivingEntity)event.getSource().m_7639_() : null;
        if (attacker != null && TimedAbilitySystem.hasAbility(attacker, "night_stove")) {
            float increasedDamage = event.getAmount() * 1.25f;
            event.setAmount(increasedDamage);
        }
    }

    @Mod.EventBusSubscriber(modid="goetydelight")
    public static class NightStoveAISystem {
        private static final WeakHashMap<Mob, Boolean> modifiedUndeadMobs = new WeakHashMap();

        @SubscribeEvent
        public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            Mob mob;
            block6: {
                block5: {
                    Entity entity = event.getEntity();
                    if (!(entity instanceof Mob)) break block5;
                    mob = (Mob)entity;
                    if (!event.getLevel().m_5776_()) break block6;
                }
                return;
            }
            if (!(mob instanceof Monster) || mob.m_6095_().m_204039_(Tags.EntityTypes.BOSSES)) {
                return;
            }
            if (modifiedUndeadMobs.containsKey(mob)) {
                return;
            }
            mob.f_21346_.m_25352_(0, (Goal)new NightStoveAITargetGoal(mob));
            modifiedUndeadMobs.put(mob, true);
        }

        public static class NightStoveAITargetGoal
        extends NearestAttackableTargetGoal<Player> {
            private Boolean cachedHasNightStove = null;
            private Player cachedPlayer = null;

            public NightStoveAITargetGoal(Mob mob) {
                super(mob, Player.class, true);
                this.f_26051_ = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(player -> !TimedAbilitySystem.hasAbility(player, "night_stove"));
            }

            public boolean m_8036_() {
                LivingEntity lastAttacker = this.f_26135_.m_21188_();
                if (lastAttacker instanceof Player) {
                    Player player = (Player)lastAttacker;
                    if (this.cachedPlayer != player) {
                        this.cachedHasNightStove = TimedAbilitySystem.hasAbility((LivingEntity)player, "night_stove");
                        this.cachedPlayer = player;
                    }
                    if (this.cachedHasNightStove.booleanValue() && this.f_26135_.f_19797_ - this.f_26135_.m_21213_() < 100) {
                        this.f_26050_ = player;
                        return true;
                    }
                }
                if (this.f_26135_.m_5448_() != null) {
                    LivingEntity currentTarget = this.f_26135_.m_5448_();
                    if (currentTarget instanceof Player) {
                        Player player = (Player)currentTarget;
                        if (this.cachedPlayer != player) {
                            this.cachedHasNightStove = TimedAbilitySystem.hasAbility((LivingEntity)player, "night_stove");
                            this.cachedPlayer = player;
                        }
                        if (this.cachedHasNightStove.booleanValue()) {
                            this.f_26135_.m_6710_(null);
                        }
                    }
                    return false;
                }
                this.m_26073_();
                return this.f_26050_ != null;
            }

            public boolean m_8045_() {
                if (this.f_26050_ == null) {
                    return false;
                }
                if (this.f_26050_ == this.f_26135_.m_21188_()) {
                    return this.f_26135_.f_19797_ - this.f_26135_.m_21213_() < 100;
                }
                if (this.f_26050_ instanceof Player) {
                    Player player = (Player)this.f_26050_;
                    if (this.cachedPlayer != player) {
                        this.cachedHasNightStove = TimedAbilitySystem.hasAbility((LivingEntity)player, "night_stove");
                        this.cachedPlayer = player;
                    }
                    if (this.cachedHasNightStove.booleanValue()) {
                        return false;
                    }
                }
                return super.m_8045_();
            }

            public void m_26070_(LivingEntity target) {
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (this.cachedPlayer != player) {
                        this.cachedHasNightStove = TimedAbilitySystem.hasAbility((LivingEntity)player, "night_stove");
                        this.cachedPlayer = player;
                    }
                    if (this.cachedHasNightStove.booleanValue() && this.f_26135_.m_21188_() != player) {
                        return;
                    }
                }
                super.m_26070_(target);
            }

            public void m_8056_() {
                this.cachedPlayer = null;
                this.cachedHasNightStove = null;
                super.m_8056_();
            }

            public void m_8041_() {
                this.cachedPlayer = null;
                this.cachedHasNightStove = null;
                super.m_8041_();
            }
        }
    }
}

