/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.ability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.v_black_cat.goetydelight.network.NetworkHandler;
import net.v_black_cat.goetydelight.network.SyncAbilityPacket;

@Mod.EventBusSubscriber
public class TimedAbilitySystem {
    public static final Capability<EntityTimedAbilities> ENTITY_TIMED_ABILITIES = CapabilityManager.get((CapabilityToken)new CapabilityToken<EntityTimedAbilities>(){});
    private static final Map<String, AbilityDefinition> ABILITY_REGISTRY = new ConcurrentHashMap<String, AbilityDefinition>();

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(EntityTimedAbilities.class);
    }

    public static void registerAbility(String abilityId, AbilityApplier applier, AbilityRemover remover) {
        ABILITY_REGISTRY.put(abilityId, new AbilityDefinition(applier, remover));
    }

    public static Optional<AbilityDefinition> getAbilityDefinition(String abilityId) {
        return Optional.ofNullable(ABILITY_REGISTRY.get(abilityId));
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        event.getEntity().getCapability(ENTITY_TIMED_ABILITIES).ifPresent(abilities -> abilities.tick(event.getEntity()));
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        event.getEntity().getCapability(ENTITY_TIMED_ABILITIES).ifPresent(abilities -> abilities.clearAbilitiesOnDeath(event.getEntity()));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        event.getEntity().getCapability(ENTITY_TIMED_ABILITIES).ifPresent(abilities -> abilities.clearAbilitiesOnRespawn((LivingEntity)event.getEntity()));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player newEntity = event.getEntity();
        original.reviveCaps();
        original.getCapability(ENTITY_TIMED_ABILITIES).ifPresent(arg_0 -> TimedAbilitySystem.lambda$onPlayerClone$4((LivingEntity)newEntity, arg_0));
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("goetydelight", "timed_abilities"), new ICapabilityProvider(){
                private final LazyOptional<EntityTimedAbilities> instance = LazyOptional.of(EntityTimedAbilities::new);

                public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                    return ENTITY_TIMED_ABILITIES.orEmpty(cap, this.instance.cast());
                }
            });
        }
    }

    public static boolean hasAbility(LivingEntity entity, String abilityId) {
        if (entity.getPersistentData().m_128441_("has" + abilityId.substring(0, 1).toUpperCase() + abilityId.substring(1))) {
            return entity.getPersistentData().m_128471_("has" + abilityId.substring(0, 1).toUpperCase() + abilityId.substring(1));
        }
        LazyOptional capabilities = entity.getCapability(ENTITY_TIMED_ABILITIES);
        if (capabilities.isPresent()) {
            EntityTimedAbilities abilities = (EntityTimedAbilities)capabilities.orElseThrow(IllegalStateException::new);
            return abilities.hasAbility(abilityId);
        }
        return false;
    }

    public static int getAbilityRemainingTime(LivingEntity entity, String abilityId) {
        LazyOptional capabilities = entity.getCapability(ENTITY_TIMED_ABILITIES);
        if (capabilities.isPresent()) {
            EntityTimedAbilities abilities = (EntityTimedAbilities)capabilities.orElseThrow(IllegalStateException::new);
            return abilities.getRemainingTime(abilityId);
        }
        return 0;
    }

    public static LazyOptional<EntityTimedAbilities> getAbilities(LivingEntity entity) {
        return entity.getCapability(ENTITY_TIMED_ABILITIES);
    }

    public static void syncAbilityWithClient(LivingEntity entity, String abilityId, boolean added) {
        if (!entity.m_9236_().f_46443_) {
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new SyncAbilityPacket(entity.m_19879_(), abilityId, added));
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncAbilityPacket(entity.m_19879_(), abilityId, added));
            }
        }
    }

    public static boolean addAbilityToEntity(LivingEntity entity, String abilityId, int durationTicks) {
        LazyOptional capabilities = entity.getCapability(ENTITY_TIMED_ABILITIES);
        if (capabilities.isPresent()) {
            EntityTimedAbilities abilities = (EntityTimedAbilities)capabilities.orElseThrow(IllegalStateException::new);
            Optional<AbilityDefinition> definition = TimedAbilitySystem.getAbilityDefinition(abilityId);
            if (definition.isPresent()) {
                AbilityDefinition def = definition.get();
                abilities.addAbility(abilityId, durationTicks, def.applier, def.remover);
                if (entity instanceof Player) {
                    TimedAbilitySystem.syncAbilityWithClient(entity, abilityId, true);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean removeAbilityFromEntity(LivingEntity entity, String abilityId) {
        LazyOptional capabilities = entity.getCapability(ENTITY_TIMED_ABILITIES);
        if (capabilities.isPresent()) {
            EntityTimedAbilities abilities = (EntityTimedAbilities)capabilities.orElseThrow(IllegalStateException::new);
            abilities.removeAbility(abilityId, entity);
            if (entity instanceof Player) {
                TimedAbilitySystem.syncAbilityWithClient(entity, abilityId, false);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$onPlayerClone$4(LivingEntity newEntity, EntityTimedAbilities oldAbilities) {
        newEntity.getCapability(ENTITY_TIMED_ABILITIES).ifPresent(newAbilities -> {
            CompoundTag nbt = oldAbilities.serializeNBT();
            newAbilities.deserializeNBT(nbt);
        });
    }

    public static class EntityTimedAbilities
    implements ICapabilitySerializable<CompoundTag> {
        private final Map<String, TimedAbility> activeAbilities = new HashMap<String, TimedAbility>();
        private final List<Runnable> pendingRemovals = new ArrayList<Runnable>();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == ENTITY_TIMED_ABILITIES ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
        }

        public void addAbility(String abilityId, int durationTicks, AbilityApplier applier, AbilityRemover remover) {
            TimedAbility ability = new TimedAbility(abilityId, durationTicks, applier, remover);
            this.activeAbilities.put(abilityId, ability);
            applier.apply(null);
        }

        public void removeAbility(String abilityId, LivingEntity entity) {
            TimedAbility ability = this.activeAbilities.get(abilityId);
            if (ability != null) {
                ability.remover.remove(entity);
                this.activeAbilities.remove(abilityId);
                if (entity instanceof Player) {
                    TimedAbilitySystem.syncAbilityWithClient(entity, abilityId, false);
                }
            }
        }

        public boolean hasAbility(String abilityId) {
            return this.activeAbilities.containsKey(abilityId);
        }

        public int getRemainingTime(String abilityId) {
            TimedAbility ability = this.activeAbilities.get(abilityId);
            return ability != null ? ability.remainingTicks : 0;
        }

        public void tick(LivingEntity entity) {
            this.pendingRemovals.clear();
            for (TimedAbility ability : this.activeAbilities.values()) {
                if (ability.remainingTicks == ability.initialDuration) {
                    ability.applier.apply(entity);
                }
                --ability.remainingTicks;
                if (ability.remainingTicks > 0) continue;
                ability.remover.remove(entity);
                this.pendingRemovals.add(() -> this.activeAbilities.remove(ability.abilityId));
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                TimedAbilitySystem.syncAbilityWithClient(entity, ability.abilityId, false);
            }
            this.pendingRemovals.forEach(Runnable::run);
        }

        public void clearAbilitiesOnDeath(LivingEntity entity) {
            for (TimedAbility ability : this.activeAbilities.values()) {
                ability.remover.remove(entity);
                this.pendingRemovals.add(() -> this.activeAbilities.remove(ability.abilityId));
                if (!(entity instanceof Player)) continue;
                TimedAbilitySystem.syncAbilityWithClient(entity, ability.abilityId, false);
            }
            this.pendingRemovals.forEach(Runnable::run);
        }

        public void clearAbilitiesOnRespawn(LivingEntity entity) {
            this.clearAbilitiesOnDeath(entity);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            CompoundTag abilitiesTag = new CompoundTag();
            for (TimedAbility ability : this.activeAbilities.values()) {
                CompoundTag abilityTag = new CompoundTag();
                abilityTag.m_128405_("remainingTicks", ability.remainingTicks);
                abilityTag.m_128405_("initialDuration", ability.initialDuration);
                abilitiesTag.m_128365_(ability.abilityId, (Tag)abilityTag);
            }
            tag.m_128365_("Abilities", (Tag)abilitiesTag);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.activeAbilities.clear();
            if (tag.m_128441_("Abilities")) {
                CompoundTag abilitiesTag = tag.m_128469_("Abilities");
                for (String abilityId : abilitiesTag.m_128431_()) {
                    CompoundTag abilityTag = abilitiesTag.m_128469_(abilityId);
                    int remainingTicks = abilityTag.m_128451_("remainingTicks");
                    int initialDuration = abilityTag.m_128451_("initialDuration");
                    Optional<AbilityDefinition> definition = TimedAbilitySystem.getAbilityDefinition(abilityId);
                    if (!definition.isPresent()) continue;
                    AbilityDefinition def = definition.get();
                    TimedAbility ability = new TimedAbility(abilityId, initialDuration, def.applier, def.remover);
                    ability.remainingTicks = remainingTicks;
                    this.activeAbilities.put(abilityId, ability);
                }
            }
        }
    }

    public static class AbilityDefinition {
        public final AbilityApplier applier;
        public final AbilityRemover remover;

        public AbilityDefinition(AbilityApplier applier, AbilityRemover remover) {
            this.applier = applier;
            this.remover = remover;
        }
    }

    @FunctionalInterface
    public static interface AbilityApplier {
        public void apply(LivingEntity var1);
    }

    @FunctionalInterface
    public static interface AbilityRemover {
        public void remove(LivingEntity var1);
    }

    private static class TimedAbility {
        public final String abilityId;
        public final int initialDuration;
        public int remainingTicks;
        public final AbilityApplier applier;
        public final AbilityRemover remover;

        public TimedAbility(String abilityId, int durationTicks, AbilityApplier applier, AbilityRemover remover) {
            this.abilityId = abilityId;
            this.initialDuration = durationTicks;
            this.remainingTicks = durationTicks;
            this.applier = applier;
            this.remover = remover;
        }
    }
}

