/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.block;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.v_black_cat.goetydelight.block.CursedIngotPotBlock;
import net.v_black_cat.goetydelight.block.NightStoveBlock;
import net.v_black_cat.goetydelight.block.RenderBlock;
import net.v_black_cat.goetydelight.block.RottenCorpseMaggotFeastBlock;
import net.v_black_cat.goetydelight.block.ShadeStoveBlock;
import net.v_black_cat.goetydelight.item.ModItems;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"goetydelight");
    public static final RegistryObject<Block> EXAMPLE_BLOCK = BLOCKS.register("example_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_222994_()));
    public static final RegistryObject<Block> MARBLE = ModBlocks.registerBlock("marble", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_)));
    public static final RegistryObject<Block> SILT_MARBLE_HEAVY = ModBlocks.registerBlock("silt_marble_heavy", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_)));
    public static final RegistryObject<Block> BLUE_MARBLE = ModBlocks.registerBlock("blue_marble", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_)));
    public static final RegistryObject<Block> JUNGLE_MARBLE = ModBlocks.registerBlock("jungle_marble", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_)));
    public static final RegistryObject<Block> NETHER_MARBLE = ModBlocks.registerBlock("nether_marble", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_)));
    public static final RegistryObject<Block> DRIPMARBLE_BLOCK = ModBlocks.registerBlock("dripmarble_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152537_).m_60918_(SoundType.f_154654_).m_60955_()));
    public static final RegistryObject<Block> POINTED_DRIPMARBLE = ModBlocks.registerBlock("pointed_dripmarble", () -> new PointedDripstoneBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283774_).m_280606_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60955_().m_60918_(SoundType.f_154662_).m_60977_().m_60913_(1.5f, 3.0f).m_60988_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY).m_60924_(ModBlocks::never)));
    public static final RegistryObject<Block> MARBLE_STAIRS = ModBlocks.registerBlock("marble_stairs", () -> new StairBlock(() -> ((Block)MARBLE.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_)));
    public static final RegistryObject<Block> MARBLE_SLAB = ModBlocks.registerBlock("marble_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_)));
    public static final RegistryObject<Block> MARBLE_BUTTON = ModBlocks.registerBlock("marble_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50124_).m_60918_(SoundType.f_154654_), BlockSetType.f_271132_, 10, true));
    public static final RegistryObject<Block> MARBLE_PRESSURE_PLATE = ModBlocks.registerBlock("marble_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_), BlockSetType.f_271132_));
    public static final RegistryObject<Block> MARBLE_FENCE = ModBlocks.registerBlock("marble_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_)));
    public static final RegistryObject<Block> MARBLE_FENCE_GATE = ModBlocks.registerBlock("marble_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_), SoundEvents.f_11745_, SoundEvents.f_11664_));
    public static final RegistryObject<Block> MARBLE_WALL = ModBlocks.registerBlock("marble_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_)));
    public static final RegistryObject<Block> MARBLE_DOOR = ModBlocks.registerBlock("marble_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_).m_60955_(), BlockSetType.f_271132_));
    public static final RegistryObject<Block> MARBLE_TRAPDOOR = ModBlocks.registerBlock("marble_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_).m_60955_(), BlockSetType.f_271132_));
    public static final RegistryObject<Block> NIGHT_STOVE = ModBlocks.registerBlock("night_stove", () -> new NightStoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154654_).m_60913_(50.0f, 5000.0f).m_60999_().m_60953_(ModBlocks.litBlockEmission(13))));
    public static final RegistryObject<Block> SHADE_STOVE = ModBlocks.registerBlock("shade_stove", () -> new ShadeStoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(ModBlocks.litBlockEmission(13))));
    public static final RegistryObject<Block> CURSED_INGOT_POT = ModBlocks.registerBlock("cursed_ingot_pot", () -> new CursedIngotPotBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(0.5f, 6.0f).m_60918_(SoundType.f_56762_)));
    public static final RegistryObject<Block> ROTTEN_CORPSE_MAGGOT_FEAST_BLOCK = ModBlocks.registerBlock("rotten_corpse_maggot_feast_block", () -> new RottenCorpseMaggotFeastBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), (Supplier<Item>)ModItems.ROTTEN_CORPSE_MAGGOT_FEAST, true));
    public static final RegistryObject<Block> RENDER_BLOCK = ModBlocks.registerBlock("render_block", () -> new RenderBlock(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60955_().m_222994_().m_60953_(state -> 15)));
    public static final RegistryObject<Block> APOCALYPTIUM_POT = ModBlocks.registerBlock("apocalyptium_pot", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_222994_().m_60918_(SoundType.f_154654_)));

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static boolean never(BlockState p_50806_, BlockGetter p_50807_, BlockPos p_50808_) {
        return false;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

