/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.block;

import com.Polarice3.Goety.api.items.magic.ITotem;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.v_black_cat.goetydelight.block.ModBlockEntities;
import net.v_black_cat.goetydelight.screen.ShadeStoveMenu;

public class ShadeStoveBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int SOUL_ENERGY_COST = 50;
    private static final int BURN_TIME_GAIN = 100;
    private static final float COOKING_SPEED_MULTIPLIER = 1.5f;
    private static final float FUEL_CONSUMPTION_MULTIPLIER = 1.5f;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_FUEL = 1;
    private static final int SLOT_RESULT = 2;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ShadeStoveBlockEntity.this.litTime;
                case 1 -> ShadeStoveBlockEntity.this.litDuration;
                case 2 -> ShadeStoveBlockEntity.this.cookingProgress;
                case 3 -> ShadeStoveBlockEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ShadeStoveBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    ShadeStoveBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    ShadeStoveBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    ShadeStoveBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck;
    private final RecipeType<? extends AbstractCookingRecipe> recipeType = RecipeType.f_44110_;

    public ShadeStoveBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SHADE_STOVE_BE.get(), pPos, pBlockState);
        this.quickCheck = RecipeManager.m_220267_(this.recipeType);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.smoker");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pPlayerInventory) {
        return new ShadeStoveMenu(pContainerId, pPlayerInventory, (Container)this, this.dataAccess);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pIndex) {
        return (ItemStack)this.items.get(pIndex);
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return ContainerHelper.m_18969_(this.items, (int)pIndex, (int)pCount);
    }

    public ItemStack m_8016_(int pIndex) {
        return ContainerHelper.m_18966_(this.items, (int)pIndex);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pIndex);
        boolean flag = !pStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pIndex, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (pIndex == 0 && !flag) {
            this.cookingTotalTime = this.getTotalCookTime();
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        this.litTime = pTag.m_128451_("BurnTime");
        this.cookingProgress = pTag.m_128451_("CookTime");
        this.cookingTotalTime = pTag.m_128451_("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("BurnTime", this.litTime);
        pTag.m_128405_("CookTime", this.cookingProgress);
        pTag.m_128405_("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
    }

    public int[] m_7071_(Direction pSide) {
        if (pSide == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return pSide == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.m_7013_(pIndex, pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        if (pDirection == Direction.DOWN && pIndex == 1) {
            return pStack.m_150930_(Items.f_42447_) || pStack.m_150930_(Items.f_42446_);
        }
        return true;
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        if (pIndex == 2) {
            return false;
        }
        if (pIndex != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.items.get(1);
        return ShadeStoveBlockEntity.isFuel(pStack) || pStack.m_150930_(Items.f_42446_) && !itemstack.m_150930_(Items.f_42446_);
    }

    private boolean consumeSoulEnergy(int amount) {
        int souls;
        ItemStack soulSource = (ItemStack)this.items.get(1);
        if (soulSource.m_41619_()) {
            return false;
        }
        if (this.f_58857_ == null) {
            return false;
        }
        if (soulSource.m_41720_() == ModItems.SOUL_TRANSFER.get() && soulSource.m_41783_() != null && soulSource.m_41783_().m_128441_("owner")) {
            UUID ownerUuid = soulSource.m_41783_().m_128342_("owner");
            Player owner = this.f_58857_.m_46003_(ownerUuid);
            if (owner == null) {
                return false;
            }
            if (!SEHelper.getSEActive((Player)owner) || SEHelper.getSESouls((Player)owner) < amount) {
                return false;
            }
            SEHelper.decreaseSESouls((Player)owner, (int)amount);
            SEHelper.sendSEUpdatePacket((Player)owner);
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos pos = this.m_58899_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 5, 0.2, 0.0, 0.2, 0.05);
            }
            return true;
        }
        if (soulSource.m_41720_() instanceof ITotem && soulSource.m_41783_() != null && soulSource.m_41783_().m_128441_("Souls") && (souls = soulSource.m_41783_().m_128451_("Souls")) >= amount) {
            soulSource.m_41783_().m_128405_("Souls", souls - amount);
            Level serverLevel = this.f_58857_;
            if (serverLevel instanceof ServerLevel) {
                ServerLevel serverLevel2 = (ServerLevel)serverLevel;
                BlockPos pos = this.m_58899_();
                serverLevel2.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 5, 0.2, 0.0, 0.2, 0.05);
            }
            this.items.set(1, (Object)soulSource);
            return true;
        }
        return false;
    }

    public static boolean isFuel(ItemStack pStack) {
        return pStack.m_41720_() instanceof ITotem || pStack.m_41720_() == ModItems.SOUL_TRANSFER.get() || ForgeHooks.getBurnTime((ItemStack)pStack, (RecipeType)RecipeType.f_44110_) > 0;
    }

    protected int getBurnDuration(ItemStack pFuel) {
        if (pFuel.m_41619_()) {
            return 0;
        }
        if (pFuel.m_41720_() instanceof ITotem || pFuel.m_41720_() == ModItems.SOUL_TRANSFER.get()) {
            return 0;
        }
        int baseBurnTime = ForgeHooks.getBurnTime((ItemStack)pFuel, this.recipeType);
        return (int)((float)baseBurnTime / 1.5f);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    private boolean canBurn(@Nullable Recipe<?> pRecipe) {
        if (((ItemStack)this.items.get(0)).m_41619_() || pRecipe == null) {
            return false;
        }
        ItemStack result = pRecipe.m_5874_((Container)this, this.f_58857_.m_9598_());
        if (result.m_41619_()) {
            return false;
        }
        ItemStack currentResult = (ItemStack)this.items.get(2);
        if (currentResult.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41656_((ItemStack)currentResult, (ItemStack)result)) {
            return false;
        }
        return currentResult.m_41613_() + result.m_41613_() <= this.m_6893_() && currentResult.m_41613_() + result.m_41613_() <= currentResult.m_41741_();
    }

    private boolean burn(@Nullable Recipe<?> pRecipe) {
        if (pRecipe != null && this.canBurn(pRecipe)) {
            ItemStack input = (ItemStack)this.items.get(0);
            ItemStack result = pRecipe.m_5874_((Container)this, this.f_58857_.m_9598_());
            ItemStack currentResult = (ItemStack)this.items.get(2);
            if (currentResult.m_41619_()) {
                this.items.set(2, (Object)result.m_41777_());
            } else if (currentResult.m_150930_(result.m_41720_())) {
                currentResult.m_41769_(result.m_41613_());
            }
            if (input.m_150930_(Blocks.f_50057_.m_5456_()) && !((ItemStack)this.items.get(1)).m_41619_() && ((ItemStack)this.items.get(1)).m_150930_(Items.f_42446_)) {
                this.items.set(1, (Object)new ItemStack((ItemLike)Items.f_42447_));
            }
            input.m_41774_(1);
            return true;
        }
        return false;
    }

    private int getTotalCookTime() {
        int baseCookTime = this.quickCheck.m_213657_((Container)this, this.f_58857_).map(AbstractCookingRecipe::m_43753_).orElse(200);
        return (int)((float)baseCookTime / 1.5f);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ShadeStoveBlockEntity blockEntity) {
        boolean hasInput;
        ItemStack fuelStack;
        boolean isLitBefore = blockEntity.isLit();
        boolean changed = false;
        if (blockEntity.isLit()) {
            blockEntity.litTime = Math.max(0, blockEntity.litTime - 1);
        }
        boolean hasFuel = !(fuelStack = (ItemStack)blockEntity.items.get(1)).m_41619_() && ShadeStoveBlockEntity.isFuel(fuelStack);
        boolean bl = hasInput = !((ItemStack)blockEntity.items.get(0)).m_41619_();
        if (blockEntity.isLit() || hasFuel && hasInput) {
            Recipe recipe;
            Recipe recipe2 = recipe = hasInput ? (Recipe)blockEntity.quickCheck.m_213657_((Container)blockEntity, level).orElse(null) : null;
            if (!blockEntity.isLit() && hasInput && blockEntity.consumeSoulEnergy(50)) {
                blockEntity.litDuration = blockEntity.litTime = 66;
                changed = true;
                blockEntity.cookingTotalTime = recipe != null ? blockEntity.getTotalCookTime() : 133;
            } else if (!blockEntity.isLit() && blockEntity.canBurn(recipe)) {
                blockEntity.litDuration = blockEntity.litTime = blockEntity.getBurnDuration(fuelStack);
                if (blockEntity.isLit()) {
                    changed = true;
                    if (fuelStack.hasCraftingRemainingItem()) {
                        blockEntity.items.set(1, (Object)fuelStack.getCraftingRemainingItem());
                    } else if (hasFuel) {
                        fuelStack.m_41774_(1);
                        if (fuelStack.m_41619_()) {
                            blockEntity.items.set(1, (Object)fuelStack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (blockEntity.isLit() && blockEntity.canBurn(recipe)) {
                blockEntity.cookingProgress = (int)((float)blockEntity.cookingProgress + 1.5f);
                if (blockEntity.cookingProgress >= blockEntity.cookingTotalTime) {
                    blockEntity.cookingProgress = 0;
                    blockEntity.cookingTotalTime = blockEntity.getTotalCookTime();
                    if (blockEntity.burn(recipe)) {
                        // empty if block
                    }
                    changed = true;
                }
            } else {
                blockEntity.cookingProgress = 0;
            }
        } else if (!blockEntity.isLit() && blockEntity.cookingProgress > 0) {
            blockEntity.cookingProgress = Mth.m_14045_((int)((int)((float)blockEntity.cookingProgress - 3.0f)), (int)0, (int)blockEntity.cookingTotalTime);
        }
        if (isLitBefore != blockEntity.isLit()) {
            changed = true;
            level.m_7731_(pos, state, 3);
        }
        if (changed) {
            blockEntity.m_6596_();
        }
    }
}

