/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.event;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.block.ModBlocks;
import net.v_black_cat.goetydelight.util.ToolUtils;

@Mod.EventBusSubscriber(modid="goetydelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerLookHandler {
    private static final Supplier<Block> MARBLE_BLOCK_SUPPLIER = ModBlocks.SILT_MARBLE_HEAVY;
    private static final List<Supplier<Block>> MARBLE_BLOCKS = Collections.singletonList(MARBLE_BLOCK_SUPPLIER);
    private static final long COOLDOWN_TICKS = 100L;
    private static long lastSendTime = 0L;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        long currentTime = player.m_9236_().m_46467_();
        ItemStack mainHandItem = player.m_21205_();
        boolean isHoldingPickaxe = ToolUtils.isPickaxe(mainHandItem);
        if (isHoldingPickaxe) {
            Level level = player.m_9236_();
            HitResult hitResult = player.m_19907_(5.0, 0.0f, false);
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                BlockPos pos = blockHitResult.m_82425_();
                Block block = level.m_8055_(pos).m_60734_();
                boolean isMarble = false;
                for (Supplier<Block> marbleBlock : MARBLE_BLOCKS) {
                    Block marbleBlockInstance = marbleBlock.get();
                    if (block != marbleBlockInstance) continue;
                    isMarble = true;
                    break;
                }
                if (isMarble) {
                    PlayerLookHandler.highlightMarbleBlock(level, pos);
                    if (currentTime - lastSendTime > 100L && level.m_5776_()) {
                        player.m_213846_((Component)Component.m_237113_((String)"\ud83d\udca6"));
                        lastSendTime = currentTime;
                    }
                }
            }
        }
    }

    private static void highlightMarbleBlock(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            Direction direction;
            BlockState p_221055_ = level.m_8055_(pos);
            RandomSource p_221058_ = level.f_46441_;
            if (p_221058_.m_188503_(10) == 0 && (direction = Direction.m_235672_((RandomSource)p_221058_)) != Direction.UP) {
                BlockPos blockpos = pos.m_121945_(direction);
                BlockState blockstate = level.m_8055_(blockpos);
                if (!p_221055_.m_60815_() || !blockstate.m_60783_((BlockGetter)level, blockpos, direction.m_122424_())) {
                    double d0 = direction.m_122429_() == 0 ? p_221058_.m_188500_() : 0.5 + (double)direction.m_122429_() * 0.6;
                    double d1 = direction.m_122430_() == 0 ? p_221058_.m_188500_() : 0.5 + (double)direction.m_122430_() * 0.6;
                    double d2 = direction.m_122431_() == 0 ? p_221058_.m_188500_() : 0.5 + (double)direction.m_122431_() * 0.6;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123786_, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, 0.2, 0.2, 0.2);
                }
            }
        }
    }
}

