/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.item.ModItems;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="goetydelight")
public class BoneLordAshRiceItem
extends Item {
    private static final UUID ARMOR_BONUS_UUID = UUID.fromString("a1b2c3d4-5e6f-7a8b-9c0d-1e2f3a4b5c6d");
    private static final UUID ARMOR_TOUGHNESS_BONUS_UUID = UUID.fromString("d4c3b2a1-f6e5-b8a7-d0c9-f2e1b4a3c5d6");
    private static final String BONUS_ACTIVE_TAG = "BoneLordAshRiceActive";
    private static final String ACTIVATION_TIME_TAG = "BoneLordAshRiceActivationTime";
    private static final int DURATION_TICKS = 6000;

    public BoneLordAshRiceItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        ItemStack resultStack = super.m_5922_(stack, level, entity);
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag persistentData = player.getPersistentData();
            if (persistentData.m_128471_(BONUS_ACTIVE_TAG)) {
                this.removeBonusAttributes(player);
            }
            this.addBonusAttributes(player);
            persistentData.m_128379_(BONUS_ACTIVE_TAG, true);
            persistentData.m_128356_(ACTIVATION_TIME_TAG, level.m_46467_());
        }
        return resultStack;
    }

    private void addBonusAttributes(Player player) {
        AttributeInstance toughnessAttribute;
        AttributeInstance armorAttribute = player.m_21051_(Attributes.f_22284_);
        if (armorAttribute != null) {
            AttributeModifier modifier = new AttributeModifier(ARMOR_BONUS_UUID, "Bone Lord Ash Rice Armor Bonus", 15.0, AttributeModifier.Operation.ADDITION);
            armorAttribute.m_22118_(modifier);
        }
        if ((toughnessAttribute = player.m_21051_(Attributes.f_22285_)) != null) {
            AttributeModifier modifier = new AttributeModifier(ARMOR_TOUGHNESS_BONUS_UUID, "Bone Lord Ash Rice Toughness Bonus", 10.0, AttributeModifier.Operation.ADDITION);
            toughnessAttribute.m_22118_(modifier);
        }
    }

    private void removeBonusAttributes(Player player) {
        AttributeInstance toughnessAttribute;
        AttributeInstance armorAttribute = player.m_21051_(Attributes.f_22284_);
        if (armorAttribute != null && armorAttribute.m_22111_(ARMOR_BONUS_UUID) != null) {
            armorAttribute.m_22120_(ARMOR_BONUS_UUID);
        }
        if ((toughnessAttribute = player.m_21051_(Attributes.f_22285_)) != null && toughnessAttribute.m_22111_(ARMOR_TOUGHNESS_BONUS_UUID) != null) {
            toughnessAttribute.m_22120_(ARMOR_TOUGHNESS_BONUS_UUID);
        }
        player.getPersistentData().m_128473_(BONUS_ACTIVE_TAG);
        player.getPersistentData().m_128473_(ACTIVATION_TIME_TAG);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        CompoundTag persistentData;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!level.f_46443_ && (persistentData = player.getPersistentData()).m_128471_(BONUS_ACTIVE_TAG)) {
            long activationTime = persistentData.m_128454_(ACTIVATION_TIME_TAG);
            long currentTime = level.m_46467_();
            if (currentTime - activationTime >= 6000L) {
                BoneLordAshRiceItem item = (BoneLordAshRiceItem)((Object)ModItems.BONE_LORD_ASH_RICE.get());
                item.removeBonusAttributes(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BoneLordAshRiceItem item = (BoneLordAshRiceItem)((Object)ModItems.BONE_LORD_ASH_RICE.get());
            if (player.getPersistentData().m_128471_(BONUS_ACTIVE_TAG)) {
                item.removeBonusAttributes(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        player.getPersistentData().m_128473_(BONUS_ACTIVE_TAG);
        player.getPersistentData().m_128473_(ACTIVATION_TIME_TAG);
    }
}

