/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CakeItem
extends Item {
    private static final double EFFECT_RADIUS = 32.0;
    private static final String REMAINING_USES_TAG = "remaining_uses";
    private static final int MAX_USES = 8;

    public CakeItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        Player player;
        if (entity instanceof Player) {
            player = (Player)entity;
            player.m_36324_().m_38712_((Item)this, stack);
        } else {
            entity.m_5584_(level, stack);
        }
        if (!level.f_46443_ && entity instanceof Player) {
            player = (Player)entity;
            CompoundTag nbt = stack.m_41784_();
            int remainingUses = nbt.m_128451_(REMAINING_USES_TAG);
            if (remainingUses == 0) {
                remainingUses = 8;
            }
            nbt.m_128405_(REMAINING_USES_TAG, --remainingUses);
            AABB effectArea = new AABB(player.m_20182_().m_82492_(32.0, 32.0, 32.0), player.m_20182_().m_82520_(32.0, 32.0, 32.0));
            List nearbyEntities = level.m_45976_(Mob.class, effectArea);
            int kills = 0;
            for (Mob target : nearbyEntities) {
                if (!this.isTargetEntity(target)) continue;
                float maxHealth = target.m_21223_();
                player.m_5634_(maxHealth);
                target.m_6469_(level.m_269111_().m_269425_(), 2.1474836E9f);
                ++kills;
                this.addDeathEffects(level, target);
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12229_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (kills > 0) {
                // empty if block
            }
            if (remainingUses <= 0) {
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
            }
        }
        return stack;
    }

    public boolean m_142522_(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_(REMAINING_USES_TAG)) {
            return nbt.m_128451_(REMAINING_USES_TAG) < 8;
        }
        return false;
    }

    public int m_142158_(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        int remainingUses = nbt.m_128451_(REMAINING_USES_TAG);
        if (remainingUses == 0) {
            remainingUses = 8;
        }
        return Math.round(13.0f * (float)remainingUses / 8.0f);
    }

    public int m_142159_(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        int remainingUses = nbt.m_128451_(REMAINING_USES_TAG);
        if (remainingUses == 0) {
            remainingUses = 8;
        }
        float ratio = (float)remainingUses / 8.0f;
        int r = (int)(255.0f * (1.0f - ratio));
        int g = (int)(255.0f * ratio);
        int b = 0;
        return r << 16 | g << 8 | b;
    }

    private boolean isTargetEntity(Mob entity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return false;
        }
        return entityId.equals((Object)new ResourceLocation("minecraft:vex")) || entityId.equals((Object)new ResourceLocation("minecraft:allay")) || entityId.equals((Object)new ResourceLocation("goety:ally_irk")) || entityId.equals((Object)new ResourceLocation("goety:tormentor")) || entityId.equals((Object)new ResourceLocation("goety:irk"));
    }

    private void addDeathEffects(Level level, Mob target) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 15, 0.5, 0.5, 0.5, 0.05);
            level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 0.8f, 1.0f);
        }
    }
}

