/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.v_black_cat.goetydelight.item.food.RejectedDarkMeatSoupItem;
import net.v_black_cat.goetydelight.network.NetworkHandler;
import net.v_black_cat.goetydelight.network.ThrowSoupPacket;
import net.v_black_cat.goetydelight.util.TimeConverter;

public class EternalRefusalOfBlackMeatSoupItem
extends RejectedDarkMeatSoupItem {
    private static final String COOLDOWN_TAG = "Cooldown";
    private static final String LAST_USED_TAG = "LastUsed";

    public EternalRefusalOfBlackMeatSoupItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isOnCooldown(ItemStack stack, Level level) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(COOLDOWN_TAG) && tag.m_128441_(LAST_USED_TAG)) {
            long lastUsed = tag.m_128454_(LAST_USED_TAG);
            long cooldown = tag.m_128454_(COOLDOWN_TAG);
            return level.m_46467_() - lastUsed < cooldown;
        }
        return false;
    }

    public void setCooldown(ItemStack stack, Level level, long cooldownTicks) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(COOLDOWN_TAG, cooldownTicks);
        tag.m_128356_(LAST_USED_TAG, level.m_46467_());
    }

    public long getRemainingCooldown(ItemStack stack, Level level) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(COOLDOWN_TAG) && tag.m_128441_(LAST_USED_TAG)) {
            long lastUsed = tag.m_128454_(LAST_USED_TAG);
            long cooldown = tag.m_128454_(COOLDOWN_TAG);
            long elapsed = level.m_46467_() - lastUsed;
            return Math.max(0L, cooldown - elapsed);
        }
        return 0L;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isOnCooldown(stack, level)) {
                return stack;
            }
            this.applyConsumeEffects(player);
            this.setCooldown(stack, level, 500L);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        return stack;
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (this.isOnCooldown(stack, player.m_9236_())) {
                return false;
            }
            this.throwPotion(stack, player.m_9236_(), player);
            this.setCooldown(stack, player.m_9236_(), 200L);
            return true;
        }
        return false;
    }

    @Override
    public void throwSoup(ItemStack stack, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (this.isOnCooldown(stack, player.m_9236_())) {
                return;
            }
            this.throwPotion(stack, player.m_9236_(), player);
            this.setCooldown(stack, player.m_9236_(), 200L);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isOnCooldown(stack, world)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    private void applyConsumeEffects(Player player) {
        Random random = new Random();
        int randomAmplifier = Math.min(random.nextInt(6), 5);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, TimeConverter.sToTick(15.0f)));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, TimeConverter.sToTick(15.0f), randomAmplifier));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, TimeConverter.sToTick(15.0f), 1));
    }

    private void throwPotion(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_) {
            ItemStack throwStack = stack.m_41777_();
            throwStack.m_41764_(1);
            int randomAmplifier = Math.min(level.f_46441_.m_188503_(6), 5);
            PotionUtils.m_43552_((ItemStack)throwStack, Arrays.asList(new MobEffectInstance(MobEffects.f_19604_, TimeConverter.sToTick(30.0f)), new MobEffectInstance(MobEffects.f_19614_, TimeConverter.sToTick(30.0f), randomAmplifier), new MobEffectInstance(MobEffects.f_19613_, TimeConverter.sToTick(30.0f), 1)));
            ThrownPotion thrownPotion = new ThrownPotion(level, (LivingEntity)player);
            thrownPotion.m_37446_(throwStack);
            thrownPotion.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, 0.5f, 1.0f);
            level.m_7967_((Entity)thrownPotion);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    public boolean m_142522_(ItemStack stack) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return this.isBarVisibleClient(stack);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isBarVisibleClient(ItemStack stack) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            return this.isOnCooldown(stack, (Level)level);
        }
        return false;
    }

    public int m_142158_(ItemStack stack) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return this.getBarWidthClient(stack);
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getBarWidthClient(ItemStack stack) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            long remaining = this.getRemainingCooldown(stack, (Level)level);
            long total = 1200L;
            return (int)(13.0 * ((double)remaining / (double)total));
        }
        return 0;
    }

    public int m_142159_(ItemStack stack) {
        return 0xFF0000;
    }

    @Mod.EventBusSubscriber(modid="goetydelight", value={Dist.CLIENT})
    public static class PlayerLeftClickHandler {
        @SubscribeEvent
        public static void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
            Player player = event.getEntity();
            ItemStack stack = player.m_21205_();
            Item item = stack.m_41720_();
            if (item instanceof EternalRefusalOfBlackMeatSoupItem) {
                EternalRefusalOfBlackMeatSoupItem soupItem = (EternalRefusalOfBlackMeatSoupItem)item;
                if (soupItem.isOnCooldown(stack, player.m_9236_())) {
                    return;
                }
                NetworkHandler.sendToServer(new ThrowSoupPacket(player.m_20148_()));
                soupItem.setCooldown(stack, player.m_9236_(), 200L);
            } else if (event instanceof PlayerInteractEvent.LeftClickEmpty && stack.m_41720_() instanceof RejectedDarkMeatSoupItem) {
                NetworkHandler.sendToServer(new ThrowSoupPacket(player.m_20148_()));
            }
        }
    }
}

