/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.util.EntityTagChecker;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="goetydelight")
public class OminousIceCreamItem
extends Item {
    public static final String OMINOUS_ACTIVE_TAG = "OminousIceCreamActive";
    public static final String HAS_CONSUMED_TAG = "HasConsumedOminousIceCream";
    private static final WeakHashMap<Mob, Boolean> modifiedMobs = new WeakHashMap();

    public OminousIceCreamItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        Player player;
        ItemStack resultStack = super.m_5922_(stack, level, entity);
        if (!level.f_46443_ && entity instanceof Player && (player = (Player)entity).m_21023_(MobEffects.f_19594_)) {
            player.getPersistentData().m_128379_(OMINOUS_ACTIVE_TAG, true);
            player.getPersistentData().m_128379_(HAS_CONSUMED_TAG, true);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11868_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return resultStack;
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        block6: {
            block5: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Mob)) break block5;
                mob = (Mob)entity;
                if (!event.getLevel().m_5776_()) break block6;
            }
            return;
        }
        if (!EntityTagChecker.isEntityInTag((Entity)mob, "minecraft:raiders") || mob.m_6095_().m_204039_(Tags.EntityTypes.BOSSES)) {
            return;
        }
        if (modifiedMobs.containsKey(mob)) {
            return;
        }
        mob.f_21346_.m_25352_(0, (Goal)new ConditionalPlayerTargetGoal(mob));
        modifiedMobs.put(mob, true);
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        if (effect == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (effect.m_19544_() == MobEffects.f_19594_ && player.getPersistentData().m_128471_(OMINOUS_ACTIVE_TAG)) {
                player.getPersistentData().m_128473_(OMINOUS_ACTIVE_TAG);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 0.5f);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectExpire(MobEffectEvent.Expired event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        if (effect == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (effect.m_19544_() == MobEffects.f_19594_ && player.getPersistentData().m_128471_(OMINOUS_ACTIVE_TAG)) {
                player.getPersistentData().m_128473_(OMINOUS_ACTIVE_TAG);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12563_, SoundSource.PLAYERS, 0.8f, 1.2f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getPersistentData().m_128473_(OMINOUS_ACTIVE_TAG);
            player.getPersistentData().m_128473_(HAS_CONSUMED_TAG);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        player.getPersistentData().m_128473_(OMINOUS_ACTIVE_TAG);
        player.getPersistentData().m_128473_(HAS_CONSUMED_TAG);
    }

    public static class ConditionalPlayerTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        public ConditionalPlayerTargetGoal(Mob mob) {
            super(mob, Player.class, true);
            this.f_26051_ = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(player -> !player.getPersistentData().m_128471_(OminousIceCreamItem.OMINOUS_ACTIVE_TAG));
        }

        public boolean m_8036_() {
            Player player;
            LivingEntity lastAttacker = this.f_26135_.m_21188_();
            if (lastAttacker instanceof Player && (player = (Player)lastAttacker).getPersistentData().m_128471_(OminousIceCreamItem.OMINOUS_ACTIVE_TAG) && this.f_26135_.f_19797_ - this.f_26135_.m_21213_() < 100) {
                this.f_26050_ = player;
                return true;
            }
            if (this.f_26135_.m_5448_() != null) {
                Player player2;
                LivingEntity currentTarget = this.f_26135_.m_5448_();
                if (currentTarget instanceof Player && (player2 = (Player)currentTarget).getPersistentData().m_128471_(OminousIceCreamItem.OMINOUS_ACTIVE_TAG)) {
                    this.f_26135_.m_6710_(null);
                }
                return false;
            }
            this.m_26073_();
            return this.f_26050_ != null;
        }

        public boolean m_8045_() {
            if (this.f_26050_ == null) {
                return false;
            }
            if (this.f_26050_ == this.f_26135_.m_21188_()) {
                return this.f_26135_.f_19797_ - this.f_26135_.m_21213_() < 100;
            }
            return !this.f_26050_.m_213877_() && !this.f_26050_.getPersistentData().m_128471_(OminousIceCreamItem.OMINOUS_ACTIVE_TAG) && super.m_8045_();
        }

        public void m_26070_(@Nullable LivingEntity target) {
            Player player;
            if (target instanceof Player && (player = (Player)target).getPersistentData().m_128471_(OminousIceCreamItem.OMINOUS_ACTIVE_TAG) && this.f_26135_.m_21188_() != player) {
                return;
            }
            super.m_26070_(target);
        }
    }
}

