/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import com.Polarice3.Goety.init.ModAttributes;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.ability.TimedAbilitySystem;

public class RubyHardCandyItem
extends Item {
    private static final int DAMAGE_REDUCTION_DURATION = 12000;
    private static final int MAX_POTENCY_LEVEL = 3;
    private static final String POTENCY_LEVEL_TAG = "RubyCandyPotencyLevel";
    private static final UUID SPELL_POTENCY_UUID = UUID.fromString("8b4513a0-4e2a-11ee-be56-0242ac120004");

    public RubyHardCandyItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            int currentLevel = this.getPotencyLevel(player);
            if (currentLevel < 3) {
                this.increasePotencyLevel(player);
                boolean success = TimedAbilitySystem.addAbilityToEntity(entity, "ruby_hard_candy_damage_reduction", 12000);
                if (success && !player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            } else {
                TimedAbilitySystem.addAbilityToEntity(entity, "ruby_hard_candy_damage_reduction", 12000);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
        }
        return super.m_5922_(stack, level, entity);
    }

    private int getPotencyLevel(Player player) {
        return player.getPersistentData().m_128451_(POTENCY_LEVEL_TAG);
    }

    private void increasePotencyLevel(Player player) {
        int currentLevel = this.getPotencyLevel(player);
        if (currentLevel < 3) {
            player.getPersistentData().m_128405_(POTENCY_LEVEL_TAG, currentLevel + 1);
            this.applyPotencyEffect(player, currentLevel + 1);
        }
    }

    private void applyPotencyEffect(Player player, int level) {
        this.removePotencyEffect(player);
        double potencyBonus = 2 * level;
        AttributeModifier modifier = new AttributeModifier(SPELL_POTENCY_UUID, "Ruby Hard Candy Potency Bonus", potencyBonus, AttributeModifier.Operation.ADDITION);
        if (player.m_21051_((Attribute)ModAttributes.SPELL_POTENCY.get()) != null) {
            player.m_21051_((Attribute)ModAttributes.SPELL_POTENCY.get()).m_22125_(modifier);
        }
        player.getPersistentData().m_128347_("RubyCandyPotencyValue", potencyBonus);
    }

    private void removePotencyEffect(Player player) {
        if (player.m_21051_((Attribute)ModAttributes.SPELL_POTENCY.get()) != null) {
            player.m_21051_((Attribute)ModAttributes.SPELL_POTENCY.get()).m_22120_(SPELL_POTENCY_UUID);
        }
    }

    public static double getCurrentPotencyBonus(Player player) {
        AttributeModifier modifier;
        if (player.m_21051_((Attribute)ModAttributes.SPELL_POTENCY.get()) != null && (modifier = player.m_21051_((Attribute)ModAttributes.SPELL_POTENCY.get()).m_22111_(SPELL_POTENCY_UUID)) != null) {
            return modifier.m_22218_();
        }
        return 0.0;
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        int potencyLevel = player.getPersistentData().m_128451_(POTENCY_LEVEL_TAG);
        if (potencyLevel > 0) {
            double potencyBonus = 10.0 * (double)potencyLevel;
            AttributeModifier modifier = new AttributeModifier(UUID.fromString("8b4513a0-4e2a-11ee-be56-0242ac120004"), "Ruby Hard Candy Potency Bonus", potencyBonus, AttributeModifier.Operation.ADDITION);
            if (player.m_21051_((Attribute)ModAttributes.SPELL_POTENCY.get()) != null) {
                player.m_21051_((Attribute)ModAttributes.SPELL_POTENCY.get()).m_22125_(modifier);
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class DamageReductionHandler {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            LivingEntity entity = event.getEntity();
            if (entity.m_9236_().f_46443_) {
                return;
            }
            boolean hasDamageReduction = TimedAbilitySystem.hasAbility(entity, "ruby_hard_candy_damage_reduction");
            if (hasDamageReduction) {
                float reducedDamage = event.getAmount() * 0.5f;
                event.setAmount(reducedDamage);
            }
        }
    }
}

