/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.ability.TimedAbilitySystem;

public class SugarScepterItem
extends Item {
    private static final int COOLDOWN_TICKS = 400;

    public SugarScepterItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_36335_().m_41519_((Item)this)) {
                return super.m_5922_(stack, level, entity);
            }
            boolean success = TimedAbilitySystem.addAbilityToEntity(entity, "sugar_scepter_immunity", 400);
            if (success) {
                player.m_36335_().m_41524_((Item)this, 400);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
        }
        return super.m_5922_(stack, level, entity);
    }

    @Mod.EventBusSubscriber
    public static class DamageImmunityHandler {
        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            LivingEntity entity = event.getEntity();
            if (entity.m_9236_().f_46443_) {
                return;
            }
            boolean hasImmunity = TimedAbilitySystem.hasAbility(entity, "sugar_scepter_immunity");
            if (hasImmunity) {
                Entity entity2 = event.getSource().m_7639_();
                if (entity2 instanceof LivingEntity) {
                    double dz;
                    LivingEntity attacker = (LivingEntity)entity2;
                    double dx = attacker.m_20185_() - entity.m_20185_();
                    double length = Math.sqrt(dx * dx + (dz = attacker.m_20189_() - entity.m_20189_()) * dz);
                    if (length > 0.0) {
                        dx /= length;
                        dz /= length;
                    }
                    attacker.m_5997_(dx * 5.0, 0.2, dz * 5.0);
                    attacker.f_19864_ = true;
                }
                event.setCanceled(true);
                TimedAbilitySystem.removeAbilityFromEntity(entity, "sugar_scepter_immunity");
                Vec3 pos = entity.m_20182_();
                entity.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12534_, SoundSource.PLAYERS, 8.0f, 1.0f);
            }
        }
    }
}

