/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.item.food;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.item.food.BowlFoodItem;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="goetydelight")
public class ToxicMealItem
extends BowlFoodItem {
    private static final String TOXIC_MEAL_COUNT = "ToxicMealCount";
    private static final int EFFECT_DURATION = 2000;
    private static final int NAUSEA_IMMUNE_THRESHOLD = 5;
    private static final int POISON_IMMUNE_THRESHOLD = 10;
    private static final int WEAKNESS_IMMUNE_THRESHOLD = 15;

    public ToxicMealItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack stack) {
        return 96;
    }

    @Override
    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        ItemStack resultStack = super.m_5922_(stack, level, entity);
        ToxicMealItem.playerEat(level, entity);
        return resultStack;
    }

    private static void playerEat(@NotNull Level level, @NotNull LivingEntity entity) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag persistentData = player.getPersistentData();
            int count = persistentData.m_128451_(TOXIC_MEAL_COUNT);
            persistentData.m_128405_(TOXIC_MEAL_COUNT, ++count);
        }
    }

    private static void otherEntityEat(@NotNull Level level, @NotNull LivingEntity entity) {
        CompoundTag persistentData = entity.getPersistentData();
        int count = persistentData.m_128451_(TOXIC_MEAL_COUNT);
        persistentData.m_128405_(TOXIC_MEAL_COUNT, ++count);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (!player.m_9236_().f_46443_) {
            if (target instanceof Player) {
                ToxicMealItem.playerEat(target.m_9236_(), (LivingEntity)((Player)target));
            } else {
                ToxicMealItem.otherEntityEat(target.m_9236_(), target);
            }
            target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 2000, 0));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 2000, 9));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 2000, 4));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u5df2\u5bf9\u76ee\u6807\u5582\u4e86\u6bd2\u7269\u996d\uff01"), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @SubscribeEvent
    public static void onEffectApplied(MobEffectEvent.Applicable event) {
        boolean immuneWeakness;
        LivingEntity entity = event.getEntity();
        CompoundTag persistentData = entity.getPersistentData();
        MobEffectInstance effect = event.getEffectInstance();
        int toxicMealCount = persistentData.m_128451_(TOXIC_MEAL_COUNT);
        boolean immuneNausea = toxicMealCount >= 5;
        boolean immunePoison = toxicMealCount >= 10;
        boolean bl = immuneWeakness = toxicMealCount >= 15;
        if (effect.m_19544_() == MobEffects.f_19604_ && immuneNausea) {
            event.setResult(Event.Result.DENY);
        } else if (effect.m_19544_() == MobEffects.f_19614_ && immunePoison) {
            event.setResult(Event.Result.DENY);
        } else if (effect.m_19544_() == MobEffects.f_19613_ && immuneWeakness) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag persistentData = player.getPersistentData();
            persistentData.m_128473_(TOXIC_MEAL_COUNT);
        }
    }

    public static int getToxicMealCount(Player player) {
        return player.getPersistentData().m_128451_(TOXIC_MEAL_COUNT);
    }

    public static boolean isImmuneToNausea(Player player) {
        return ToxicMealItem.getToxicMealCount(player) >= 5;
    }

    public static boolean isImmuneToPoison(Player player) {
        return ToxicMealItem.getToxicMealCount(player) >= 10;
    }

    public static boolean isImmuneToWeakness(Player player) {
        return ToxicMealItem.getToxicMealCount(player) >= 15;
    }
}

