/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.v_black_cat.goetydelight.loot.RegHelper;

public class ModLootConditions {

    public static class KilledWithEquipmentCondition
    implements LootItemCondition {
        private final TagKey<Item> requiredEquipment;
        private final EquipmentSlot slot;

        public KilledWithEquipmentCondition(TagKey<Item> requiredEquipment, EquipmentSlot slot) {
            this.requiredEquipment = requiredEquipment;
            this.slot = slot;
        }

        public boolean test(LootContext context) {
            LivingEntity livingKiller;
            Entity killer = (Entity)context.m_78953_(LootContextParams.f_81458_);
            Entity directKiller = (Entity)context.m_78953_(LootContextParams.f_81459_);
            if (directKiller instanceof LivingEntity && this.checkEquipment(livingKiller = (LivingEntity)directKiller)) {
                return true;
            }
            if (killer instanceof LivingEntity) {
                livingKiller = (LivingEntity)killer;
                return this.checkEquipment(livingKiller);
            }
            return false;
        }

        private boolean checkEquipment(LivingEntity entity) {
            ItemStack equipment;
            switch (this.slot) {
                case MAINHAND: {
                    equipment = entity.m_21205_();
                    break;
                }
                case OFFHAND: {
                    equipment = entity.m_21206_();
                    break;
                }
                case HEAD: {
                    equipment = entity.m_6844_(EquipmentSlot.HEAD);
                    break;
                }
                case CHEST: {
                    equipment = entity.m_6844_(EquipmentSlot.CHEST);
                    break;
                }
                case LEGS: {
                    equipment = entity.m_6844_(EquipmentSlot.LEGS);
                    break;
                }
                case FEET: {
                    equipment = entity.m_6844_(EquipmentSlot.FEET);
                    break;
                }
                default: {
                    return false;
                }
            }
            return equipment.m_204117_(this.requiredEquipment);
        }

        public LootItemConditionType m_7940_() {
            return (LootItemConditionType)RegHelper.KILLED_WITH_EQUIPMENT_CONDITION.get();
        }

        public static class Serializer
        implements net.minecraft.world.level.storage.loot.Serializer<KilledWithEquipmentCondition> {
            public void serialize(JsonObject json, KilledWithEquipmentCondition condition, JsonSerializationContext context) {
                json.addProperty("equipment_tag", condition.requiredEquipment.f_203868_().toString());
                json.addProperty("slot", condition.slot.m_20751_());
            }

            public KilledWithEquipmentCondition deserialize(JsonObject json, JsonDeserializationContext context) {
                String tagName = GsonHelper.m_13906_((JsonObject)json, (String)"equipment_tag");
                String slotName = GsonHelper.m_13906_((JsonObject)json, (String)"slot");
                ResourceLocation tagId = new ResourceLocation(tagName);
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
                EquipmentSlot slot = EquipmentSlot.m_20747_((String)slotName);
                return new KilledWithEquipmentCondition((TagKey<Item>)tag, slot);
            }
        }
    }

    public static class EntityTagCondition
    implements LootItemCondition {
        private final TagKey<EntityType<?>> entityTag;

        public EntityTagCondition(TagKey<EntityType<?>> entityTag) {
            this.entityTag = entityTag;
        }

        public boolean test(LootContext context) {
            Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
            return entity != null && entity.m_6095_().m_204039_(this.entityTag);
        }

        public LootItemConditionType m_7940_() {
            return (LootItemConditionType)RegHelper.ENTITY_TAG_CONDITION.get();
        }

        public static class Serializer
        implements net.minecraft.world.level.storage.loot.Serializer<EntityTagCondition> {
            public void serialize(JsonObject json, EntityTagCondition condition, JsonSerializationContext context) {
                json.addProperty("tag", condition.entityTag.f_203868_().toString());
            }

            public EntityTagCondition deserialize(JsonObject json, JsonDeserializationContext context) {
                String tagName = GsonHelper.m_13906_((JsonObject)json, (String)"tag");
                ResourceLocation tagId = new ResourceLocation(tagName);
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagId);
                return new EntityTagCondition(tag);
            }
        }
    }
}

