/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModLootModifier
extends LootModifier {
    private final Item itemToAdd;
    private final float chance;
    private final int minCount;
    private final int maxCount;
    private final float lootingMultiplier;
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLOBAL_LOOT_MODIFIER_CODECS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"goetydelight");
    public static final RegistryObject<Codec<ModLootModifier>> LOOT_MODIFIER_CODEC = GLOBAL_LOOT_MODIFIER_CODECS.register("goetydelight_loot_modifier", () -> RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("itemToAdd").forGetter(m -> m.itemToAdd), (App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance)), (App)Codec.INT.fieldOf("min").forGetter(m -> m.minCount), (App)Codec.INT.fieldOf("max").forGetter(m -> m.maxCount), (App)Codec.FLOAT.optionalFieldOf("looting_multiplier", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.lootingMultiplier)))).apply((Applicative)inst, ModLootModifier::new)));

    public ModLootModifier(LootItemCondition[] conditionsIn, Item itemToAdd, float chance, int minCount, int maxCount, float lootingMultiplier) {
        super(conditionsIn);
        this.itemToAdd = itemToAdd;
        this.chance = chance;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.lootingMultiplier = lootingMultiplier;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)LOOT_MODIFIER_CODEC.get();
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        int randomCount;
        int lootingLevel;
        float finalChance = this.chance;
        if (this.lootingMultiplier > 0.0f && (lootingLevel = context.getLootingModifier()) > 0) {
            finalChance += (float)lootingLevel * this.lootingMultiplier;
        }
        if (context.m_230907_().m_188501_() < finalChance && (randomCount = this.minCount + context.m_230907_().m_188503_(this.maxCount - this.minCount + 1)) > 0) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.itemToAdd, randomCount));
        }
        return generatedLoot;
    }
}

