/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.mixin;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.v_black_cat.goetydelight.item.ModItems;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BrushableBlockEntity.class})
public abstract class BrushableBlockEntityMixin {
    @Shadow
    private ResourceLocation lootTable;
    @Shadow
    private long lootTableSeed;
    @Shadow
    private int brushCount;
    private Player currentBrushingPlayer;

    @Inject(method={"brush"}, at={@At(value="HEAD")})
    private void onBrushStart(long pStartTick, Player pPlayer, Direction pHitDirection, CallbackInfoReturnable<Boolean> cir) {
        this.currentBrushingPlayer = pPlayer;
    }

    @Inject(method={"brush"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrushableBlockEntity;getCompletionState()I", ordinal=0, shift=At.Shift.AFTER)})
    private void beforeCompletionCheck(long pStartTick, Player pPlayer, Direction pHitDirection, CallbackInfoReturnable<Boolean> cir) {
        if (this.currentBrushingPlayer != null) {
            if (this.currentBrushingPlayer.m_21205_().m_41720_() == ModItems.CURSED_METAL_BRUSH.get()) {
                if (this.brushCount == 3) {
                    this.brushCount = 4;
                }
                if (this.brushCount == 6) {
                    this.brushCount = 7;
                }
                if (this.brushCount == 8) {
                    this.brushCount = 10;
                }
            }
            if (this.currentBrushingPlayer.m_21205_().m_41720_() == ModItems.DARK_BRUSH.get() && this.brushCount % 2 == 1 && this.brushCount < 10) {
                ++this.brushCount;
            }
        }
    }

    @Inject(method={"dropContent"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onDropContent(Player player, CallbackInfo ci) {
        BrushableBlockEntity blockEntity = (BrushableBlockEntity)this;
        Level level = blockEntity.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.lootTable != null && this.isUsingCustomBrush(this.currentBrushingPlayer)) {
                LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(this.lootTable);
                LootParams.Builder lootContextBuilder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockEntity.m_58899_())).m_287286_(LootContextParams.f_81455_, (Object)player).m_287239_(player.m_36336_());
                ObjectArrayList extraDrops = lootTable.m_287195_(lootContextBuilder.m_287235_(LootContextParamSets.f_81411_));
                for (ItemStack extraDrop : extraDrops) {
                    BlockPos pos = blockEntity.m_58899_();
                    serverLevel.m_7967_((Entity)new ItemEntity((Level)serverLevel, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, extraDrop));
                }
            }
        }
        this.currentBrushingPlayer = null;
    }

    private boolean isUsingCustomBrush(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offHandItem = player.m_21206_();
        return false;
    }
}

