/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.recipe;

import com.Polarice3.Goety.utils.BrewUtils;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.v_black_cat.goetydelight.item.ModItems;
import net.v_black_cat.goetydelight.item.food.EternalRefusalOfBlackMeatSoupItem;
import net.v_black_cat.goetydelight.recipe.ModRecipeSerializers;
import net.v_black_cat.goetydelight.util.ModBrewUtils;

public class PotionAmplifierRecipe
extends CustomRecipe {
    public PotionAmplifierRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer pContainer, Level pLevel) {
        boolean hasWitchBrew = false;
        boolean hasAmplifier = false;
        ItemStack brewStack = ItemStack.f_41583_;
        ItemStack amplifierStack = ItemStack.f_41583_;
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack stack = pContainer.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == com.Polarice3.Goety.common.items.ModItems.BREW.get()) {
                if (!this.hasNegativeEffects(stack)) continue;
                hasWitchBrew = true;
                brewStack = stack;
                continue;
            }
            if (stack.m_41720_() == ModItems.REJECTED_DARK_MEAT_SOUP.get() || stack.m_41720_() == ModItems.CUP.get()) {
                EternalRefusalOfBlackMeatSoupItem cup;
                if (stack.m_41720_() == ModItems.REJECTED_DARK_MEAT_SOUP.get()) {
                    amplifierStack = stack;
                    hasAmplifier = true;
                    continue;
                }
                Item item = stack.m_41720_();
                if (!(item instanceof EternalRefusalOfBlackMeatSoupItem) || (cup = (EternalRefusalOfBlackMeatSoupItem)item).isOnCooldown(stack, pLevel)) continue;
                amplifierStack = stack;
                hasAmplifier = true;
                continue;
            }
            return false;
        }
        if (hasWitchBrew && hasAmplifier) {
            int maxAmplifications = this.getMaxAmplifications(amplifierStack);
            int currentAmplifications = this.getCurrentAmplifications(brewStack);
            return currentAmplifications < maxAmplifications;
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        ItemStack brewStack = ItemStack.f_41583_;
        ItemStack amplifierStack = ItemStack.f_41583_;
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack stack = pContainer.m_8020_(i);
            if (stack.m_41720_() == com.Polarice3.Goety.common.items.ModItems.BREW.get()) {
                brewStack = stack;
                continue;
            }
            if (stack.m_41720_() != ModItems.REJECTED_DARK_MEAT_SOUP.get() && stack.m_41720_() != ModItems.CUP.get()) continue;
            amplifierStack = stack;
        }
        if (brewStack.m_41619_() || amplifierStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = brewStack.m_41777_();
        result.m_41764_(1);
        int currentAmplifications = this.getCurrentAmplifications(result);
        this.setCurrentAmplifications(result, currentAmplifications + 1);
        ModBrewUtils.increaseNegativeEffects(result, 5);
        if (amplifierStack.m_41720_() instanceof EternalRefusalOfBlackMeatSoupItem) {
            CompoundTag tag = result.m_41784_();
            tag.m_128379_("ReturnCooledSoup", true);
        }
        return result;
    }

    private int getCurrentAmplifications(ItemStack brewStack) {
        CompoundTag tag = brewStack.m_41783_();
        if (tag != null && tag.m_128441_("AmplifiedCount")) {
            return tag.m_128451_("AmplifiedCount");
        }
        return 0;
    }

    private void setCurrentAmplifications(ItemStack brewStack, int count) {
        CompoundTag tag = brewStack.m_41784_();
        tag.m_128405_("AmplifiedCount", count);
    }

    private int getMaxAmplifications(ItemStack amplifierStack) {
        if (amplifierStack.m_41720_() == ModItems.REJECTED_DARK_MEAT_SOUP.get()) {
            return 3;
        }
        if (amplifierStack.m_41720_() == ModItems.CUP.get()) {
            return 5;
        }
        return 0;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.POTION_AMPLIFIER.get();
    }

    private boolean hasNegativeEffects(ItemStack brewStack) {
        boolean hasNegativeMobEffects = PotionUtils.m_43547_((ItemStack)brewStack).stream().anyMatch(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL);
        boolean hasNegativeBrewEffects = false;
        List brewEffects = BrewUtils.getBrewEffects((ItemStack)brewStack);
        if (brewEffects != null) {
            hasNegativeBrewEffects = brewEffects.stream().anyMatch(effect -> effect.getEffect().getCategory() == MobEffectCategory.HARMFUL);
        }
        return hasNegativeMobEffects || hasNegativeBrewEffects;
    }

    public static class Serializer
    implements RecipeSerializer<PotionAmplifierRecipe> {
        public PotionAmplifierRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)pSerializedRecipe, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            return new PotionAmplifierRecipe(pRecipeId, category);
        }

        public PotionAmplifierRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            CraftingBookCategory category = (CraftingBookCategory)pBuffer.m_130066_(CraftingBookCategory.class);
            return new PotionAmplifierRecipe(pRecipeId, category);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PotionAmplifierRecipe pRecipe) {
            pBuffer.m_130068_((Enum)pRecipe.m_245232_());
        }
    }
}

