/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.render.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.v_black_cat.goetydelight.ability.TimedAbilitySystem;
import net.v_black_cat.goetydelight.item.ModItems;
import org.joml.Quaternionf;

public class RotationEffectHandler {
    private static float rotationAngle = 0.0f;
    private static final int ITEM_COUNT = 4;
    private static final double RADIUS = 0.8;
    private static final double HEIGHT_OFFSET = 0.3;

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && (rotationAngle += 1.0f) >= 360.0f) {
            rotationAngle = 0.0f;
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEvent(RenderLivingEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        boolean hasImmunity = event.getEntity().m_9236_().f_46443_ ? event.getEntity().getPersistentData().m_128471_("ClientSide_sugar_scepter_immunity") : TimedAbilitySystem.hasAbility(event.getEntity(), "sugar_scepter_immunity");
        if (!hasImmunity) {
            return;
        }
        float partialTicks = event.getPartialTick();
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, event.getEntity().m_20206_() / 2.0f, 0.0f);
        Quaternionf rotation = Axis.f_252436_.m_252977_(rotationAngle);
        poseStack.m_252781_(rotation);
        for (int i = 0; i < 4; ++i) {
            poseStack.m_85836_();
            double angle = (double)i * 90.0;
            double x = 0.8 * Math.cos(Math.toRadians(angle));
            double z = 0.8 * Math.sin(Math.toRadians(angle));
            poseStack.m_85837_(x, 0.3, z);
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            Quaternionf itemRotation = Axis.f_252436_.m_252977_(-rotationAngle * 8.0f);
            poseStack.m_252781_(itemRotation);
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.WHITE_SHARK_CANDY.get());
            RotationEffectHandler.renderItem(itemStack, poseStack, mc, partialTicks);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private static void renderItem(ItemStack stack, PoseStack poseStack, Minecraft mc, float partialTicks) {
        ItemRenderer itemRenderer = mc.m_91291_();
        BakedModel model = itemRenderer.m_174264_(stack, null, null, 0);
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        itemRenderer.m_115143_(stack, ItemDisplayContext.GROUND, false, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
    }
}

