/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.screen;

import com.Polarice3.Goety.api.items.magic.ITotem;
import com.Polarice3.Goety.common.items.ModItems;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.v_black_cat.goetydelight.block.CursedIngotPotBlockEntity;
import net.v_black_cat.goetydelight.block.ModBlocks;
import net.v_black_cat.goetydelight.screen.CursedPotResultSlot;
import net.v_black_cat.goetydelight.screen.ModMenuTypes;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotMealSlot;
import vectorwing.farmersdelight.common.tag.ModTags;

public class CursedIngotPotMenu
extends RecipeBookMenu<RecipeWrapper> {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BOWL = new ResourceLocation("farmersdelight", "item/empty_container_slot_bowl");
    public final CursedIngotPotBlockEntity blockEntity;
    public final ItemStackHandler inventory;
    private final ContainerData cookingPotData;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public CursedIngotPotMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CursedIngotPotMenu.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public CursedIngotPotMenu(int windowId, Inventory playerInventory, CursedIngotPotBlockEntity blockEntity, ContainerData cookingPotDataIn) {
        super((MenuType)ModMenuTypes.CURSED_INGOT_POT.get(), windowId);
        int col;
        this.blockEntity = blockEntity;
        this.inventory = blockEntity.getInventory();
        this.cookingPotData = cookingPotDataIn;
        this.level = playerInventory.f_35978_.m_9236_();
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        int startX = 8;
        int startY = 18;
        int inputStartX = 30;
        int inputStartY = 17;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (col = 0; col < 3; ++col) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, row * 3 + col, inputStartX + col * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.m_38897_((Slot)new CookingPotMealSlot((IItemHandler)this.inventory, 6, 124, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, 7, 92, 55){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_CONTAINER_SLOT_BOWL);
            }
        });
        this.m_38897_((Slot)new CursedPotResultSlot(playerInventory.f_35978_, blockEntity, (IItemHandler)this.inventory, 8, 124, 55));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, 9, 8, 55){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof ITotem || stack.m_41720_() == ModItems.SOUL_TRANSFER.get();
            }
        });
        int startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                int slotIndex = 9 + col2 + row * 9;
                int xPos = startX + col2 * borderSlotSize;
                int yPos = startPlayerInvY + row * borderSlotSize;
                this.m_38897_(new Slot((Container)playerInventory, slotIndex, xPos, yPos));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, startX + col * borderSlotSize, 142));
        }
        this.m_38884_(cookingPotDataIn);
    }

    private static CursedIngotPotBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof CursedIngotPotBlockEntity) {
            return (CursedIngotPotBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean m_6875_(Player playerIn) {
        return CursedIngotPotMenu.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)ModBlocks.CURSED_INGOT_POT.get()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        int indexMealDisplay = 6;
        int indexContainerInput = 7;
        int indexOutput = 8;
        int indexSoulSource = 9;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack slotStackCopy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            slotStackCopy = slotStack.m_41777_();
            if (index == indexOutput) {
                if (!this.m_38903_(slotStack, startPlayerInv, endPlayerInv, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index <= indexOutput) {
                if (!this.m_38903_(slotStack, startPlayerInv, endPlayerInv, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index == indexSoulSource) {
                if (!this.m_38903_(slotStack, startPlayerInv, endPlayerInv, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                boolean isSoulSource;
                boolean isValidContainer;
                boolean bl = isValidContainer = slotStack.m_204117_(ModTags.SERVING_CONTAINERS) || slotStack.m_150930_(this.blockEntity.getContainer().m_41720_());
                if (isValidContainer && !this.m_38903_(slotStack, indexContainerInput, indexContainerInput + 1, false)) {
                    return ItemStack.f_41583_;
                }
                boolean bl2 = isSoulSource = slotStack.m_41720_() instanceof ITotem || slotStack.m_41720_() == ModItems.SOUL_TRANSFER.get();
                if (isSoulSource && !this.m_38903_(slotStack, indexSoulSource, indexSoulSource + 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(slotStack, 0, indexMealDisplay, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(slotStack, indexContainerInput, indexOutput, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == slotStackCopy.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return slotStackCopy;
    }

    public int getCookProgressionScaled() {
        int i = this.cookingPotData.m_6413_(0);
        int j = this.cookingPotData.m_6413_(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public boolean isHeated() {
        return this.blockEntity.isHeated();
    }

    public void m_5816_(StackedContents helper) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            helper.m_36466_(this.inventory.getStackInSlot(i));
        }
    }

    public void m_6650_() {
        for (int i = 0; i < 6; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public boolean m_6032_(Recipe<? super RecipeWrapper> recipe) {
        return recipe.m_5818_((Container)new RecipeWrapper((IItemHandlerModifiable)this.inventory), this.level);
    }

    public int m_6636_() {
        return 7;
    }

    public int m_6635_() {
        return 3;
    }

    public int m_6656_() {
        return 2;
    }

    public int m_6653_() {
        return 7;
    }

    public RecipeBookType m_5867_() {
        return FarmersDelight.RECIPE_TYPE_COOKING;
    }

    public boolean m_142157_(int slot) {
        return slot < this.m_6635_() * this.m_6656_();
    }
}

