/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.ability;

import com.Polarice3.Goety.utils.ModDamageSource;
import com.mega.revelationfix.common.apollyon.common.ExtraDamageTypes;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.v_black_cat.goetydelight.ability.TimedAbilitySystem;

@Mod.EventBusSubscriber
public class CrimsonMemoriesHandler {
    private static final WeakHashMap<Mob, Boolean> modifiedMobs = new WeakHashMap();

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (TimedAbilitySystem.hasAbility(entity, "crimson_memories") && CrimsonMemoriesHandler.isInNether(entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttack(AttackEntityEvent event) {
        Entity entity;
        Player player = event.getEntity();
        if (player != null && event.getTarget() != null && TimedAbilitySystem.hasAbility((LivingEntity)player, "crimson_memories") && !player.m_9236_().f_46443_ && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            Registry damageTypeRegistry = player.m_9236_().m_9598_().m_175515_(Registries.f_268580_);
            ResourceLocation targetId = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
            if (!(targetId == null || targetId.equals((Object)new ResourceLocation("goety:apostle")) || targetId.equals((Object)new ResourceLocation("goety:heretic")) || targetId.equals((Object)new ResourceLocation("goety:wither_necromancer")) || targetId.equals((Object)new ResourceLocation("goety:maverick")))) {
                if (CrimsonMemoriesHandler.isInNether(target)) {
                    if (ModList.get().isLoaded("goety_revelation")) {
                        DamageSource damageSource = new DamageSource((Holder)damageTypeRegistry.m_246971_(ExtraDamageTypes.QUIETUS));
                        target.m_6469_(damageSource, target.m_21233_() * 10.0f);
                    } else {
                        DamageSource damageSource = new DamageSource((Holder)damageTypeRegistry.m_246971_(ModDamageSource.DOOM));
                        target.m_6469_(damageSource, target.m_21233_() * 10.0f);
                    }
                } else {
                    DamageSource damageSource = new DamageSource((Holder)damageTypeRegistry.m_246971_(ModDamageSource.DOOM));
                    target.m_6469_(damageSource, target.m_21233_() * 10.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        block6: {
            block5: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Mob)) break block5;
                mob = (Mob)entity;
                if (!event.getLevel().m_5776_()) break block6;
            }
            return;
        }
        if (!CrimsonMemoriesHandler.isInNether((LivingEntity)mob)) {
            return;
        }
        if (modifiedMobs.containsKey(mob)) {
            return;
        }
        mob.f_21346_.m_25352_(0, new AvoidCrimsonMemoriesGoal<Player>(mob, Player.class, true));
        modifiedMobs.put(mob, true);
    }

    private static boolean isInNether(LivingEntity entity) {
        return entity.m_9236_().m_46472_() == Level.f_46429_;
    }

    public static class AvoidCrimsonMemoriesGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AvoidCrimsonMemoriesGoal(Mob mob, Class<T> targetType, boolean mustSee) {
            super(mob, targetType, 10, mustSee, false, AvoidCrimsonMemoriesGoal.createTargetPredicate());
        }

        private static Predicate<LivingEntity> createTargetPredicate() {
            return potentialTarget -> {
                if (potentialTarget instanceof Player) {
                    Player player = (Player)potentialTarget;
                    return !TimedAbilitySystem.hasAbility((LivingEntity)player, "crimson_memories");
                }
                return true;
            };
        }
    }
}

