/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.ability;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.v_black_cat.goetydelight.ability.TimedAbilitySystem;

@Mod.EventBusSubscriber(modid="goetydelight")
public class NightStoveAbilityHandler {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (TimedAbilitySystem.hasAbility(entity, "night_stove")) {
            float reducedDamage = event.getAmount() * 0.75f;
            event.setAmount(reducedDamage);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity attacker;
        LivingEntity livingEntity = attacker = event.getSource().m_7639_() instanceof LivingEntity ? (LivingEntity)event.getSource().m_7639_() : null;
        if (attacker != null && TimedAbilitySystem.hasAbility(attacker, "night_stove")) {
            float increasedDamage = event.getAmount() * 1.25f;
            event.setAmount(increasedDamage);
        }
    }

    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity attacker = event.getEntity();
        LivingEntity target = event.getNewTarget();
        if (!(attacker instanceof Mob) || !(target instanceof Player)) {
            return;
        }
        Mob mob = (Mob)attacker;
        Player player = (Player)target;
        if (!(mob instanceof Monster) || mob.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) || mob instanceof NeutralMob || mob.m_6336_() != MobType.f_21641_) {
            return;
        }
        if (TimedAbilitySystem.hasAbility((LivingEntity)player, "night_stove") && mob.m_21188_() != player) {
            if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                event.setNewTarget(null);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Mob mob;
            LivingEntity attacker;
            Player player = (Player)livingEntity;
            LivingEntity livingEntity2 = attacker = event.getSource().m_7639_() instanceof LivingEntity ? (LivingEntity)event.getSource().m_7639_() : null;
            if (attacker instanceof Mob && (mob = (Mob)attacker).m_6336_() == MobType.f_21641_ && !(mob instanceof NeutralMob) && !mob.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) && TimedAbilitySystem.hasAbility((LivingEntity)player, "night_stove") && mob.m_21188_() != player) {
                event.setCanceled(true);
                double d0 = mob.m_20185_() - player.m_20185_();
                double d1 = mob.m_20189_() - player.m_20189_();
                mob.m_21573_().m_26573_();
                mob.m_20256_(mob.m_20184_().m_82520_(Math.signum(d0) * 0.1, 0.0, Math.signum(d1) * 0.1));
            }
        }
    }
}

