/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.v_black_cat.goetydelight.ability.TimedAbilitySystem;
import net.v_black_cat.goetydelight.block.ModBlockEntities;
import net.v_black_cat.goetydelight.screen.NightStoveMenu;

public class NightStoveBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0};
    private int cookingProgress;
    private int cookingTotalTime;
    private int effectTimer;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> NightStoveBlockEntity.this.cookingProgress;
                case 1 -> NightStoveBlockEntity.this.cookingTotalTime;
                case 2 -> NightStoveBlockEntity.this.effectTimer;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    NightStoveBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 1: {
                    NightStoveBlockEntity.this.cookingTotalTime = value;
                    break;
                }
                case 2: {
                    NightStoveBlockEntity.this.effectTimer = value;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };
    private final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck;
    private final RecipeType<? extends AbstractCookingRecipe> recipeType = RecipeType.f_44110_;

    public NightStoveBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.NIGHT_STOVE_BE.get(), pPos, pBlockState);
        this.quickCheck = RecipeManager.m_220267_(this.recipeType);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"goetydelight.container.night_stove");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pPlayerInventory) {
        return new NightStoveMenu(pContainerId, pPlayerInventory, (Container)this, this.dataAccess);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pIndex) {
        return (ItemStack)this.items.get(pIndex);
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return ContainerHelper.m_18969_(this.items, (int)pIndex, (int)pCount);
    }

    public ItemStack m_8016_(int pIndex) {
        return ContainerHelper.m_18966_(this.items, (int)pIndex);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pIndex);
        boolean flag = !pStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pIndex, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (pIndex == 0 && !flag) {
            this.cookingTotalTime = this.getTotalCookTime();
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        this.cookingProgress = pTag.m_128451_("CookTime");
        this.cookingTotalTime = pTag.m_128451_("CookTimeTotal");
        this.effectTimer = pTag.m_128451_("EffectTimer");
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("CookTime", this.cookingProgress);
        pTag.m_128405_("CookTimeTotal", this.cookingTotalTime);
        pTag.m_128405_("EffectTimer", this.effectTimer);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
    }

    public int[] m_7071_(Direction pSide) {
        if (pSide == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return pSide == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.m_7013_(pIndex, pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return pIndex == 0;
    }

    private boolean isWorking() {
        return this.cookingProgress > 0;
    }

    private boolean canBurn(@Nullable Recipe<?> pRecipe) {
        if (((ItemStack)this.items.get(0)).m_41619_() || pRecipe == null) {
            return false;
        }
        ItemStack result = pRecipe.m_5874_((Container)this, this.f_58857_.m_9598_());
        if (result.m_41619_()) {
            return false;
        }
        ItemStack currentResult = (ItemStack)this.items.get(1);
        if (currentResult.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41656_((ItemStack)currentResult, (ItemStack)result)) {
            return false;
        }
        return currentResult.m_41613_() + result.m_41613_() <= this.m_6893_() && currentResult.m_41613_() + result.m_41613_() <= currentResult.m_41741_();
    }

    private boolean burn(@Nullable Recipe<?> pRecipe) {
        if (pRecipe != null && this.canBurn(pRecipe)) {
            ItemStack input = (ItemStack)this.items.get(0);
            ItemStack result = pRecipe.m_5874_((Container)this, this.f_58857_.m_9598_());
            ItemStack currentResult = (ItemStack)this.items.get(1);
            if (currentResult.m_41619_()) {
                this.items.set(1, (Object)result.m_41777_());
            } else if (currentResult.m_150930_(result.m_41720_())) {
                currentResult.m_41769_(result.m_41613_());
            }
            input.m_41774_(1);
            return true;
        }
        return false;
    }

    private int getTotalCookTime() {
        int baseCookTime = this.quickCheck.m_213657_((Container)this, this.f_58857_).map(AbstractCookingRecipe::m_43753_).orElse(200);
        float speedMultiplier = this.getCookingSpeedMultiplier();
        return (int)((float)baseCookTime / speedMultiplier);
    }

    private float getCookingSpeedMultiplier() {
        if (this.f_58857_ == null) {
            return 2.0f;
        }
        int skyLight = this.f_58857_.m_45517_(LightLayer.SKY, this.f_58858_);
        int blockLight = this.f_58857_.m_45517_(LightLayer.BLOCK, this.f_58858_);
        boolean isNighttime = skyLight <= 10 && blockLight <= 10;
        return isNighttime ? 4.0f : 2.0f;
    }

    private void applyEffectsToNearbyPlayers() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        AABB area = new AABB((double)(this.f_58858_.m_123341_() - 32), (double)(this.f_58858_.m_123342_() - 32), (double)(this.f_58858_.m_123343_() - 32), (double)(this.f_58858_.m_123341_() + 32), (double)(this.f_58858_.m_123342_() + 32), (double)(this.f_58858_.m_123343_() + 32));
        List players = this.f_58857_.m_45976_(Player.class, area);
        for (Player player : players) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0, false, false));
            TimedAbilitySystem.addAbilityToEntity((LivingEntity)player, "night_stove", 200);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NightStoveBlockEntity blockEntity) {
        boolean hasInput;
        boolean isWorkingBefore = blockEntity.isWorking();
        boolean changed = false;
        boolean bl = hasInput = !((ItemStack)blockEntity.items.get(0)).m_41619_();
        if (hasInput) {
            Recipe recipe = blockEntity.quickCheck.m_213657_((Container)blockEntity, level).orElse(null);
            if (blockEntity.canBurn(recipe)) {
                float speedMultiplier = blockEntity.getCookingSpeedMultiplier();
                blockEntity.cookingProgress = (int)((float)blockEntity.cookingProgress + speedMultiplier);
                if (blockEntity.cookingProgress >= blockEntity.cookingTotalTime) {
                    blockEntity.cookingProgress = 0;
                    blockEntity.cookingTotalTime = blockEntity.getTotalCookTime();
                    if (blockEntity.burn(recipe)) {
                        // empty if block
                    }
                    changed = true;
                }
            } else {
                blockEntity.cookingProgress = 0;
            }
        } else if (blockEntity.cookingProgress > 0) {
            blockEntity.cookingProgress = Mth.m_14045_((int)(blockEntity.cookingProgress - 2), (int)0, (int)blockEntity.cookingTotalTime);
        }
        ++blockEntity.effectTimer;
        if (blockEntity.effectTimer >= 100) {
            blockEntity.effectTimer = 0;
            blockEntity.applyEffectsToNearbyPlayers();
        }
        if (isWorkingBefore != blockEntity.isWorking()) {
            changed = true;
            level.m_7731_(pos, state, 3);
        }
        if (changed) {
            blockEntity.m_6596_();
        }
    }
}

