/*
 * Decompiled with CFR 0.152.
 */
package net.v_black_cat.goetydelight.block;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.v_black_cat.goetydelight.GoetyDelight;
import net.v_black_cat.goetydelight.block.RenderBlockEntity;
import net.v_black_cat.goetydelight.render.test.ModShaderInstance;
import net.v_black_cat.goetydelight.render.test.ModShaderReg;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class RenderBlockRenderer
implements BlockEntityRenderer<RenderBlockEntity> {
    private static final ResourceLocation DUMMY_TEXTURE = new ResourceLocation("goetydelight", "textures/effect/test_texture.png");
    private static final RenderType SHADER_RENDER_TYPE = RenderType.m_173215_((String)"shader_block", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> ModShaderReg.getFloridShader())).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(DUMMY_TEXTURE, false, false)).m_110691_(false));

    public RenderBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(RenderBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ModShaderInstance shader = (ModShaderInstance)ModShaderReg.getFloridShader();
        if (shader == null) {
            GoetyDelight.LOGGER.error("Florid shader is not registered!");
            return;
        }
        shader.setTime(blockEntity.getShaderTime());
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        VertexConsumer buffer = bufferSource.m_6299_(SHADER_RENDER_TYPE);
        float size = 0.5f;
        Vec3[] vertices = new Vec3[]{new Vec3((double)(-size), (double)(-size), 0.0), new Vec3((double)(-size), (double)size, 0.0), new Vec3((double)size, (double)size, 0.0), new Vec3((double)size, (double)(-size), 0.0)};
        for (Direction direction : Direction.values()) {
            poseStack.m_85836_();
            switch (direction) {
                case UP: {
                    poseStack.m_85837_(0.0, 0.5, 0.0);
                    break;
                }
                case DOWN: {
                    poseStack.m_85837_(0.0, -0.5, 0.0);
                    break;
                }
                case NORTH: {
                    poseStack.m_85837_(0.0, 0.0, 0.5);
                    break;
                }
                case SOUTH: {
                    poseStack.m_85837_(0.0, 0.0, -0.5);
                    break;
                }
                case EAST: {
                    poseStack.m_85837_(-0.5, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    poseStack.m_85837_(0.5, 0.0, 0.0);
                }
            }
            this.renderQuad(poseStack, buffer, vertices, direction, packedLight, packedOverlay);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void renderQuad(PoseStack poseStack, VertexConsumer buffer, Vec3[] vertices, Direction direction, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        Quaternionf rotation = RenderBlockRenderer.getQuaternionf(direction);
        poseStack.m_252781_(rotation);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        buffer.m_252986_(matrix, (float)vertices[0].f_82479_, (float)vertices[0].f_82480_, (float)vertices[0].f_82481_).m_7421_(0.0f, 0.0f).m_86008_(packedOverlay).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, (float)vertices[1].f_82479_, (float)vertices[1].f_82480_, (float)vertices[1].f_82481_).m_7421_(0.0f, 1.0f).m_86008_(packedOverlay).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, (float)vertices[2].f_82479_, (float)vertices[2].f_82480_, (float)vertices[2].f_82481_).m_7421_(1.0f, 1.0f).m_86008_(packedOverlay).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, (float)vertices[3].f_82479_, (float)vertices[3].f_82480_, (float)vertices[3].f_82481_).m_7421_(1.0f, 0.0f).m_86008_(packedOverlay).m_85969_(packedLight).m_5752_();
        poseStack.m_85849_();
    }

    @NotNull
    private static Quaternionf getQuaternionf(Direction direction) {
        Quaternionf rotation = new Quaternionf();
        switch (direction) {
            case UP: {
                rotation.rotateX((float)Math.toRadians(90.0));
                break;
            }
            case DOWN: {
                rotation.rotateX((float)Math.toRadians(-90.0));
                break;
            }
            case NORTH: {
                rotation.rotateY((float)Math.toRadians(180.0));
                break;
            }
            case EAST: {
                rotation.rotateY((float)Math.toRadians(90.0));
                break;
            }
            case WEST: {
                rotation.rotateY((float)Math.toRadians(-90.0));
                break;
            }
            case SOUTH: {
                rotation.rotateY((float)Math.toRadians(0.0));
                break;
            }
        }
        return rotation;
    }
}

